package com.xunlei.niux.data.vipgame.bo;

import java.util.List;
import com.ferret.common.dao.BaseDao;
import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.vipgame.vo.QuestionReply;
import com.xunlei.niux.data.vipgame.vo.QuestionSettings;

public class QuestionReplyBoImpl implements QuestionReplyBo {

    private BaseDao baseDao;
	
	public BaseDao getBaseDao() {
		return baseDao;
	}

	public void setBaseDao(BaseDao baseDao) {
		this.baseDao = baseDao;
	}

	@Override
	public int count(QuestionReply reply) {
		return baseDao.count(reply);
	}
	
	@Override
	public void deleteById(long id) {
		baseDao.deleteById(QuestionSettings.class, id);
	}

	@Override
	public List<QuestionReply> find(QuestionReply reply, int pageNo,
			int pageSize) {
		Page page = new Page();
		page.setPageNo(pageNo);
		page.setPageSize(pageSize);
		page.addOrder("dealtime", OrderType.ESC);
		return baseDao.findByObject(QuestionReply.class, reply, page);
	}

	@Override
	public QuestionReply findById(long id) {
		return baseDao.findById(QuestionReply.class, id);
	}

	@Override
	public void insert(QuestionReply reply) {
		 baseDao.insert(reply);
	}

	@Override
	public void update(QuestionReply reply) {
		baseDao.updateById(reply);
	}
	
	public  List findBySql(Class clazz, String preSql, List paramList) {
		return baseDao.findBySql(clazz, preSql, paramList);
	}

}
