/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.data.vipgame.bo.vic;

import com.ferret.common.dao.BaseDao;
import com.xunlei.niux.data.vipgame.bo.vic.VicOperatorsBo;
import com.xunlei.niux.data.vipgame.vo.Games;
import com.xunlei.niux.data.vipgame.vo.vicclub.VicOperatorsGamesKpi;
import com.xunlei.niux.easyutils.commonutils.DateUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class VicOperatorsBoImpl
implements VicOperatorsBo {
    private BaseDao baseDao;

    public BaseDao getBaseDao() {
        return this.baseDao;
    }

    public void setBaseDao(BaseDao baseDao) {
        this.baseDao = baseDao;
    }

    @Override
    public List<VicOperatorsGamesKpi> getInGamesKpi(Long operatorId, String gameId) {
        String sql = "select * from vic_operators_games_kpi where 1=1 ";
        ArrayList<Object> list = new ArrayList<Object>();
        if (operatorId > 0L) {
            sql = sql + " and operatorId = ?";
            list.add(operatorId);
        }
        if (StringUtils.isNotEmpty((String)gameId)) {
            sql = sql + " and gameId = ?";
            list.add(gameId);
        }
        List gamesKpis = this.baseDao.findBySql(VicOperatorsGamesKpi.class, sql, list);
        return gamesKpis;
    }

    @Override
    public List<Games> getOutGamesKpi(Long operatorId, String gameId) {
        String sql = " select * from games where 1=1 ";
        ArrayList<String> list = new ArrayList<String>();
        if (StringUtils.isNotEmpty((String)gameId)) {
            sql = sql + " and gameId = ? ";
            list.add(gameId);
        }
        sql = sql + " order by editTime desc  limit 50 ";
        return this.baseDao.findBySql(Games.class, sql, list);
    }

    @Override
    public void out2in(Long operatorId, String[] gameIds) {
        if (gameIds == null || gameIds.length == 0) {
            return;
        }
        for (String gameId : gameIds) {
            VicOperatorsGamesKpi kpi = new VicOperatorsGamesKpi();
            kpi.setEditTime(DateUtil.getOrderTime());
            kpi.setOperatorId(operatorId);
            kpi.setStatus(1);
            kpi.setGameId(gameId);
            kpi.setCreateTime(DateUtil.getOrderTime());
            this.baseDao.insert((Object)kpi);
        }
    }

    @Override
    public void in2out(Long operatorId, String[] seqIds) {
        if (seqIds == null || seqIds.length == 0) {
            return;
        }
        String sql = "delete from vic_operators_games_kpi where operatorId = ? and seqId in (";
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(operatorId);
        for (String gameId : seqIds) {
            sql = sql + "?,";
            list.add(gameId);
        }
        sql = sql.substring(0, sql.length() - 1) + " ) and status=1 ";
        this.baseDao.execute(sql, list);
    }

    @Override
    public List<Games> getSelfGames(String trueName) {
        String sql = "select * from games where gameId in (select distinct gameId from vic_operators_games_kpi vogk left join vic_operators vo on vo.seqId=vogk.operatorId where vo.name= ? ) ";
        ArrayList<String> list = new ArrayList<String>(1);
        list.add(trueName);
        return this.baseDao.findBySql(Games.class, sql, list);
    }
}

