package com.xunlei.niux.data.vipgame.dao.activity.secondkill;

import com.ferret.common.dao.BaseDaoImpl;
import com.xunlei.niux.data.vipgame.vo.activity.SecondKillConfig;
import com.xunlei.niux.data.vipgame.vo.lottery.FreeLotteryChance;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.stereotype.Service;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

/**
 * Created by jamesjxin on 14-6-6.
 */
public class SecondKillConfigDaoImpl extends BaseDaoImpl implements SecondKillConfigDao{

    @Override
    public List<SecondKillConfig> getAllValidSecondKillConfigs() {
        final List<SecondKillConfig> secondKillConfigList = new ArrayList<SecondKillConfig>();

        String sql = "select seqId,actNo,startDate,endDate,releaseCount,releaseTime,secondKillMinutes,giftId from secondkillconfig where date(now()) < endDate;";

        getJdbcTemplate().query(sql,new RowCallbackHandler() {
            @Override
            public void processRow(ResultSet resultSet) throws SQLException {
                SecondKillConfig secondKillConfig = new SecondKillConfig();
                secondKillConfig.setSeqId(resultSet.getLong("seqId"));
                secondKillConfig.setActNo(resultSet.getString("actNo"));
                secondKillConfig.setStartDate(resultSet.getString("startDate"));
                secondKillConfig.setEndDate(resultSet.getString("endDate"));
                secondKillConfig.setReleaseCount(resultSet.getInt("releaseCount"));
                secondKillConfig.setReleaseTime(resultSet.getString("releaseTime"));
                secondKillConfig.setSecondKillMinutes(resultSet.getInt("releaseTime"));
                secondKillConfig.setSecondKillMinutes(resultSet.getInt("secondKillMinutes"));
                secondKillConfig.setGiftId(resultSet.getString("giftId"));
                secondKillConfigList.add(secondKillConfig);
            }
        });

        return secondKillConfigList;
    }
}
