package com.xunlei.niux.data.vipgame.bo.bonus;

import java.util.List;

import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.vipgame.vo.BonusProduct;
import com.xunlei.niux.data.vipgame.vo.bonus.ExchangeTrans;

public interface ExchangeTransBo{
	/**
	 * 插入兑换交易记录，并返回最近的交易。
	 * 返回的记录通过seqId判断新旧记录。如果seqId==null，表示新记录
	 * @param pTrans
	 * @return
	 */
	ExchangeTrans insert(final ExchangeTrans pTrans);
	/**
	 * 判断用户是否已经兑换该产品。如果已经兑换，返回最后一次兑换的交易记录。
	 * @param userId
	 * @param pBonusProduct
	 * @return
	 */
	ExchangeTrans checkUserExchanged(String userId,final BonusProduct pBonusProduct);
	/**
	 * 更新消费积分状态，并返回更新后的交易记录。扣除成功进入发放奖品阶段，失败就退还扣除的奖品并交易订单结束。
	 * @param pTrans
	 * @param isSuccess
	 * @return
	 */
	ExchangeTrans updateBonusConsumeStatus(ExchangeTrans pTrans,boolean isSuccess);
	/**
	 * 发放奖品结果更新，并将更新的记录返回。如果发放失败，需要返回产品，并且记录进入到返回积分阶段
	 * @param pTrans
	 * @param isSuccess
	 * @return
	 */
	ExchangeTrans updateProductGiveOutStatus(ExchangeTrans pTrans,boolean isSuccess);
	/**
	 * 积分退还成功
	 */
	ExchangeTrans updateBonusReturnSuccess(ExchangeTrans pTrans);
	List<ExchangeTrans> find(ExchangeTrans pTrans,Page page);
	ExchangeTrans findOne(ExchangeTrans pTrans,Page page);
	ExchangeTrans find(String exchangeNo);
	int count(ExchangeTrans pTrans);
}
