package com.xunlei.niux.data.vipgame.dao.games;

import com.ferret.common.dao.BaseDao;
import com.xunlei.niux.data.vipgame.dto.MobileGameDTO;
import com.xunlei.niux.data.vipgame.dto.game.GameDTO;
import com.xunlei.niux.data.vipgame.dto.game.KuaiWanGameDTO;
import com.xunlei.niux.data.vipgame.vo.Games;

import java.util.List;

/**
 * Created by jamesjxin on 14-6-25.
 */
public interface GamesDao extends BaseDao{

    List<GameDTO> queryWebGamesByKeyWord(String keyWord);

    List<GameDTO> queryAppGamesByKeyWord(String keyWord);

    List<GameDTO> queryAppGamesByKeyWordAndChanelId(String keyWord,String chanelId);

    List<GameDTO> getAllValidWebGames();

    List<GameDTO> getAllValidAppGames();

    List<GameDTO> getAllValidAppGamesByChanelId(String chanelId);

    public List<MobileGameDTO> getAllMobileGames();

    List<Games> queryGames(String keyWord,int limit);

    public Games getCurrentNewstMobileGame();

    /**
     * 获取发送给快玩的游戏数据
     * @return
     */
    List<KuaiWanGameDTO> getKuaiwanWebGames();

    List<KuaiWanGameDTO> getKuaiwanAppGames();
    
    /*
     * 欢乐谷
     */
    List<Games> queryHlgGamesByKeyWord(String keyWord);

    List<Games> queryRecommendPhoneGamelist();

    List<Games> queryNewHLGGamelist();

    List<Games> queryRecommendHLGGamelist();
    
    List<Games> queryHlgWebGamesByKeyWord(String keyWord);

    /**
     *
     * @param games     需要查询游戏
     * @param order     排序字段（多个可以用字符串类型为 field_ASC）
     * @param type      只有页游为1 只有手游为2 其他为全部
     * @return
     */
    List<Games> getBoxMoreGames(Games games  , int type,String[] order,Boolean limitTime);
}
