/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.data.vipgame.dao;

import com.ferret.common.dao.BaseDaoImpl;
import com.xunlei.niux.data.vipgame.dao.MobileGuildDao;
import com.xunlei.niux.data.vipgame.dto.GuildGameDto;
import com.xunlei.niux.data.vipgame.dto.MobileGuildSpreadDTO;
import com.xunlei.niux.data.vipgame.util.ObjectMapper;
import com.xunlei.niux.data.vipgame.vo.mobileguild.MobileGuildSpread;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.jdbc.core.RowMapper;

public class MobileGuildDaoImpl
extends BaseDaoImpl
implements MobileGuildDao {
    @Override
    public List<GuildGameDto> getGuildGames() {
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT g.gameId,g.gameName,t.firstSpell,t.outputTime from mobileguildgame t ");
        sql.append(" LEFT JOIN games  g on t.gameId=g.gameId where t.isDel=0 ");
        return this.getJdbcTemplate().query(sql.toString(), (RowMapper)new ObjectMapper(GuildGameDto.class));
    }

    @Override
    public List<MobileGuildSpreadDTO> getGuildSpread(long uid, String seqIds, int pageIndex, int pageSize) {
        StringBuilder sql = new StringBuilder();
        ArrayList<Number> args = new ArrayList<Number>();
        sql.append(" SELECT t.appSize, t.appVersion,t.downloadUrl,t.gameId, t.guildUserId, t.inputTime,");
        sql.append("(case WHEN t.hasFinished=1 then '\u6253\u5305\u6210\u529f' else '\u6253\u5305\u4e2d' end)  hasFinished,");
        sql.append(" t.platform,t.seqId,g.gameName ");
        sql.append(" FROM mobileguildspread t ");
        sql.append(" LEFT JOIN games g ON t.gameId = g.gameId ");
        sql.append(" WHERE 1=1 ");
        if (uid != 0L) {
            sql.append(" and t.guildUserId = ? ");
            args.add(uid);
        }
        if (StringUtils.isNotEmpty((String)seqIds)) {
            sql.append(" and t.seqId in ( " + seqIds + " ) ");
        }
        sql.append(" order by t.inputTime desc ");
        if (pageIndex > 0 && pageSize > 0) {
            sql.append(" limit ?,? ");
            int pageStart = (pageIndex - 1) * pageSize < 0 ? 0 : (pageIndex - 1) * pageSize;
            args.add(pageStart);
            args.add(pageSize);
        }
        return this.getJdbcTemplate().query(sql.toString(), args.toArray(), (RowMapper)new ObjectMapper(MobileGuildSpreadDTO.class, false, false));
    }

    @Override
    public int countGuildSpread(long uid, String seqIds) {
        StringBuilder sql = new StringBuilder();
        ArrayList<Long> args = new ArrayList<Long>();
        sql.append(" SELECT count(1) ");
        sql.append(" FROM mobileguildspread t ");
        sql.append(" LEFT JOIN games g ON t.gameId = g.gameId ");
        sql.append(" WHERE 1=1 ");
        if (uid != 0L) {
            sql.append(" and t.guildUserId = ? ");
            args.add(uid);
        }
        if (StringUtils.isNotEmpty((String)seqIds)) {
            sql.append(" and t.seqId in ( " + seqIds + " ) ");
        }
        sql.append(" order by t.inputTime desc ");
        return this.getJdbcTemplate().queryForInt(sql.toString(), args.toArray());
    }

    @Override
    public List<MobileGuildSpread> getGuildSpread(long uid, String seqIds) {
        StringBuilder sql = new StringBuilder();
        ArrayList<Long> args = new ArrayList<Long>();
        sql.append(" SELECT t.seqId, t.guildUserId,t.gameId,t.appVersion, t.appSize,t.channelId,t.apkId, ");
        sql.append(" t.platform,t.inputTime,t.downloadUrl,t.hasFinished");
        sql.append(" FROM mobileguildspread t ");
        sql.append(" WHERE 1=1 ");
        if (uid != 0L) {
            sql.append(" and t.guildUserId = ? ");
            args.add(uid);
        }
        if (StringUtils.isNotEmpty((String)seqIds)) {
            sql.append(" and t.seqId in ( " + seqIds + " ) ");
        }
        sql.append(" order by t.inputTime desc ");
        return this.getJdbcTemplate().query(sql.toString(), (RowMapper)new ObjectMapper(MobileGuildSpread.class));
    }

    @Override
    public List<MobileGuildSpreadDTO> getGuildGameInfo(String gameIds) {
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT t.gameId,t.appVersion,g.gameNo,a.apkName,g.appSize,t.apkId from mobileguildgame t ");
        sql.append(" LEFT JOIN games g on t.gameId=g.gameId LEFT JOIN mobileGameApk a on t.apkId=a.apkId WHERE 1=1 ");
        if (StringUtils.isNotEmpty((String)gameIds)) {
            sql.append(" and t.gameId in ( " + gameIds + " ) ");
        }
        return this.getJdbcTemplate().query(sql.toString(), (RowMapper)new ObjectMapper(MobileGuildSpreadDTO.class, false, false));
    }

    @Override
    public List<MobileGuildSpread> getPackagedSpreads(String apkIds, String gameids, String uids) {
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT * from mobileguildspread  where 1=1 ");
        if (StringUtils.isNotEmpty((String)gameids)) {
            sql.append(" and gameId in ( " + gameids + " ) ");
        }
        if (StringUtils.isNotEmpty((String)uids)) {
            sql.append(" and guildUserId in ( " + uids + " ) ");
        }
        if (StringUtils.isNotEmpty((String)apkIds)) {
            sql.append(" and apkId in ( " + apkIds + " ) ");
        }
        return this.getJdbcTemplate().query(sql.toString(), (RowMapper)new ObjectMapper(MobileGuildSpread.class, false, false));
    }
}

