package com.xunlei.niux.data.vipgame.vo.crystal;

import org.codehaus.jackson.annotate.JsonIgnoreProperties;

import com.ferret.common.dao.annotation.Column;
import com.ferret.common.dao.annotation.Table;
import com.ferret.common.dao.enums.Operator;

/**
 * 理财套餐购买订单记录
 * 
 * @author HuangGuangHao
 */
@Table(tableName = "financialRecords", pkFieldName = "seqId", pkFieldAssign = false)
@JsonIgnoreProperties({"seqId", "beginBuyTime", "endBuyTime"})
public class FinancialRecords {
	private Long seqId; 		// 主键
	private String orderId;		// 订单号
	private Integer price;		// 理财套餐价格
	private Integer crystal;	// 水晶数量
	private Integer days;		// 理财周期
	private Integer rebate;		// 收益比例
	private String endTime;		// 套餐结束时间
	private String userId;		// 购买人的用户ID
	private String buyTime;		// 套餐购买时间
	private String status;		// 1:理财套餐使用到期 0 :理财套餐使用还没有到期
	private String orderStatus;	// 支付网关回调订单的状态 1：已回调 0：未回调
	@Column(columnName="buyTime",isWhereColumn=true,operator=Operator.GE)
	private String beginBuyTime;
	@Column(columnName="buyTime",isWhereColumn=true,operator=Operator.LE)
	private String endBuyTime;

	public Long getSeqId() {
		return seqId;
	}

	public void setSeqId(Long seqId) {
		this.seqId = seqId;
	}

	public String getOrderId() {
		return orderId;
	}

	public void setOrderId(String orderId) {
		this.orderId = orderId;
	}

	public Integer getPrice() {
		return price;
	}

	public void setPrice(Integer price) {
		this.price = price;
	}

	public Integer getCrystal() {
		return crystal;
	}

	public void setCrystal(Integer crystal) {
		this.crystal = crystal;
	}

	public Integer getDays() {
		return days;
	}

	public void setDays(Integer days) {
		this.days = days;
	}

	public Integer getRebate() {
		return rebate;
	}

	public void setRebate(Integer rebate) {
		this.rebate = rebate;
	}

	public String getEndTime() {
		return endTime;
	}

	public void setEndTime(String endTime) {
		this.endTime = endTime;
	}

	public String getUserId() {
		return userId;
	}

	public void setUserId(String userId) {
		this.userId = userId;
	}

	public String getBuyTime() {
		return buyTime;
	}

	public void setBuyTime(String buyTime) {
		this.buyTime = buyTime;
	}

	public String getStatus() {
		return status;
	}

	public void setStatus(String status) {
		this.status = status;
	}

	public String getBeginBuyTime() {
		return beginBuyTime;
	}

	public void setBeginBuyTime(String beginBuyTime) {
		this.beginBuyTime = beginBuyTime;
	}

	public String getEndBuyTime() {
		return endBuyTime;
	}

	public void setEndBuyTime(String endBuyTime) {
		this.endBuyTime = endBuyTime;
	}

	public String getOrderStatus() {
		return orderStatus;
	}

	public void setOrderStatus(String orderStatus) {
		this.orderStatus = orderStatus;
	}

	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("FinancialRecords [seqId=").append(seqId)
				.append(", orderId=").append(orderId).append(", price=")
				.append(price).append(", crystal=").append(crystal)
				.append(", days=").append(days).append(", rebate=")
				.append(rebate).append(", endTime=").append(endTime)
				.append(", userId=").append(userId).append(", buyTime=")
				.append(buyTime).append(", status=").append(status)
				.append(", beginBuyTime=").append(beginBuyTime)
				.append(", endBuyTime=").append(endBuyTime).append("]");
		return builder.toString();
	}

}
