package com.xunlei.niux.data.vipgame.bo.vic;

import com.ferret.common.dao.BaseDao;
import com.ferret.common.dao.presql.Select;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.vipgame.dto.vic.AdviceDTO;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;

/**
 * Created by zy on 2016/4/25.
 */
@Service
public class VicAdviceBoImpl implements VicAdviceBo {

    @Resource(name="BaseDao")
    private BaseDao baseDao;

    public BaseDao getBaseDao() {
        return baseDao;
    }

    public void setBaseDao(BaseDao baseDao) {
        this.baseDao = baseDao;
    }

    @Override
    public List<AdviceDTO> getAdviceDTOs(AdviceDTO dto, Page page) {
        String sql ="select advice.*, advice.redBoldTime>=NOW() as isRedBold  from vic_advice advice where 1=1  ";
        List<Object> param = new ArrayList<Object>();

        if(StringUtils.isNotEmpty(dto.getGameId())){
            sql += " and advice.gameid = ? ";
            param.add(dto.getGameId());
        }

        if(StringUtils.isNotEmpty(dto.getAdviceType())){
            sql += " and advice.adviceType = ? ";
            param.add(dto.getAdviceType());
        }

        if(StringUtils.isNotEmpty(dto.getTitle())){
            sql += " and advice.title = ? ";
            param.add(dto.getTitle());
        }

        if(page!=null){
            Select select = new Select(dto, page);
            sql += select.createOrder(dto,page);
            sql += select.createLimit(page);

        }

        List<AdviceDTO> dtos = baseDao.findBySql(AdviceDTO.class, sql, param);
        return dtos;
    }

}
