package com.xunlei.niux.data.vipgame.bo;

import java.util.List;

import com.ferret.common.dao.BaseDao;
import com.ferret.common.dao.BaseDaoImpl;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.vipgame.bo.ChargeAmountProfileSettingsBo;
import com.xunlei.niux.data.vipgame.vo.ChargeAmountProfileSettings;

public class ChargeAmountProfileSettingsBoImpl extends BaseDaoImpl implements ChargeAmountProfileSettingsBo {

	private BaseDao baseDao;
	
	public BaseDao getBaseDao() {
		return baseDao;
	}

	public void setBaseDao(BaseDao baseDao) {
		this.baseDao = baseDao;
	}
	public List<ChargeAmountProfileSettings> findChargeAmountProfileSettingsList(){
		 return baseDao.findBySql(ChargeAmountProfileSettings.class, "select * from chargeamountprofilesettings order by amount asc");
   }
	
	public int queryForInt(String sql,Object args[]){
		return getJdbcTemplate().queryForInt(sql, args);
	}
	
	@Override
	public int count(ChargeAmountProfileSettings settings) {
		return baseDao.count(settings);
	}

	@Override
	public void deleteById(long id) {
		baseDao.deleteById(ChargeAmountProfileSettings.class, id);
	}

	@Override
	public List<ChargeAmountProfileSettings> find(
			ChargeAmountProfileSettings settings, int pageNo, int pageSize) {
		Page page = new Page();
		page.setPageNo(pageNo);
		page.setPageSize(pageSize);
		return baseDao.findByObject(ChargeAmountProfileSettings.class, settings, page);
	}

	@Override
	public ChargeAmountProfileSettings findById(long id) {
		return baseDao.findById(ChargeAmountProfileSettings.class, id);
	}

	@Override
	public void insert(ChargeAmountProfileSettings settings) {
		baseDao.insert(settings);
	}

	@Override
	public void update(ChargeAmountProfileSettings settings) {
		baseDao.updateById(settings);
	}
	
	public List findBySql(Class clazz, String preSql, List paramList){
		 return baseDao.findBySql(clazz, preSql, paramList);
	}

}
