package com.xunlei.niux.data.vipgame.bo;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import org.springframework.util.CollectionUtils;

import com.ferret.common.dao.BaseDao;
import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.vipgame.bt.bonus.BonusProductBT;
import com.xunlei.niux.data.vipgame.dto.BonusProductDTO;
import com.xunlei.niux.data.vipgame.vo.BonusProduct;
import com.xunlei.niux.data.vipgame.vo.bonus.BonusProductCharge;
import com.xunlei.niux.data.vipgame.vo.boxThree.BoxBonusProductCharge;

public class BonusProductBoImpl implements BonusProductBo {
	private BaseDao baseDao;
	public BaseDao getBaseDao() {
		return baseDao;
	}
	public void setBaseDao(BaseDao baseDao) {
		this.baseDao = baseDao;
	}
	/**
	 * 查询游戏内容
	 * @param content
	 * @param start
	 * @param limit
	 * @return
	 */
	public List<BonusProduct> find(BonusProduct product,int pageNo,int pageSize){
		Page page=new Page();
		page.setPageNo(pageNo);
		page.setPageSize(pageSize);
		page.addOrder("inputTime", OrderType.DESC);
		return baseDao.findByObject(BonusProduct.class, product, page);
	}
	
	/**
	 * 更新积分商城积分兑换数量
	 */
	public BonusProductCharge updateProductLeftCount(String productId,boolean flag){
		StringBuilder sql = new StringBuilder();
		sql.append("select * from bonusproductcharge where productId=? for update");
		List<Object> list = new ArrayList<Object>();
		list.add(productId);
		List<BonusProductCharge> bpcList = baseDao.executeQuery(BonusProductCharge.class, sql.toString(), list);
		BonusProductCharge bpc = CollectionUtils.isEmpty(bpcList)?null:bpcList.get(0);
		BonusProductBT.checkProductEnoughExchange(bpc);
		int amount = flag?1:-1;
		bpc.setLeftCount(bpc.getLeftCount()-amount);
		bpc.setUsedCount(bpc.getUsedCount()+amount);
//		if(compareTime(bpc.getValdateTime(), DateUtil.formatNowByDefault())<0){
//			throw new RuntimeException("该奖品已过期");
//		}
		bpc.setExchangeCount(bpc.getExchangeCount()+amount);//商品兑换总数量
		baseDao.updateById(bpc);
		return bpc;
	}
	
	  public  long compareTime(String fromtime, String totime)
	    {
	        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
	        Date one = null;
	        Date two = null;
	        long days = 0L;
	        try
	        {
	        	if(fromtime != null){
	        		if(fromtime.length()==10){
	        			fromtime = fromtime +" 00:00:00";
	        		}
	        	}
	            one = df.parse(fromtime);
	            two = df.parse(totime);
	            long time1 = one.getTime();
	            long time2 = two.getTime();
	            long diff = time1 - time2;
	            days = diff ;
	        }
	        catch(ParseException e)
	        {
	           return -1;
	        }
	        return days;
	    }
	
	
	/**
	 * 消费积分
	 * @param productNo
	 * @param productNum
	 * @return
	 */
	public BonusProduct update_consume(String productNo){
		StringBuilder sb=new StringBuilder();
		sb.append("select * from bonusproduct where productNo=? for update");
		List<Object> list=new ArrayList<Object>();
		list.add(productNo);
		List<BonusProduct> bplist=baseDao.executeQuery(BonusProduct.class, sb.toString(),list);
		BonusProduct bp=(bplist==null||bplist.size()==0)?null:bplist.get(0);
		//验证是否够兑换，不够兑换抛出异常
		BonusProductBT.checkProductEnoughExchange(bp);
		
		bp.setProductNum(bp.getProductNum()-1);
		bp.setUsedSum(bp.getUsedSum()+1);
		baseDao.updateById(bp);
		return bp;
	}
	/**
	 * 返还失败扣留的物品
	 * @param productNo
	 * @param productNum
	 */
	public void update_rechargefailconsum(String productNo){
		StringBuilder sb=new StringBuilder();
		sb.append("select * from bonusproduct where productNo=? for update");
		List<Object> list=new ArrayList<Object>();
		list.add(productNo);
		List<BonusProduct> bplist=baseDao.executeQuery(BonusProduct.class, sb.toString(),list);
		BonusProduct bp=(bplist==null||bplist.size()==0)?null:bplist.get(0);
		if(bp==null){
			throw new RuntimeException("产品不存在");
		}
		bp.setProductNum(bp.getProductNum()+1);
		bp.setUsedSum(bp.getUsedSum()-1);
		baseDao.updateById(bp);
	}

    /**
     * 充值
     * @param pProduct
     */
	public void update_recharge(BonusProduct pProduct){
		if(pProduct.getProductNo()==null||"".equals(pProduct.getProductNo())){
			throw new RuntimeException("产品不存在");
		}
		StringBuilder sb=new StringBuilder();
		sb.append("select * from bonusproduct where productNo=? for update");
		List<Object> list=new ArrayList<Object>();
		list.add(pProduct.getProductNo());
		List<BonusProduct> bplist=baseDao.executeQuery(BonusProduct.class, sb.toString(),list);
		BonusProduct bp=(bplist==null||bplist.size()==0)?null:bplist.get(0);
		if(bp==null){
			throw new RuntimeException("产品不存在");
		}
		bp.setProductNum(bp.getProductNum()+pProduct.getProductNum());
		bp.setProductSum(bp.getProductSum()+pProduct.getProductNum());
		if(bp.getProductNum()<0){
			throw new RuntimeException("可用产品数不能小于0");
		}
		bp.setEditBy(pProduct.getEditBy());
		bp.setEditTime(pProduct.getEditTime());
		baseDao.updateById(bp);
	}
	public void updateSomeData(BonusProduct pProduct){
		StringBuilder sb=new StringBuilder();
		sb.append("select * from bonusproduct where productNo=? for update");
		List<Object> list=new ArrayList<Object>();
		list.add(pProduct.getProductNo());
		List<BonusProduct> bplist=baseDao.executeQuery(BonusProduct.class, sb.toString(),list);
		BonusProduct bp=(bplist==null||bplist.size()==0)?null:bplist.get(0);
		if(bp==null){
			throw new RuntimeException("产品不存在");
		}
		bp.setProductName(pProduct.getProductName());
		bp.setPrice(pProduct.getPrice());
		bp.setVipPrice(pProduct.getVipPrice());
		bp.setEverydayMaxNum(pProduct.getEverydayMaxNum());
		bp.setUserEverydayMaxNum(pProduct.getUserEverydayMaxNum());
		bp.setUserRestrictMaxNum(pProduct.getUserRestrictMaxNum());
		bp.setRestrictDays(pProduct.getRestrictDays());
		bp.setContent(pProduct.getContent());
		bp.setEditBy(pProduct.getEditBy());
		bp.setEditTime(pProduct.getEditTime());
		bp.setProductStatus(pProduct.getProductStatus());
		bp.setValidPeriod(pProduct.getValidPeriod());
		bp.setMinGameLevel(pProduct.getMinGameLevel()==null?0:pProduct.getMinGameLevel());
		bp.setSuccessTipLink(pProduct.getSuccessTipLink());
		bp.setSuccessTips(pProduct.getSuccessTips());
		bp.setGiveOutType(pProduct.getGiveOutType());
		bp.setMinJinKaLevel(pProduct.getMinJinKaLevel());
		bp.setIsQuFenServer(pProduct.getIsQuFenServer());
		bp.setPlatForm(pProduct.getPlatForm());
		bp.setExchangeDirect(pProduct.getExchangeDirect());
		bp.setGameId(pProduct.getGameId());
		bp.setIsNeedBaiJinVip(pProduct.getIsNeedBaiJinVip());
		bp.setProductLot(pProduct.getProductLot());
		bp.setBaseUnitNum(pProduct.getBaseUnitNum());
		bp.setProductType(pProduct.getProductType());
		bp.setIsSelectRole(pProduct.getIsSelectRole());//add by lisu 2013-08-06 增加是否需要选角色标志
		baseDao.updateById(bp);
	}
	public List<BonusProduct> findBonusProduct(BonusProduct product,Page page){
		return baseDao.findByObject(BonusProduct.class, product, page);
	}
	public BonusProduct findBonusProductById(long seqId){
		return baseDao.findById(BonusProduct.class, seqId);
	}
	public int count(BonusProduct product){
		return baseDao.count(product);
	}
	public void update(BonusProduct product){
		 baseDao.updateById(product);
	}
	public void insert(BonusProduct product) {
		baseDao.insert(product);
	}
	public void delete(Long seqId) {
		baseDao.deleteById(BonusProduct.class, seqId);
	}
	
	public void execute(String sql, List<Object> list) {
		baseDao.execute(sql, list);
		
	}
	public List executeQuery(Class class1, String sql, List list) {       
		return baseDao.executeQuery(class1, sql, list);
	}

    @Override
    public List<BonusProductDTO> getBonusProductRankingList(int limit) {
        String sql = "select bonusproduct.*,linkinfo.smallpicurl as smallPic from linkinfo\n" +
                "join bonusproduct on linkinfo.linklocid = '1273' and linkinfo.linktitle = bonusproduct.seqId\n" +
                "order by (bonusproduct.productsum - bonusproduct.productnum) DESC limit ?;";

        List<Object> list=new ArrayList<Object>();
        list.add(limit);
        List<BonusProductDTO> bplist=baseDao.executeQuery(BonusProductDTO.class, sql ,list);
        return bplist;
    }
	@Override
	public BoxBonusProductCharge updateProductLeftCount(String productId, boolean flag, String type) {
		StringBuilder sql = new StringBuilder();
		sql.append("select * from boxbonusproductcharge where productId=? for update");
		List<Object> list = new ArrayList<Object>();
		list.add(productId);
		List<BoxBonusProductCharge> bpcList = baseDao.executeQuery(BoxBonusProductCharge.class, sql.toString(), list);
		BoxBonusProductCharge bpc = CollectionUtils.isEmpty(bpcList)?null:bpcList.get(0);
		BonusProductBT.checkProductEnoughExchange(bpc);
		int amount = flag?1:-1;
		bpc.setLeftCount(bpc.getLeftCount()-amount);
		bpc.setUsedCount(bpc.getUsedCount()+amount);
//		if(compareTime(bpc.getValdateTime(), DateUtil.formatNowByDefault())<0){
//			throw new RuntimeException("该奖品已过期");
//		}
		bpc.setExchangeCount(bpc.getExchangeCount()+amount);//商品兑换总数量
		baseDao.updateById(bpc);
		return bpc;
	}
}
