package com.xunlei.niux.data.vipgame.bo;

import java.util.List;

import com.xunlei.niux.data.vipgame.vo.SendMailRecord;
import com.xunlei.niux.data.vipgame.vo.SmsSenderInfo;

public interface SmsSenderInfoBo {
	
	
	/**
	 * 插入发送电话纪录 
	 * @param phones
	 * @param sid
	 */
	public void insert(List<String> phones, long sid);
	
	/**
	 * 更新已发送电话纪录
	 * @param smsSenderInfo
	 */
	public void updateSenderedStauts(String phone, long sid);
	
	
	
	/**
	 * 根据申请订单id返回未发送的手机号码列表
	 * @param sid
	 * @return
	 */
	public List<String> findPhoneUnSender(long sid);
	
	/**
	 * 根据申请订单id返回总数量
	 * @param sid
	 * @return
	 */
	public long count(long sid);
	
	/**
	 * 根据申请订单id返回已发送总数量
	 * @param sid
	 * @return
	 */
	public long countSendered(long sid);
	
	/**
	 * 根据申请订单id返回发送电话纪录
	 * @param sid
	 * @param phone
	 * @return
	 */
	public SmsSenderInfo findObjectBySid(long sid,String phone);
}
