package com.xunlei.niux.data.vipgame.bo;

import java.util.ArrayList;
import java.util.List;
import com.ferret.common.dao.BaseDao;
import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.vipgame.dao.games.GamesDao;
import com.xunlei.niux.data.vipgame.dto.MobileGameDTO;
import com.xunlei.niux.data.vipgame.dto.game.GameDTO;
import com.xunlei.niux.data.vipgame.vo.Games;

public class GamesBoImpl implements GamesBo {
	private GamesDao gamesDao;
	private BaseDao baseDao;
	public BaseDao getBaseDao() {
		return baseDao;
	}
	public void setBaseDao(BaseDao baseDao) {
		this.baseDao = baseDao;
	}
    public GamesDao getGamesDao() {
        return gamesDao;
    }

    public void setGamesDao(GamesDao gamesDao) {
        this.gamesDao = gamesDao;
    }

    public List<Games> findGames(Games games,int pageno,int limit){
		Page page=new Page();
		page.setPageNo(pageno);
		page.setPageSize(limit);
		page.addOrder("displayOrder", OrderType.DESC);
		return gamesDao.findByObject(Games.class, games, page);
	}
	
	public List<Games> findGames(Games games,Page page){
		return gamesDao.findByObject(Games.class, games, page);
	}
	
	/**
	 * 通过gameid查询游戏信息
	 * @param gameId
	 * @return
	 */
	public Games getGameByGameId(String gameId){
		if(gameId==null||"".equals(gameId)){
			return null;
		}
		Games game=new Games();
		game.setGameId(gameId);
		List<Games> list=gamesDao.findByObject(Games.class, game, new Page());
		return (list!=null&&list.size()>0)?list.get(0):null;
	}
	public int count(Games games){
		return gamesDao.count(games);
	}
	public Games findGamesById(long seqId){
		return gamesDao.findById(Games.class, seqId);
	}
	public void insertGames(Games games){
        gamesDao.insert(games);
	}
	public void updateGames(Games games){
        gamesDao.updateById(games);
	}

    @Override
    public List<GameDTO> queryGamesByKeyWord(String keyWord,int gameType) {
        if(gameType == 1){
            return gamesDao.queryAppGamesByKeyWord(keyWord);
        }else {
            return gamesDao.queryWebGamesByKeyWord(keyWord);
        }
    }

    @Override
    public List<GameDTO> getAllValidAppGames() {
        return gamesDao.getAllValidAppGames();
    }

    @Override
    public List<Games> queryGames(String keyWord,int limit) {
        return gamesDao.queryGames(keyWord,limit);
    }


    @Override
    public Games getCurrentNewstMobileGame() {
        return gamesDao.getCurrentNewstMobileGame();
    }

    /**
     * 查询所有配置过下载地址，已经接入的手游及cps游戏
     */
	@Override
	public List<MobileGameDTO> getAllMobileGames() {
        return gamesDao.getAllMobileGames();
	}
    
    
}
