package com.xunlei.niux.data.vipgame.bo;

import com.xunlei.niux.data.vipgame.dao.MobileGameExtInfoDao;
import com.xunlei.niux.data.vipgame.dto.MobleGamesDTO;
import com.xunlei.niux.data.vipgame.vo.Games;
import com.xunlei.niux.data.vipgame.vo.MobileGameExtInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * Created by zy on 2016/3/14.
 */
@Service
public class MobileGameExtInfoBoImpl implements MobileGameExtInfoBo {

    @Autowired
    private MobileGameExtInfoDao mobileGameExtInfoDao;

    public MobileGameExtInfoDao getMobileGameExtInfoDao() {
        return mobileGameExtInfoDao;
    }

    public void setMobileGameExtInfoDao(MobileGameExtInfoDao mobileGameExtInfoDao) {
        this.mobileGameExtInfoDao = mobileGameExtInfoDao;
    }


    @Override
    public List<MobleGamesDTO> getMoibleGameExtInfos(int pageNo, int pageSize, String gameId, String gameNo, String gameName, String status, String orderBy) {
        return mobileGameExtInfoDao.getMoibleGameExtInfos(pageNo,pageSize,gameId,gameNo,gameName,status,orderBy);
    }

    @Override
    @Transactional
    public void updateMobileGameInfo(Games games, MobileGameExtInfo extInfo) {
        mobileGameExtInfoDao.updateMobileGameInfo(games,extInfo);
    }

    @Override
    @Transactional
    public void addMobileGameInfo(Games games, MobileGameExtInfo extInfo) {
        mobileGameExtInfoDao.addMobileGameInfo(games,extInfo);
    }
}
