package com.xunlei.niux.data.vipgame.dao;

import com.ferret.common.dao.BaseDaoImpl;
import com.xunlei.niux.data.vipgame.dto.MobileGuildSpreadDTO;
import com.xunlei.niux.data.vipgame.util.ObjectMapper;
import com.xunlei.niux.data.vipgame.vo.Games;
import com.xunlei.niux.data.vipgame.vo.mobileguild.MobileGuildSpread;
import org.apache.commons.lang.StringUtils;
import org.springframework.jdbc.core.RowMapper;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

/**
 * Created by Dean on 2016/4/21.
 */
public class MobileGuildDaoImpl extends BaseDaoImpl implements MobileGuildDao {

    private RowMapper gameRowMapper=new RowMapper() {
        @Override
        public Object mapRow(ResultSet rs, int i) throws SQLException {
            Games game=new Games();
            game.setGameId(rs.getString("gameId")==null?"":rs.getString("gameId"));
            game.setGameName(rs.getString("gameName")==null?"":rs.getString("gameName"));
            game.setSimpleName(rs.getString("simpleName")==null?"":rs.getString("simpleName"));
            game.setInputTime(rs.getString("inputTime")==null?"":rs.getString("inputTime"));
            return game;
        }
    };

    public List<Games> getGuildGames(String orderType,String firstSpells,String startDate,String endDate){
        StringBuilder sql=new StringBuilder();
        sql.append(" SELECT g.gameId,g.gameName,g.simpleName,t.outputTime inputTime from mobileguildgame t ");
        sql.append(" LEFT JOIN games  g on t.gameId=g.gameId where t.isDel=0 ");
        if("0".equals(orderType)){
            if(StringUtils.isNotEmpty(firstSpells)) {
                sql.append(" and t.firstSpell in ( " + firstSpells + ") ");
            }
            sql.append(" ORDER BY t.firstSpell ");
        }else if("1".equals(orderType)){
            if(StringUtils.isNotEmpty(startDate)){
                sql.append(" and t.inputTime>='"+startDate+"'");
            }
            if(StringUtils.isNotEmpty(endDate)){
                sql.append(" and t.inputTime<='"+endDate+"'");
            }
            sql.append(" ORDER BY t.outputTime ");

        }
        return getJdbcTemplate().query(sql.toString(),gameRowMapper);
    }

    public List<MobileGuildSpreadDTO> getGuildSpread(long uid,String seqIds,int pageIndex,int pageSize){
        StringBuilder sql=new StringBuilder();
        List<Object> args=new ArrayList<Object>();
        sql.append(" SELECT t.appSize, t.appVersion,t.downloadUrl,t.gameId, t.guildUserId, t.inputTime, ");
        sql.append(" t.platform,t.seqId,g.gameName ");
        sql.append(" FROM mobileguildspread t ");
        sql.append(" LEFT JOIN games g ON t.gameId = g.gameId ");
        sql.append(" WHERE 1=1 ");
        if(uid!=0){
            sql.append(" and t.guildUserId = ? ");
            args.add(uid);
        }
        if(StringUtils.isNotEmpty(seqIds)){
            sql.append(" and t.seqId in ( "+seqIds+" ) ");
        }
        sql.append(" order by t.inputTime desc ");
        if(pageIndex>0&&pageSize>0) {
            sql.append(" limit ?,? ");
            int pageStart = (pageIndex - 1) * pageSize < 0 ? 0 : (pageIndex - 1) * pageSize;
            args.add(pageStart);
            args.add(pageSize);
        }
        return getJdbcTemplate().query(sql.toString(),args.toArray(),new ObjectMapper(MobileGuildSpreadDTO.class,false,false));
    }

    public List<MobileGuildSpread> getGuildSpread(long uid,String seqIds){
        StringBuilder sql=new StringBuilder();
        List<Object> args=new ArrayList<Object>();
        sql.append(" SELECT t.seqId, t.guildUserId,t.gameId,t.appVersion, t.appSize, t.platform,t.inputTime,t.downloadUrl,t.hasFinished");
        sql.append(" FROM mobileguildspread t ");
        sql.append(" WHERE 1=1 ");
        if(uid!=0){
            sql.append(" and t.guildUserId = ? ");
            args.add(uid);
        }
        if(StringUtils.isNotEmpty(seqIds)){
            sql.append(" and t.seqId in ( "+seqIds+" ) ");
        }
        sql.append(" order by t.inputTime desc ");
        return findBySql(MobileGuildSpread.class,sql.toString(),args);
    }

    public List<MobileGuildSpreadDTO> getGuildGameInfo(String gameIds){
        StringBuilder sql=new StringBuilder();
        sql.append(" SELECT t.gameId,t.appVersion,g.gameNo,a.apkName,g.appSize from mobileguildgame t ");
        sql.append(" LEFT JOIN games g on t.gameId=g.gameId LEFT JOIN mobilegameapk a on t.apkId=a.apkId WHERE 1=1 ");
        if(StringUtils.isNotEmpty(gameIds)){
            sql.append(" and t.gameId in ( "+gameIds+" ) ");
        }
       return getJdbcTemplate().query(sql.toString(),new ObjectMapper(MobileGuildSpreadDTO.class,false,false));
    }



}
