package com.xunlei.niux.data.vipgame.bo.moyu;

import com.ferret.common.dao.BaseDao;
import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.vipgame.vo.moyu.MoyuServer;

import java.util.List;

/**
 * @author hezhong
 */
public class MoyuServerBoImpl implements MoyoServerBo {
    private BaseDao baseDao;

    public BaseDao getBaseDao() {
        return baseDao;
    }

    public void setBaseDao(BaseDao baseDao) {
        this.baseDao = baseDao;
    }


    @Override
    public List<MoyuServer> find(MoyuServer server, int pageNo, int pageSize) {
        Page page = new Page();
        page.setPageNo(pageNo);
        page.setPageSize(pageSize);
        page.addOrder("displayorder", OrderType.DESC);

        return this.baseDao.findByObject(MoyuServer.class, server, page);
    }

	@Override
	public int count(MoyuServer server) {
		return baseDao.count(server);
	}

	@Override
	public void execute(String sql, List<Object> list) {
		baseDao.execute(sql, list);
		
	}

	@Override
	public MoyuServer findById(String server) {
		return baseDao.findById(MoyuServer.class, server);
	}

	@Override
	public void insert(MoyuServer server) {
		baseDao.insert(server);
		
	}

	@Override
	public void update(MoyuServer server) {
		baseDao.updateById(server);
		
	}

	@Override
	public List<MoyuServer> executeQuery(String preSql, List<Object> paramList) {
		return baseDao.executeQuery(MoyuServer.class, preSql, paramList);
	}

    @Override
    public MoyuServer findByServerId(String serverId) {
        MoyuServer server = new MoyuServer();
        server.setServerid(serverId);

        List<MoyuServer> list = find(server, 1, 1);
        if(list.size() > 0) {
            return list.get(0);
        } else {
            return null;
        }
    }

	@Override
	public void deleteById(long id) {
		baseDao.deleteById(MoyuServer.class, id);
	}

}
