package com.xunlei.niux.data.vipgame.bo.gift;

import com.xunlei.niux.data.vipgame.dao.gift.GiftRecordDao;
import com.xunlei.niux.data.vipgame.dto.ActivityNGiftNGiftRecordDTO;
import com.xunlei.niux.data.vipgame.dto.GiftRecordDTO;
import com.xunlei.niux.data.vipgame.dto.ProductDTO;
import com.xunlei.niux.data.vipgame.vo.bonus.BonusProductChargeRecord;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * Created by jamesjxin on 14-4-17.
 */
public class GiftRecordBoImpl implements GiftRecordBo{

    private GiftRecordDao giftRecordDao;

    public void setGiftRecordDao(final GiftRecordDao giftRecordDao) {
        this.giftRecordDao = giftRecordDao;
    }

    @Override
    public List<GiftRecordDTO> getUnReleaseProductGiftRecord() {
        return giftRecordDao.getUnReleaseProductGiftRecord();
    }

	@Override
	public List<ProductDTO> getBonusProductChargeList(final int max) {
		return giftRecordDao.getBonusProductChargeList(max);
	}

    @Override
    public List<ProductDTO> getBonusProductChargeList(int listNum, boolean isTimeLimit, boolean isEntityGift) {
        return giftRecordDao.getBonusProductChargeList(listNum, isTimeLimit, isEntityGift);
    }

    @Override
    public List<ProductDTO> getBonusProductChargeList(int listNum, boolean isTimeLimit, boolean isEntityGift, boolean isBox) {
        return giftRecordDao.getBonusProductChargeList(listNum,isTimeLimit,isEntityGift,isBox);
    }

    @Override
    public List<ProductDTO> getTimeLimitBonusProductChargeList(final int max) {
        return giftRecordDao.getTimeLimitBonusProductChargeList(max);
    }

	@Override
	public List<?> getJiFenShopGiftRecord(final Class<?> object, final String userId,  Set<String> giftTypeParamSet, final int pageNo, final int pageSize) {
		return giftRecordDao.getJiFenShopGiftRecord(object, userId,giftTypeParamSet, pageNo, pageSize);
	}

    @Override
    public List<?> getUserGiftRecordByGiftType(Class<?> object, String userId,  Set<String> giftTypeParamSet, int pageNo, int pageSize) {
        return giftRecordDao.getUserGiftRecordByGiftType(object, userId,  giftTypeParamSet, pageNo, pageSize);
    }

    @Override
    public int countUserGiftRecordByGiftType(String userId, Set<String> giftTypeParamSet) {
        return giftRecordDao.countUserGiftRecordByGiftType(userId, giftTypeParamSet);
    }

    @Override
    public int coutJiFenShopGiftRecord(String userId,  Set<String> giftTypeParamSet) {
        return giftRecordDao.countJiFenShopGiftRecord(userId, giftTypeParamSet);
    }

    @Override
    public List<ActivityNGiftNGiftRecordDTO> getUserGiftRecordsByActNo(String userId, String actNo) {
        return giftRecordDao.getUserGiftRecordsByActNo(userId,actNo);
    }

	@Override
	public int countGiftRecordInOneDay(String userId, String date) {
		return giftRecordDao.countGiftRecordInOneDay(userId, date);
	}

    @Override
	public int countGiftRecord(String userId, String startTime, String endTime) {
		return giftRecordDao.countGiftRecord(userId, startTime, endTime);
	}

    @Override
    public int countGiftRecord(String userId, String giftType, String startTime, String endTime) {
        return giftRecordDao.countGiftRecord(userId, giftType, startTime, endTime);
    }

	@Override
	public List<ProductDTO> getBoxBonusProductChargeList(int listNum, boolean isTimeLimit, boolean isEntityGift) {
		 return giftRecordDao.getBoxBonusProductChargeList(listNum, isTimeLimit, isEntityGift);
	}

	@Override
	public List<ProductDTO> getDayBoxProduct(boolean isTimeLimit, boolean isEntityGift, int listNums,int giftId) {
		return giftRecordDao.getDayBoxProduct(isTimeLimit, isEntityGift, listNums,giftId);
	}

    @Override
    public int getBonusProductChargeRecordByDay(String userId, String giftId, String day) {
        return giftRecordDao.getBonusProductChargeRecordByDay(userId,giftId,day);
    }

    @Override
    public Map<String, Boolean> getBonusProductChargeRecordByDay(String day) {
        Map<String,Boolean> map = new HashMap<String, Boolean>();
        List<BonusProductChargeRecord> records = giftRecordDao.getBonusProductChargeRecordByDay(day);
        if(records==null||records.size()==0){
            return map;
        }
        for(BonusProductChargeRecord record : records){
            map.put(record.getUserId()+"_"+record.getProductId(),true);
        }
        return map;
    }


}
