package com.xunlei.niux.data.vipgame.bo;

import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.niux.data.vipgame.dao.MobileGuildDao;
import com.xunlei.niux.data.vipgame.dto.MobileGuildSpreadDTO;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.GameXmlMeta;
import com.xunlei.niux.data.vipgame.vo.Games;
import com.xunlei.niux.data.vipgame.vo.mobileguild.MobileGuildSpread;
import com.xunlei.niux.data.vipgame.vo.mobileguild.MobileGuildUser;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

/**
 * Created by Dean on 2016/4/21.
 */
@Service
public class MobileGuildBoImpl implements MobileGuildBo {

    private static final Logger logger = Logger.getLogger(MobileGuildBoImpl.class.getName());

    private static final String downloadurl = "http://preloaddown.boxsvr.niu.xunlei.com/webgame/";
    private static final String callbackurl = "http://dy.niu.xunlei.com/guild/speadCallBack.do";

    private static final String apkPath="";

    @Autowired
    private MobileGuildDao mobileGuildDao;

    public List<Games> getGuildGames(String orderType,String firstSpells,String startDate,String endDate){
        return mobileGuildDao.getGuildGames(orderType,firstSpells,startDate,endDate);
    }

    public List<MobileGuildSpreadDTO> getGuildSpread(long uid,String seqIds, int pageIndex, int pageSize){
        return mobileGuildDao.getGuildSpread(uid,seqIds,pageIndex,pageSize);
    }

    /**
     *  公会打包
     * @param uid
     * @param gameIds
     */
    public void packageSpead(long uid,String gameIds){
        MobileGuildUser user=new MobileGuildUser();
        user.setUserId(uid);
        MobileGuildUser user_db= FacadeFactory.INSTANCE.getBaseSo().findObject(user);
        if(null==user_db){
            throw new XLRuntimeException("用户不存在");
        }
        List<MobileGuildSpreadDTO> list=FacadeFactory.INSTANCE.getMobileGuildBo().getGuildInfo(gameIds);
        SimpleDateFormat sft=new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String nowStr=sft.format(new Date());
        StringBuffer gameNosb=new StringBuffer();
        StringBuffer apkNamesb=new StringBuffer();
        StringBuffer loginKeysb=new StringBuffer();
        StringBuffer seqIdsb=new StringBuffer();
        for(MobileGuildSpreadDTO mobileGuildSpreadDTO:list){
            String guiidApkName=getGuiidApkName(mobileGuildSpreadDTO.getApkName(),user_db.getChanelId());
            String url=downloadurl+mobileGuildSpreadDTO.getGameNo()+"/"+guiidApkName;
            MobileGuildSpread spread=bulidMobileGuildSpread(mobileGuildSpreadDTO,uid,url);
            spread.setInputTime(nowStr);

            loginKeysb.append(getLoginKey(mobileGuildSpreadDTO.getGameId())).append(",");
            gameNosb.append(mobileGuildSpreadDTO.getGameNo()).append(",");
            apkNamesb.append(guiidApkName).append(",");

            FacadeFactory.INSTANCE.getBaseSo().addObject(spread);

            MobileGuildSpread spread_db=FacadeFactory.INSTANCE.getBaseSo().findObject(spread);
            if(null!=spread_db){
                seqIdsb.append(spread_db.getSeqId()).append(",");
            }

        }
        String gameNos=subDotStr(gameNosb.toString());
        String apkNames=subDotStr(apkNamesb.toString());
        String loginKeys=subDotStr(loginKeysb.toString());
        String seqIds=subDotStr(seqIdsb.toString());
        String callBack=callbackurl+"?seqIds="+seqIds;
        packageSpead(callBack,user_db.getChanelId(),gameNos,apkNames,loginKeys);
    }

    private void packageSpead(String callBackUrl,String chanelId,String gameNos,String apkNames,String loginKeys){
        try {
            Runtime.getRuntime().exec(apkPath+"  "+callBackUrl+"  "+chanelId+"  "+gameNos+"  "+apkNames+"  "+loginKeys);
            logger.info("packageGuildSpead success "+"callBackUrl="+callBackUrl+",chanelId="+chanelId+",gameNos="+gameNos
                    +",apkNames="+apkNames+",loginKeys="+loginKeys);
        } catch (IOException e) {
            logger.error("packageGuildSpead IOException "+"callBackUrl="+callBackUrl+",chanelId="+chanelId+",gameNos="+gameNos
                    +",apkNames="+apkNames+",loginKeys="+loginKeys);
            e.printStackTrace();
        }

    }

    /**
     * 打包完成回调
     * @param seqIds
     */
    public void updateSpead(String seqIds){
        List<MobileGuildSpread> list=FacadeFactory.INSTANCE.getMobileGuildBo().getGuildSpread(0,seqIds);
        for(MobileGuildSpread mobileGuildSpread:list){
            if(!mobileGuildSpread.getHasFinished()){
                FacadeFactory.INSTANCE.getBaseSo().updateObjectById(mobileGuildSpread);
            }
        }
    }


    public List<MobileGuildSpread> getGuildSpread(long uid,String seqIds){
        return mobileGuildDao.getGuildSpread(uid,seqIds);
    }

    public List<MobileGuildSpreadDTO> getGuildInfo(String gameIds){
        return mobileGuildDao.getGuildGameInfo(gameIds);
    }

    private MobileGuildSpread bulidMobileGuildSpread(MobileGuildSpreadDTO mobileGuildSpreadDTO,long uid,String url){
        MobileGuildSpread spread=new MobileGuildSpread();
        spread.setAppVersion(mobileGuildSpreadDTO.getAppVersion());
        spread.setGameId(mobileGuildSpreadDTO.getGameId());
        spread.setAppSize(mobileGuildSpreadDTO.getAppSize());
        spread.setDownloadUrl(url);
        spread.setGuildUserId(uid);
        spread.setPlatform("安卓");
        spread.setHasFinished(false);
        return spread;
    }

    private String getLoginKey(String gameid){
        GameXmlMeta query = new GameXmlMeta();
        query.setNewgameid(gameid);
        GameXmlMeta meta = FacadeFactory.INSTANCE.getBaseSo().findObject(query);
        if(meta == null)return null;
        return meta.getLoginKey();
    }

    private String getGuiidApkName(String apkName,String chanelId){
        String pathName=null;
        apkName = apkName.replace(".apk", "");
        pathName = apkName+"_"+chanelId+".apk";
        return pathName;
    }


    public String getDotStr(String strs){
        strs=strs.replace("，",",");
        String[] spells=strs.split(",");
        StringBuffer sb=new StringBuffer();
        for(String str:spells){
            if(StringUtils.isNotEmpty(str)) {
                sb.append("'" + str + "',");
            }
        }
        strs=sb.toString();
        if(strs.endsWith(",")){
            strs=strs.substring(0,strs.length()-1);
        }
        return strs;
    }

    public String subDotStr(String str){
        if(StringUtils.isNotEmpty(str)&&str.endsWith(",")){
            str=str.substring(0,str.length()-1);
        }
        return str;
    }

}
