/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.data.vipgame.bo;

import com.ferret.common.dao.BaseDao;
import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.vipgame.bo.LinkInfoBo;
import com.xunlei.niux.data.vipgame.enums.game.GameClientTypeEnum;
import com.xunlei.niux.data.vipgame.vo.LinkInfo;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class LinkInfoBoImpl
implements LinkInfoBo {
    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final String[] linkids = new String[]{"690", "1509", "1514", "1513", "1510", "693", "1500", "1501", "1507", "1518", "1508", "1521", "1522", "1504"};
    private BaseDao baseDao;

    public BaseDao getBaseDao() {
        return this.baseDao;
    }

    public void setBaseDao(BaseDao baseDao) {
        this.baseDao = baseDao;
    }

    @Override
    public int count(LinkInfo linkInfo) {
        return this.baseDao.count((Object)linkInfo);
    }

    @Override
    public void delete(Integer linkid) {
        this.baseDao.deleteById(LinkInfo.class, (Number)linkid);
    }

    @Override
    public List<LinkInfo> find(LinkInfo linkInfo) {
        return this.baseDao.findByObject(LinkInfo.class, (Object)linkInfo, new Page());
    }

    @Override
    public LinkInfo find(Integer linkid) {
        return (LinkInfo)this.baseDao.findById(LinkInfo.class, (Number)linkid);
    }

    @Override
    public void update(LinkInfo linkInfo) {
        linkInfo = this.formatNull(linkInfo);
        this.baseDao.updateById((Object)linkInfo);
    }

    @Override
    public void add(LinkInfo linkInfo) {
        linkInfo = this.formatNull(linkInfo);
        linkInfo.setEditby(linkInfo.getInputby());
        linkInfo.setEdittime(linkInfo.getInputtime());
        this.baseDao.insert((Object)linkInfo);
    }

    @Override
    public List<LinkInfo> find(LinkInfo linkInfo, Page page) {
        return this.baseDao.findByObject(LinkInfo.class, (Object)linkInfo, page);
    }

    @Override
    public List<LinkInfo> getValidteLinkInfoListByLinkLocId(String linkLocid, int rownum, boolean isQueryTestData) {
        if (linkLocid == null || "".equals(linkLocid)) {
            return new ArrayList<LinkInfo>();
        }
        String now = sdf.format(new Date());
        LinkInfo qli = new LinkInfo();
        qli.setLinklocid(linkLocid);
        qli.setTovaliddatetime(now);
        if (!isQueryTestData) {
            qli.setIstest(false);
        }
        Page page = new Page();
        page.setPageNo(1);
        page.setPageSize(rownum);
        page.addOrder("validdatetime", OrderType.DESC);
        page.addOrder("displayorder", OrderType.DESC);
        return this.baseDao.findByObject(LinkInfo.class, (Object)qli, page);
    }

    @Override
    public LinkInfo getValidteLinkInfoByLinkLocId(String linkLocid, boolean isQueryTestData) {
        if (linkLocid == null || "".equals(linkLocid)) {
            return null;
        }
        for (int i = 0; i < linkids.length; ++i) {
            if (!linkids[i].equals(linkLocid)) continue;
            LinkInfo info = new LinkInfo();
            info.setLinklocid(linkLocid);
            String now = sdf.format(new Date());
            info.setTovaliddatetime(now);
            String invalidTime = sdf.format(new Date(System.currentTimeMillis() + 1000L));
            info.setFrominvaliddatetime(invalidTime);
            if (!isQueryTestData) {
                info.setIstest(false);
            }
            List<LinkInfo> list = this.getValidLinkInfoListByLinkInfo(info, 1, new String[]{"validdatetime", "displayorder"}, new OrderType[]{OrderType.DESC, OrderType.DESC});
            System.out.println("linkLocid:" + linkLocid + ",getLinktitle:" + (list != null && list.size() > 0 ? list.get(0).getLinktitle() : Integer.valueOf(0)));
            return list != null && list.size() > 0 ? list.get(0) : null;
        }
        String now = sdf.format(new Date());
        LinkInfo qli = new LinkInfo();
        qli.setLinklocid(linkLocid);
        qli.setTovaliddatetime(now);
        if (!isQueryTestData) {
            qli.setIstest(false);
        }
        Page page = new Page();
        page.setPageNo(1);
        page.setPageSize(1);
        page.addOrder("validdatetime", OrderType.DESC);
        page.addOrder("displayorder", OrderType.DESC);
        List list = this.baseDao.findByObject(LinkInfo.class, (Object)qli, page);
        return list != null && list.size() > 0 ? (LinkInfo)list.get(0) : null;
    }

    @Override
    public LinkInfo getValidteLinkInfoByLinkLocId_V2(String linkLocid, boolean isQueryTestData) {
        List<LinkInfo> list = this.getValidteLinkInfoListByLinkLocId_V2(linkLocid, 1, isQueryTestData);
        return list != null && list.size() > 0 ? list.get(0) : null;
    }

    @Override
    public List<LinkInfo> getGameValidteLinkInfoListByLinkLocId(String linkLocid, String gameId, int rownum, boolean isQueryTestData) {
        if (linkLocid == null || "".equals(linkLocid)) {
            return new ArrayList<LinkInfo>();
        }
        if (gameId == null || "".equals(gameId)) {
            return new ArrayList<LinkInfo>();
        }
        String now = sdf.format(new Date());
        LinkInfo qli = new LinkInfo();
        qli.setGameid(gameId);
        qli.setLinklocid(linkLocid);
        qli.setTovaliddatetime(now);
        if (!isQueryTestData) {
            qli.setIstest(false);
        }
        Page page = new Page();
        page.setPageNo(1);
        page.setPageSize(rownum);
        page.addOrder("validdatetime", OrderType.DESC);
        page.addOrder("displayorder", OrderType.DESC);
        return this.baseDao.findByObject(LinkInfo.class, (Object)qli, page);
    }

    @Override
    public List<LinkInfo> getLinkInfoByLinkLocIdandTime(String linkLocid, String fromvaliddatetime, String tovaliddatetime, boolean isQueryTestData) {
        if (linkLocid == null || "".equals(linkLocid)) {
            return new ArrayList<LinkInfo>();
        }
        LinkInfo qli = new LinkInfo();
        qli.setLinklocid(linkLocid);
        qli.setFromvaliddatetime(fromvaliddatetime);
        qli.setTovaliddatetime(tovaliddatetime);
        if (!isQueryTestData) {
            qli.setIstest(false);
        }
        Page page = new Page();
        page.setPageNo(0);
        page.setPageSize(0);
        page.addOrder("validdatetime", OrderType.DESC);
        return this.baseDao.findByObject(LinkInfo.class, (Object)qli, page);
    }

    @Override
    public LinkInfo getGameValidteLinkInfoByLinkLocId(String linkLocid, String gameId, boolean isQueryTestData) {
        if (linkLocid == null || "".equals(linkLocid)) {
            return null;
        }
        if (gameId == null || "".equals(gameId)) {
            return null;
        }
        String now = sdf.format(new Date());
        LinkInfo qli = new LinkInfo();
        qli.setLinklocid(linkLocid);
        qli.setGameid(gameId);
        qli.setTovaliddatetime(now);
        if (!isQueryTestData) {
            qli.setIstest(false);
        }
        Page page = new Page();
        page.setPageNo(1);
        page.setPageSize(1);
        page.addOrder("validdatetime", OrderType.DESC);
        page.addOrder("displayorder", OrderType.DESC);
        List list = this.baseDao.findByObject(LinkInfo.class, (Object)qli, page);
        return list != null && list.size() > 0 ? (LinkInfo)list.get(0) : null;
    }

    @Override
    public LinkInfo getGameValidteLinkInfoByLinkLocId_v2(String linkLocid, String gameId, boolean isQueryTestData) {
        List<LinkInfo> list = this.getGameValidteLinkInfoListByLinkLocId_v2(linkLocid, gameId, 1, isQueryTestData);
        return list == null || list.size() == 0 ? null : list.get(0);
    }

    @Override
    public List<LinkInfo> getGameValidteLinkInfoListByLinkLocId_v2(String linkLocid, String gameId, int rownum, boolean isQueryTestData) {
        LinkInfo li = new LinkInfo();
        li.setLinklocid(linkLocid);
        li.setGameid(gameId);
        li.setTovaliddatetime(sdf.format(new Date()));
        if (!isQueryTestData) {
            li.setIstest(false);
        }
        li.setIsvalid(true);
        Page page = new Page();
        page.setPageNo(1);
        page.setPageSize(rownum);
        page.addOrder("displaysort", OrderType.ESC);
        page.addOrder("validdatetime", OrderType.DESC);
        return this.baseDao.findByObject(LinkInfo.class, (Object)li, page);
    }

    public LinkInfo formatNull(LinkInfo linkInfo) {
        if (linkInfo == null) {
            return null;
        }
        linkInfo.setDisplayorder(this.defaultReplaceNull(linkInfo.getDisplayorder()));
        linkInfo.setExt1(this.defaultReplaceNull(linkInfo.getExt1()));
        linkInfo.setExt2(this.defaultReplaceNull(linkInfo.getExt2()));
        linkInfo.setExt3(this.defaultReplaceNull(linkInfo.getExt3()));
        linkInfo.setGameid(this.defaultReplaceNull(linkInfo.getGameid()));
        linkInfo.setGameidbytuijian(this.defaultReplaceNull(linkInfo.getGameidbytuijian()));
        linkInfo.setLinktitle(this.defaultReplaceNull(linkInfo.getLinktitle()));
        linkInfo.setSmallpicurl(this.defaultReplaceNull(linkInfo.getSmallpicurl()));
        linkInfo.setPicurl(this.defaultReplaceNull(linkInfo.getPicurl()));
        linkInfo.setLinkurl(this.defaultReplaceNull(linkInfo.getLinkurl()));
        linkInfo.setLinkdesc(this.defaultReplaceNull(linkInfo.getLinkdesc()));
        return linkInfo;
    }

    public String defaultReplaceNull(String value) {
        return value == null ? "" : value;
    }

    @Override
    public List<LinkInfo> getValidteLinkInfoListByLinkLocId_V2(String linkLocid, int rownum, boolean isQueryTestData) {
        return this.getValidteLinkInfoListByLinkLocId_V2(linkLocid, rownum, isQueryTestData, 1);
    }

    @Override
    public List<LinkInfo> getValidteLinkInfoListByLinkLocId_V2(String linkLocid, int rownum, boolean isQueryTestData, int isvalid) {
        return this.getValidteLinkInfoListByLinkLocId_V2(linkLocid, rownum, isQueryTestData, isvalid, "displaysort");
    }

    @Override
    public List<LinkInfo> getValidteLinkInfoListByLinkLocId_V2(String linkLocid, int rownum, boolean isQueryTestData, int isvalid, String orderColumn) {
        if (linkLocid == null || "".equals(linkLocid)) {
            return new ArrayList<LinkInfo>();
        }
        for (int i = 0; i < linkids.length; ++i) {
            if (!linkids[i].equals(linkLocid)) continue;
            String now = sdf.format(new Date());
            LinkInfo info = new LinkInfo();
            info.setLinklocid(linkLocid);
            info.setTovaliddatetime(now);
            String invalidTime = sdf.format(new Date(System.currentTimeMillis() + 1000L));
            info.setFrominvaliddatetime(invalidTime);
            if (!isQueryTestData) {
                info.setIstest(false);
            }
            if (isvalid > 0) {
                info.setIsvalid(true);
            }
            return this.getValidLinkInfoListByLinkInfo(info, rownum, new String[]{orderColumn, "validdatetime"}, new OrderType[]{OrderType.DESC, OrderType.DESC});
        }
        String now = sdf.format(new Date());
        LinkInfo qli = new LinkInfo();
        qli.setLinklocid(linkLocid);
        qli.setTovaliddatetime(now);
        if (!isQueryTestData) {
            qli.setIstest(false);
        }
        if (isvalid > 0) {
            qli.setIsvalid(true);
        }
        Page page = new Page();
        page.setPageNo(1);
        page.setPageSize(rownum);
        page.addOrder(orderColumn, OrderType.DESC);
        page.addOrder("validdatetime", OrderType.DESC);
        return this.baseDao.findByObject(LinkInfo.class, (Object)qli, page);
    }

    @Override
    public List<LinkInfo> getValidLinkInfoListByLinkInfo(LinkInfo linkinfo, int rownum, String[] orderColumn, OrderType[] orderType) {
        if (linkinfo == null) {
            return new ArrayList<LinkInfo>();
        }
        StringBuilder sb = new StringBuilder("select * from linkinfo where 1=1 ");
        ArrayList<Object> paramList = new ArrayList<Object>();
        if (linkinfo.getLinkid() != null) {
            sb.append(" and linkid = ? ");
            paramList.add(linkinfo.getLinkid());
        }
        if (!StringUtils.isEmpty((String)linkinfo.getLinklocid())) {
            sb.append(" and linkLocid = ? ");
            paramList.add(linkinfo.getLinklocid());
        }
        if (!StringUtils.isEmpty((String)linkinfo.getLinktitle())) {
            sb.append(" and linktitle = ? ");
            paramList.add(linkinfo.getLinktitle());
        }
        if (!StringUtils.isEmpty((String)linkinfo.getLinkdesc())) {
            sb.append(" and linkdesc = ? ");
            paramList.add(linkinfo.getLinkdesc());
        }
        if (!StringUtils.isEmpty((String)linkinfo.getLinkcontents())) {
            sb.append(" and linkcontents = ? ");
            paramList.add(linkinfo.getLinkcontents());
        }
        if (linkinfo.getIsredtitle() != null && linkinfo.getIsredtitle().booleanValue()) {
            sb.append(" and isredtitle = ? ");
            paramList.add(linkinfo.getIsredtitle());
        }
        if (linkinfo.getIsboldtitle() != null && linkinfo.getIsboldtitle().booleanValue()) {
            sb.append(" and isboldtitle = ? ");
            paramList.add(linkinfo.getIsboldtitle());
        }
        if (linkinfo.getIsjump() != null && linkinfo.getIsjump().booleanValue()) {
            sb.append(" and isjump = ? ");
            paramList.add(linkinfo.getIsjump());
        }
        if (!StringUtils.isEmpty((String)linkinfo.getLinkurl())) {
            sb.append(" and linkurl = ? ");
            paramList.add(linkinfo.getLinkurl());
        }
        if (!StringUtils.isEmpty((String)linkinfo.getPicurl())) {
            sb.append(" and picurl = ? ");
            paramList.add(linkinfo.getPicurl());
        }
        if (!StringUtils.isEmpty((String)linkinfo.getValiddatetime())) {
            sb.append(" and validdatetime = ? ");
            paramList.add(linkinfo.getValiddatetime());
        }
        if (!StringUtils.isEmpty((String)linkinfo.getInvaliddatetime())) {
            sb.append(" and invaliddatetime = ? ");
            paramList.add(linkinfo.getInvaliddatetime());
        }
        if (!StringUtils.isEmpty((String)linkinfo.getDisplayorder())) {
            sb.append(" and displayorder = ? ");
            paramList.add(linkinfo.getDisplayorder());
        }
        if (!StringUtils.isEmpty((String)linkinfo.getExt1())) {
            sb.append(" and ext1 = ? ");
            paramList.add(linkinfo.getExt1());
        }
        if (!StringUtils.isEmpty((String)linkinfo.getExt2())) {
            sb.append(" and ext2 = ? ");
            paramList.add(linkinfo.getExt2());
        }
        if (!StringUtils.isEmpty((String)linkinfo.getExt3())) {
            sb.append(" and ext3 = ? ");
            paramList.add(linkinfo.getExt3());
        }
        if (!StringUtils.isEmpty((String)linkinfo.getExt4())) {
            sb.append(" and ext4 = ? ");
            paramList.add(linkinfo.getExt4());
        }
        if (!StringUtils.isEmpty((String)linkinfo.getExt5())) {
            sb.append(" and ext5 = ? ");
            paramList.add(linkinfo.getExt5());
        }
        if (!StringUtils.isEmpty((String)linkinfo.getExt6())) {
            sb.append(" and ext6 = ? ");
            paramList.add(linkinfo.getExt6());
        }
        if (!StringUtils.isEmpty((String)linkinfo.getExt7())) {
            sb.append(" and ext7 = ? ");
            paramList.add(linkinfo.getExt7());
        }
        if (linkinfo.getExt8() != null) {
            sb.append(" and ext8 = ? ");
            paramList.add(linkinfo.getExt8());
        }
        if (!StringUtils.isEmpty((String)linkinfo.getFromvaliddatetime())) {
            sb.append(" and validdatetime >= ? ");
            paramList.add(linkinfo.getFromvaliddatetime());
        }
        if (!StringUtils.isEmpty((String)linkinfo.getTovaliddatetime())) {
            sb.append(" and validdatetime < ? ");
            paramList.add(linkinfo.getTovaliddatetime());
        }
        if (!StringUtils.isEmpty((String)linkinfo.getFrominvaliddatetime())) {
            sb.append(" and (invaliddatetime >= ? or invaliddatetime = '' or invaliddatetime is null) ");
            paramList.add(linkinfo.getFrominvaliddatetime());
        }
        if (!StringUtils.isEmpty((String)linkinfo.getToinvaliddatetime())) {
            sb.append(" and invaliddatetime < ? ");
            paramList.add(linkinfo.getToinvaliddatetime());
        }
        if (!StringUtils.isEmpty((String)linkinfo.getInputby())) {
            sb.append(" and inputby = ? ");
            paramList.add(linkinfo.getInputby());
        }
        if (!StringUtils.isEmpty((String)linkinfo.getInputtime())) {
            sb.append(" and inputtime = ? ");
            paramList.add(linkinfo.getInputtime());
        }
        if (!StringUtils.isEmpty((String)linkinfo.getEditby())) {
            sb.append(" and editby = ? ");
            paramList.add(linkinfo.getEditby());
        }
        if (!StringUtils.isEmpty((String)linkinfo.getEdittime())) {
            sb.append(" and edittime = ? ");
            paramList.add(linkinfo.getEdittime());
        }
        if (!StringUtils.isEmpty((String)linkinfo.getGameid())) {
            sb.append(" and gameid = ? ");
            paramList.add(linkinfo.getGameid());
        }
        if (linkinfo.getIstest() != null && linkinfo.getIstest().booleanValue()) {
            sb.append(" and istest = ? ");
            paramList.add(linkinfo.getIstest());
        }
        if (!StringUtils.isEmpty((String)linkinfo.getGameidbytuijian())) {
            sb.append(" and gameidbytuijian = ? ");
            paramList.add(linkinfo.getGameidbytuijian());
        }
        if (!StringUtils.isEmpty((String)linkinfo.getLinklocgroupid())) {
            sb.append(" and linklocgroupid = ? ");
            paramList.add(linkinfo.getLinklocgroupid());
        }
        if (!StringUtils.isEmpty((String)linkinfo.getSmallpicurl())) {
            sb.append(" and smallpicurl = ? ");
            paramList.add(linkinfo.getSmallpicurl());
        }
        if (!StringUtils.isEmpty((String)linkinfo.getLinklocgroupid())) {
            sb.append(" and linklocgroupid = ? ");
            paramList.add(linkinfo.getLinklocgroupid());
        }
        if (linkinfo.getDisplaysort() != null) {
            sb.append(" and displaysort = ? ");
            paramList.add(linkinfo.getDisplaysort());
        }
        if (linkinfo.getIsvalid() != null && linkinfo.getIsvalid().booleanValue()) {
            sb.append(" and isvalid = ? ");
            paramList.add(linkinfo.getIsvalid());
            String now = sdf.format(new Date());
            sb.append(" and validdatetime < ? and (invaliddatetime > ? or invaliddatetime = '' or invaliddatetime is null) ");
            paramList.add(now);
            paramList.add(now);
        }
        if (orderColumn != null && orderColumn.length > 0 && orderType != null && orderType.length == orderColumn.length) {
            sb.append(" order by ");
            for (int i = 0; i < orderColumn.length; ++i) {
                String type = "";
                if (orderType[i] == null || orderType[i] == OrderType.DESC) {
                    type = "desc";
                }
                if (i != 0) {
                    sb.append(",");
                }
                sb.append(" " + orderColumn[i] + " " + type);
            }
        }
        if (rownum > 0) {
            sb.append(" limit ? ");
            paramList.add(rownum);
        }
        return this.baseDao.executeQuery(LinkInfo.class, sb.toString(), paramList);
    }

    @Override
    public List<LinkInfo> getLinkListByOrderByLimit(String linkLocid, String orderColumn, OrderType orderType, boolean isQueryTestData) {
        return this.getLinkListByOrderByLimit(linkLocid, 0, orderColumn, orderType, isQueryTestData);
    }

    @Override
    public List<LinkInfo> getAllLinkListByLinkLocId(String linkLocId, boolean isQueryTestData) {
        return this.getLinkListByOrderByLimit(linkLocId, 0, "", OrderType.DESC, isQueryTestData);
    }

    @Override
    public List<LinkInfo> getLinkListByOrderByLimit(String linkLocid, int limit, String orderColumn, OrderType orderType, boolean isQueryTestData) {
        return this.getLinkListByOrderByLimit(linkLocid, limit, orderColumn, orderType, false, isQueryTestData);
    }

    @Override
    public List<LinkInfo> getLinkListByOrderByLimit(String linkLocid, int limit, String orderColumn, OrderType orderType, boolean isValid, boolean isQueryTestData) {
        for (int i = 0; i < linkids.length; ++i) {
            if (!linkids[i].equals(linkLocid)) continue;
            LinkInfo info = new LinkInfo();
            info.setLinklocid(linkLocid);
            if (!isQueryTestData) {
                info.setIstest(false);
            }
            if (isValid) {
                info.setIsvalid(true);
            }
            String now = sdf.format(new Date());
            info.setTovaliddatetime(now);
            String invalidTime = sdf.format(new Date(System.currentTimeMillis() + 1000L));
            info.setFrominvaliddatetime(invalidTime);
            String[] orderCol = null;
            OrderType[] orderT = null;
            if (StringUtils.isNotEmpty((String)orderColumn)) {
                orderCol = new String[]{orderColumn};
                orderT = new OrderType[]{orderType};
            }
            return this.getValidLinkInfoListByLinkInfo(info, limit, orderCol, orderT);
        }
        LinkInfo li = new LinkInfo();
        li.setLinklocid(linkLocid);
        if (!isQueryTestData) {
            li.setIstest(false);
        }
        if (isValid) {
            li.setIsvalid(true);
        }
        Page page = new Page();
        if (limit > 0) {
            page.setPageNo(1);
            page.setPageSize(limit);
        }
        if (StringUtils.isNotEmpty((String)orderColumn)) {
            page.addOrder(orderColumn, orderType);
        }
        return this.baseDao.findByObject(LinkInfo.class, (Object)li, page);
    }

    @Override
    public List<LinkInfo> getHotShouyouGiftList(int limit) {
        return this.getGiftListByClientTypeWithOrderByColumnDesc(GameClientTypeEnum.shouyou, "displaysort", limit);
    }

    @Override
    public List<LinkInfo> getGiftListByClientTypeWithOrderByColumnDesc(GameClientTypeEnum clientTypeEnum, String orderbyColumn, int limit) {
        String sql = "     SELECT gifts.* FROM\n     (SELECT * FROM linkinfo WHERE linklocid = '251')  AS gifts\n     LEFT JOIN games ON gifts.gameid = games.gameId\n     WHERE games.clientType = ?\n";
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(clientTypeEnum.getValue());
        if (StringUtils.isNotEmpty((String)orderbyColumn)) {
            if ("displaysort".equals(orderbyColumn)) {
                sql = sql + " order by displaysort desc ";
            } else if ("validdatetime".equals(orderbyColumn)) {
                sql = sql + " order by validdatetime desc ";
            }
        }
        if (limit > 0) {
            sql = sql + " limit ? ";
            list.add(limit);
        }
        List giftList = this.baseDao.findBySql(LinkInfo.class, sql, list);
        return giftList;
    }

    @Override
    public void updateNormalToWeihu(String shemaId, String shemaTime) {
        String sql = "UPDATE linkinfo li, gameservers gs SET gs.openstatus = '3'  WHERE li.ext4 = ? AND li.ext2 = ?  AND li.gameId = gs.gameId AND li.ext1 = gs.fenQuNum  AND gs.openstatus = '1' ";
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add(shemaId);
        paramList.add(shemaTime);
        this.baseDao.execute(sql, paramList);
    }

    @Override
    public void updateWeihuToNormal(String shemaId, String shemaTime) {
        String sql = "UPDATE linkinfo li, gameservers gs SET gs.openstatus = '1'  WHERE li.ext5 = ? AND li.ext3 = ?  AND li.gameId = gs.gameId AND li.ext1 = gs.fenQuNum  AND gs.openstatus = '3' ";
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add(shemaId);
        paramList.add(shemaTime);
        this.baseDao.execute(sql, paramList);
    }
}

