package com.xunlei.niux.data.vipgame.bo.tasks;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.vipgame.dao.tasks.UserTaskRecordDao;
import com.xunlei.niux.data.vipgame.dto.tasks.UserTaskRecordDTO;
import com.xunlei.niux.data.vipgame.vo.tasks.UserTaskRecord;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;

/**
 * Created by jamesjxin on 14-6-11.
 */
public class UserTaskRecordBoImpl implements UserTaskRecordBo{

    @Autowired
    private UserTaskRecordDao userTaskRecordDao;

    @Override
    public List<UserTaskRecordDTO> getAllUserTaskRecord(String userId) {

        return userTaskRecordDao.getAllUserTaskRecord(userId);
    }

    @Override
    public UserTaskRecord getUserTaskRecordByUserIdAndSeqId(long seqId, String userId) {
        UserTaskRecord query = new UserTaskRecord();
        query.setSeqId(seqId);
        query.setUserId(userId);

        List<UserTaskRecord> list = userTaskRecordDao.findByObject(UserTaskRecord.class,query,new Page());

        if(CollectionUtils.isEmpty(list)){
            return null;
        }

        return list.get(0);
    }

    @Override
    public UserTaskRecord getUserTaskRecordByUserIdAndSeqIdAndServerId(long seqId, String userId, String serverId){
        UserTaskRecord query = new UserTaskRecord();
//        query.setSeqId(seqId);
        query.setTaskConfSeqId(seqId);
        query.setUserId(userId);
        query.setServerId(serverId);
        Page page=new Page();
        page.addOrder("expireTime", OrderType.DESC);
        List<UserTaskRecord> list = userTaskRecordDao.findByObject(UserTaskRecord.class,query,page);

        if(CollectionUtils.isEmpty(list)){
            return null;
        }

        return list.get(0);
    }
}
