package com.xunlei.niux.data.vipgame.bo;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.vipgame.enums.game.GameClientTypeEnum;
import com.xunlei.niux.data.vipgame.vo.LinkInfo;

import java.util.List;

public interface LinkInfoBo {
	/**
	 * 删除
	 * @param linkid
	 */
	void delete(Integer linkid);
	/**
	 * 更新
	 * @param linkInfo
	 */
	void update(LinkInfo linkInfo);
	/**
	 * 新增
	 * @param linkInfo
	 */
	void add(LinkInfo linkInfo);
	/**
	 * 计算行
	 * @param linkInfo
	 * @return
	 */
	int count(LinkInfo linkInfo);
	/**
	 * 查询
	 * @param linkInfo
	 * @return
	 */
	List<LinkInfo> find(LinkInfo linkInfo);
	/**
	 * 分页查询或排序查询
	 * @param linkInfo
	 * @param page
	 * @return
	 */
	List<LinkInfo> find(LinkInfo linkInfo,Page page);
	/**
	 * 查询
	 * @param linkid
	 * @return
	 */
	LinkInfo find(Integer linkid);
	/**
	 * 通过linkLocid查询已生效的displayorder降序前1行数据。如果需要包含测试数据isQueryTestData=true
	 * @param linkLocid
	 * @param isQueryTestData
	 * @return
	 */
	LinkInfo getValidteLinkInfoByLinkLocId(String linkLocid,boolean isQueryTestData);
	/**
	 * 通过linkLocid查询已生效的displayorder降序前rownum行数据。如果需要包含测试数据isQueryTestData=true
	 * @param linkLocid
	 * @param rownum
	 * @param isQueryTestData
	 * @return
	 */
	List<LinkInfo> getValidteLinkInfoListByLinkLocId(String linkLocid,int rownum,boolean isQueryTestData);
	/**
	 * 通过linkLocid查询已生效的displayorder降序前1行的游戏数据。如果需要包含测试数据isQueryTestData=true
	 * @param linkLocid
	 * @param isQueryTestData
	 * @return
	 */
	LinkInfo getGameValidteLinkInfoByLinkLocId(String linkLocid,String gameId,boolean isQueryTestData);
	/**
	 * 通过linkLocid查询已生效的displayorder降序前rownum行游戏数据。如果需要包含测试数据isQueryTestData=true
	 * @param linkLocid
	 * @param rownum
	 * @param isQueryTestData
	 * @return
	 */
	List<LinkInfo> getGameValidteLinkInfoListByLinkLocId(String linkLocid,String gameId,int rownum,boolean isQueryTestData);

    /**
     * 通过linkLocid查询一段时间内的的displayorder升序数据。如果需要包含测试数据isQueryTestData=true
     * @param linkLocid
     * @param isQueryTestData
     * @return
     */
    List<LinkInfo> getLinkInfoByLinkLocIdandTime(String linkLocid,String fromvaliddatetime, String tovaliddatetime, boolean isQueryTestData);
	
//	List<LinkInfo> getValidteLinkInfoListByLinkLocId(String linkLocid,int rownum,boolean isQueryTestData);
	LinkInfo getGameValidteLinkInfoByLinkLocId_v2(String linkLocid,String gameId,boolean isQueryTestData);
	List<LinkInfo> getGameValidteLinkInfoListByLinkLocId_v2(String linkLocid,String gameId,int rownum,boolean isQueryTestData);
	LinkInfo getValidteLinkInfoByLinkLocId_V2(String linkLocid,boolean isQueryTestData);
	/**
	 * 通过linkLocid查询已生效的displayorder降序前rownum行数据。如果需要包含测试数据isQueryTestData=true
	 * @param linkLocid
	 * @param rownum
	 * @param isQueryTestData
	 * @return
	 */
	List<LinkInfo> getValidteLinkInfoListByLinkLocId_V2(String linkLocid,int rownum,boolean isQueryTestData);

    public List<LinkInfo> getValidteLinkInfoListByLinkLocId_V2(String linkLocid,int rownum,boolean isQueryTestData, int isvalid);

    List<LinkInfo> getValidteLinkInfoListByLinkLocId_V2(String linkLocid, int rownum, boolean isQueryTestData, int isvalid, String orderColumn);

    /**
     * 获取对应linkLocid的数据
     * @param linkLocid
     * @param orderColumn 排序字段
     * @param orderType 排序方式
     * @param isQueryTestData
     * @return
     */
    public List<LinkInfo> getLinkListByOrderByLimit(String linkLocid,String orderColumn,OrderType orderType,boolean isQueryTestData);

    public List<LinkInfo> getLinkListByOrderByLimit(String linkLocid,int limit, String orderColumn,OrderType orderType,boolean isQueryTestData);

    /**
     * 获取对应linkLocid的数据
     * @param linkLocid
     * @param limit
     * @param orderColumn
     * @param orderType
     * @param isValid  true:获取valid＝true的数据，false：获取所有数据
     * @param isQueryTestData
     * @return
     */
    public List<LinkInfo> getLinkListByOrderByLimit(String linkLocid, int limit, String orderColumn, OrderType orderType, boolean isValid, boolean isQueryTestData);

    /**
     * 获取所有linkLocId的数据，不考虑排序
     * @param linkLocId
     * @param isQueryTestData
     * @return
     */
    public List<LinkInfo> getAllLinkListByLinkLocId(String linkLocId,boolean isQueryTestData);


    /**
     *获取对应clientType=3(手游)的linklocId＝251的新手卡／礼包列表 displaysort desc 排序 前limit个
     * @return
     */
    public List<LinkInfo> getHotShouyouGiftList(int limit);


    /**
     * 获取对应clientType的linklocId＝251的新手卡／礼包列表
     * @param clientTypeEnum
     * @return
     */
    public List<LinkInfo> getGiftListByClientTypeWithOrderByColumnDesc(GameClientTypeEnum clientTypeEnum,String orderbyColumn,int limit);
	
    /**
     * 根据执行模板ID和时间，更新分区维护公告相关区服，开区改为维护
     * @param shemaId
     * @param shemaTime
     */
    void updateNormalToWeihu(String shemaId, String shemaTime);
	
    /**
     * 根据执行模板ID和时间，更新分区维护公告相关区服，维护改为开区 
     * @param shemaId
     * @param shemaTime
     */
    void updateWeihuToNormal(String shemaId, String shemaTime);
    
    /**
     * 根据LinkInfo配置，通过生效状态（生效时间段（包括生效时间和失效时间）和是否生效）返回
     * @param linkinfo
     * @param rownum
     * @param orderColumns
     * @param orderTypes
     * @return
     */
	List<LinkInfo> getValidLinkInfoListByLinkInfo(LinkInfo linkinfo,
			int rownum, String[] orderColumns, OrderType[] orderTypes);
}
