package com.xunlei.niux.data.vipgame.bo;

import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.vipgame.dto.MobileGameDTO;
import com.xunlei.niux.data.vipgame.dto.game.GameDTO;
import com.xunlei.niux.data.vipgame.dto.game.KuaiWanGameDTO;
import com.xunlei.niux.data.vipgame.vo.Games;

import java.util.List;

public interface GamesBo {
	List<Games> findGames(Games games,int start,int limit);
	List<Games> findGames(Games games,Page page);
	Games findGamesById(long seqId);
	void insertGames(Games games);
	void updateGames(Games games);
	int count(Games games);
	/**
	 * 通过gameid查询游戏信息
	 * @param gameId
	 * @return
	 */
	Games getGameByGameId(String gameId);
	
	Object getMobileGameByGameId(String gameId);

    List<GameDTO> queryGamesByKeyWord(String keyWord,int gameType);

    /**
     * get all valid web games
     * @return
     */
    List<GameDTO> getAllValidWebGames();

    /**
     * 获取所有的手游信息，包含cps游戏
     * @return
     */
    List<GameDTO> getAllValidAppGames();
    
    List<Games> queryGames(String keyWord,int limit);

    Games getCurrentNewstMobileGame();

    @Deprecated
    List<MobileGameDTO> getAllMobileGames();

    /**
     * 获取最新的cps游戏gameId
     * @return
     */
    String getNextNewCpsgameId();


    /**
     * 获取发送给快玩的游戏数据
     * @return
     */
    List<KuaiWanGameDTO> getKuaiwanWebGames();

    List<KuaiWanGameDTO> getKuaiwanAppGames();
    
    /*
     * 欢乐谷
     */
    List<Games> queryHlgGamesByKeyWord(String keyWord, int limit);

    /**
     *
     * @param games     需要查询游戏
     * @param order     排序字段（多个可以用字符串类型为 field_ASC）
     * @param type      只有页游为1 只有手游为2 其他为全部
     * @return
     */
    List<Games> getBoxMoreGames(Games games  , int type,String[] order,Boolean limitTime);

    /**
     * 获取欢乐谷热门（推荐）游戏
     * @return
     */
    List<Games> queryRecommendHLGGamelist();

    /**
     * 获取欢乐谷最新游戏
     * @return
     */
    List<Games> queryNewHLGGamelist();

    /**
     * 获取欢乐谷推荐手机游戏
     * @return
     */
    List<Games> queryRecommendPhoneGamelist();
}
