/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.data.vipgame.bo;

import com.ferret.common.dao.BaseDao;
import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.vipgame.bo.GamesBo;
import com.xunlei.niux.data.vipgame.dao.games.GamesDao;
import com.xunlei.niux.data.vipgame.dto.MobileGameDTO;
import com.xunlei.niux.data.vipgame.dto.game.GameDTO;
import com.xunlei.niux.data.vipgame.vo.Games;
import java.util.List;

public class GamesBoImpl
implements GamesBo {
    private GamesDao gamesDao;
    private BaseDao baseDao;

    public BaseDao getBaseDao() {
        return this.baseDao;
    }

    public void setBaseDao(BaseDao baseDao) {
        this.baseDao = baseDao;
    }

    public GamesDao getGamesDao() {
        return this.gamesDao;
    }

    public void setGamesDao(GamesDao gamesDao) {
        this.gamesDao = gamesDao;
    }

    @Override
    public List<Games> findGames(Games games, int pageno, int limit) {
        Page page = new Page();
        page.setPageNo(pageno);
        page.setPageSize(limit);
        page.addOrder("displayOrder", OrderType.DESC);
        return this.gamesDao.findByObject(Games.class, games, page);
    }

    @Override
    public List<Games> findGames(Games games, Page page) {
        return this.gamesDao.findByObject(Games.class, games, page);
    }

    @Override
    public Games getGameByGameId(String gameId) {
        if (gameId == null || "".equals(gameId)) {
            return null;
        }
        Games game = new Games();
        game.setGameId(gameId);
        List list = this.gamesDao.findByObject(Games.class, game, new Page());
        return list != null && list.size() > 0 ? (Games)list.get(0) : null;
    }

    @Override
    public int count(Games games) {
        return this.gamesDao.count(games);
    }

    @Override
    public Games findGamesById(long seqId) {
        return (Games)this.gamesDao.findById(Games.class, seqId);
    }

    @Override
    public void insertGames(Games games) {
        this.gamesDao.insert(games);
    }

    @Override
    public void updateGames(Games games) {
        this.gamesDao.updateById(games);
    }

    @Override
    public List<GameDTO> queryGamesByKeyWord(String keyWord, int gameType) {
        if (gameType == 1) {
            return this.gamesDao.queryAppGamesByKeyWord(keyWord);
        }
        return this.gamesDao.queryWebGamesByKeyWord(keyWord);
    }

    @Override
    public List<GameDTO> getAllValidAppGames() {
        return this.gamesDao.getAllValidAppGames();
    }

    @Override
    public List<Games> queryGames(String keyWord, int limit) {
        return this.gamesDao.queryGames(keyWord, limit);
    }

    @Override
    public Games getCurrentNewstMobileGame() {
        return this.gamesDao.getCurrentNewstMobileGame();
    }

    @Override
    public List<MobileGameDTO> getAllMobileGames() {
        return this.gamesDao.getAllMobileGames();
    }
}

