package com.xunlei.niux.data.vipgame.bo;

import com.ferret.common.dao.BaseDao;
import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.vipgame.enums.game.GameClientTypeEnum;
import com.xunlei.niux.data.vipgame.vo.LinkInfo;
import org.apache.commons.lang.StringUtils;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class LinkInfoBoImpl implements LinkInfoBo {
	private static SimpleDateFormat sdf=new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
	//盒子：猜你喜欢1502 近日火爆区服1509 首页flash广告1516
	private static final String [] linkids = new String[]{
		"690",//getBannerList  IndexPageBuilder getValidteLinkInfoListByLinkLocId_V2
		"1509",//开服列表旁边的火爆开服轮播图//盒子一样   IndexPageBuilder limit
		"1514",//本周推荐视频   IndexPageBuilder
		"1513",//本周推荐游戏   IndexPageBuilder 已修改，但不用了
		"1510",//牛友推荐   IndexPageBuilder limit
		"693",//getAdMap  IndexPageBuilder   getValidteLinkInfoByLinkLocId
		"1500",// 推荐游戏 获得热门游戏列表   GameCenterBuilder
		"1501"//活动页背景图   GameCenterBuilder
		,"1507"//左边、右边   HeaderBuilder
		,"1518"//搜索页猜你喜欢//盒子：1502    GameCenterBuilder
		,"1508",//getSearchHotList公用-搜索推荐词   HeaderBuilder
		"1521",//getGameAdMap常用广告位  HeaderBuilder  游戏列表广告
		"1522",//getAdvMap常用广告位  GameCenterBuilder  搜索页广告
		"1504"};//搜索词  HeaderBuilder
	private BaseDao baseDao;
	public BaseDao getBaseDao() {
		return baseDao;
	}
	public void setBaseDao(final BaseDao baseDao) {
		this.baseDao = baseDao;
	}
	public int count(final LinkInfo linkInfo) {
		return baseDao.count(linkInfo);
	}

	public void delete(final Integer linkid) {
		baseDao.deleteById(LinkInfo.class, linkid);
	}

	public List<LinkInfo> find(final LinkInfo linkInfo) {
		return baseDao.findByObject(LinkInfo.class, linkInfo, new Page());
	}

	public LinkInfo find(final Integer linkid) {
		return baseDao.findById(LinkInfo.class, linkid);
	}

	public void update(LinkInfo linkInfo) {
		linkInfo=formatNull(linkInfo);
		baseDao.updateById(linkInfo);
	}

	public void add(LinkInfo linkInfo) {
		linkInfo=formatNull(linkInfo);
		linkInfo.setEditby(linkInfo.getInputby());
		linkInfo.setEdittime(linkInfo.getInputtime());
		baseDao.insert(linkInfo);
	}
	public List<LinkInfo> find(final LinkInfo linkInfo, final Page page) {
		return baseDao.findByObject(LinkInfo.class, linkInfo, page);
	}
	/**
	 * 通过linkLocid查询已生效的displayorder降序前rownum行数据。如果需要包含测试数据isQueryTestData=true
	 * @param linkLocid
	 * @param rownum
	 * @param isQueryTestData
	 * @return
	 */
	public List<LinkInfo> getValidteLinkInfoListByLinkLocId(final String linkLocid,final int rownum,boolean isQueryTestData){
		if(linkLocid==null||"".equals(linkLocid)){
			return new ArrayList<LinkInfo>();
		}
		//获取当前时间
		String now =sdf.format(new Date());
		//查询条件
		LinkInfo qli=new LinkInfo();
		qli.setLinklocid(linkLocid);
		qli.setTovaliddatetime(now);
		if(!isQueryTestData){
			//只查询正式数据
			qli.setIstest(false);
		}
		//分页设置
		Page page=new Page();
		page.setPageNo(1);//第一页
		page.setPageSize(rownum);//第一行
		page.addOrder("validdatetime", OrderType.DESC);//生效时间
		page.addOrder("displayorder", OrderType.DESC);//按照降序排
		return  baseDao.findByObject(LinkInfo.class, qli, page);
	}

	/**
	 * 通过linkLocid查询已生效的displayorder降序前1行数据。如果需要包含测试数据isQueryTestData=true
	 * @param linkLocid
	 * @param isQueryTestData
	 * @return
	 */
	public LinkInfo getValidteLinkInfoByLinkLocId(final String linkLocid,boolean isQueryTestData){
		if(linkLocid==null||"".equals(linkLocid)){
			return null;
		}

        //推广连接自动更新
        for(int i = 0; i < linkids.length; i++){
        	if(linkids[i].equals(linkLocid)){
        		LinkInfo info = new LinkInfo();
        		info.setLinklocid(linkLocid);
        		String now =sdf.format(new Date());
        		info.setTovaliddatetime(now);
                String invalidTime =sdf.format(new Date(System.currentTimeMillis() + 1000));//失效时间提前一秒钟，这样模板执行的时候才会失效
                info.setFrominvaliddatetime(invalidTime);
        		if(!isQueryTestData){
        			//只查询正式数据
        			info.setIstest(false);
        		}
        		
        		List<LinkInfo> list = getValidLinkInfoListByLinkInfo(info, 1, new String[]{"validdatetime","displayorder"}, new OrderType[]{OrderType.DESC, OrderType.DESC});
        		System.out.println("linkLocid:"+linkLocid+",getLinktitle:" + ((list!=null&&list.size()>0)?list.get(0).getLinktitle():0));
        		return (list!=null&&list.size()>0)?list.get(0):null;
        	}
        }
        
        
		//获取当前时间
		String now =sdf.format(new Date());
		//查询条件
		LinkInfo qli=new LinkInfo();
		qli.setLinklocid(linkLocid);
		qli.setTovaliddatetime(now);
		if(!isQueryTestData){
			//只查询正式数据
			qli.setIstest(false);
		}
		//分页设置
		Page page=new Page();
		page.setPageNo(1);//第一页
		page.setPageSize(1);//第一行
		page.addOrder("validdatetime", OrderType.DESC);//生效时间
		page.addOrder("displayorder", OrderType.DESC);//按照降序排
		List<LinkInfo> list= baseDao.findByObject(LinkInfo.class, qli, page);
		return (list!=null&&list.size()>0)?list.get(0):null;
	}
	public LinkInfo getValidteLinkInfoByLinkLocId_V2(final String linkLocid,final boolean isQueryTestData){
		List<LinkInfo> list= getValidteLinkInfoListByLinkLocId_V2(linkLocid, 1, isQueryTestData);
		return (list!=null&&list.size()>0)?list.get(0):null;
	}
	/**
	 * 通过linkLocid查询已生效的displayorder降序前rownum行数据。如果需要包含测试数据isQueryTestData=true
	 * @param linkLocid
	 * @param rownum
	 * @param isQueryTestData
	 * @return
	 */
	public List<LinkInfo> getGameValidteLinkInfoListByLinkLocId(final String linkLocid,final String gameId,final int rownum,boolean isQueryTestData){
		if(linkLocid==null||"".equals(linkLocid)){
			return new ArrayList<LinkInfo>();
		}
		if(gameId==null||"".equals(gameId)){
			return new ArrayList<LinkInfo>();
		}
		//获取当前时间
		String now =sdf.format(new Date());
		//查询条件
		LinkInfo qli=new LinkInfo();
        qli.setGameid(gameId);
		qli.setLinklocid(linkLocid);
		qli.setTovaliddatetime(now);
		if(!isQueryTestData){
			//只查询正式数据
			qli.setIstest(false);
		}
		//分页设置
		Page page=new Page();
		page.setPageNo(1);//第一页
		page.setPageSize(rownum);//第一行
		page.addOrder("validdatetime", OrderType.DESC);//生效时间
		page.addOrder("displayorder", OrderType.DESC);//按照降序排
		return  baseDao.findByObject(LinkInfo.class, qli, page);
	}

    @Override
    public List<LinkInfo> getLinkInfoByLinkLocIdandTime(final String linkLocid, final String fromvaliddatetime, final String tovaliddatetime, boolean isQueryTestData) {
        if(linkLocid==null||"".equals(linkLocid)){
            return new ArrayList<LinkInfo>();
        }
        //查询条件
        LinkInfo qli=new LinkInfo();
        qli.setLinklocid(linkLocid);
        qli.setFromvaliddatetime(fromvaliddatetime);
        qli.setTovaliddatetime(tovaliddatetime);
        if(!isQueryTestData){
            //只查询正式数据
            qli.setIstest(false);
        }

        Page page=new Page();
        page.setPageNo(0);
        page.setPageSize(0);

        page.addOrder("validdatetime", OrderType.DESC);//生效时间
        return baseDao.findByObject(LinkInfo.class, qli, page);

    }

    /**
	 * 通过linkLocid查询已生效的displayorder降序前1行数据。如果需要包含测试数据isQueryTestData=true
	 * @param linkLocid
	 * @param gameId
	 * @param isQueryTestData
	 * @return
	 */
	public LinkInfo getGameValidteLinkInfoByLinkLocId(final String linkLocid,final String gameId,boolean isQueryTestData){
		if(linkLocid==null||"".equals(linkLocid)){
			return null;
		}
		if(gameId==null||"".equals(gameId)){
			return null;
		}
		//获取当前时间
		String now =sdf.format(new Date());
		//查询条件
		LinkInfo qli=new LinkInfo();
		qli.setLinklocid(linkLocid);
		qli.setGameid(gameId);
		qli.setTovaliddatetime(now);
		if(!isQueryTestData){
			//只查询正式数据
			qli.setIstest(false);
		}
		//分页设置
		Page page=new Page();
		page.setPageNo(1);//第一页
		page.setPageSize(1);//第一行
		page.addOrder("validdatetime", OrderType.DESC);//生效时间
		page.addOrder("displayorder", OrderType.DESC);//按照降序排
		//执行查询
		List<LinkInfo> list= baseDao.findByObject(LinkInfo.class, qli, page);
		return (list!=null&&list.size()>0)?list.get(0):null;
	}
	public LinkInfo getGameValidteLinkInfoByLinkLocId_v2(final String linkLocid,final String gameId,final boolean isQueryTestData){
		List<LinkInfo> list=getGameValidteLinkInfoListByLinkLocId_v2(linkLocid, gameId, 1, isQueryTestData);
		return (list==null||list.size()==0)?null:list.get(0);
	}
	public List<LinkInfo> getGameValidteLinkInfoListByLinkLocId_v2(final String linkLocid,final String gameId,final int rownum,boolean isQueryTestData){
		LinkInfo li=new LinkInfo();
		li.setLinklocid(linkLocid);
		li.setGameid(gameId);
		li.setTovaliddatetime(sdf.format(new Date()));
		if(!isQueryTestData){
	        li.setIstest(false);	        //只查询正式数据
	    }
		li.setIsvalid(true);
		
		Page page=new Page();
		page.setPageNo(1);//第一页
		page.setPageSize(rownum);//第一行
		page.addOrder("displaysort", OrderType.ESC);//按照升序序排
		page.addOrder("validdatetime", OrderType.DESC);//生效时间
		return  baseDao.findByObject(LinkInfo.class, li, page);
	}
	public LinkInfo formatNull(final LinkInfo linkInfo){
		if(linkInfo==null){
			return null;
		}
		linkInfo.setDisplayorder(defaultReplaceNull(linkInfo.getDisplayorder()));
		linkInfo.setExt1(defaultReplaceNull(linkInfo.getExt1()));
		linkInfo.setExt2(defaultReplaceNull(linkInfo.getExt2()));
		linkInfo.setExt3(defaultReplaceNull(linkInfo.getExt3()));
		linkInfo.setGameid(defaultReplaceNull(linkInfo.getGameid()));
		linkInfo.setGameidbytuijian(defaultReplaceNull(linkInfo.getGameidbytuijian()));
		linkInfo.setLinktitle(defaultReplaceNull(linkInfo.getLinktitle()));
		linkInfo.setSmallpicurl(defaultReplaceNull(linkInfo.getSmallpicurl()));
		linkInfo.setPicurl(defaultReplaceNull(linkInfo.getPicurl()));
		linkInfo.setLinkurl(defaultReplaceNull(linkInfo.getLinkurl()));
		linkInfo.setLinkdesc(defaultReplaceNull(linkInfo.getLinkdesc()));
		return linkInfo;
	}
	public String defaultReplaceNull(final String value){
		return value==null?"":value;
	}

    public List<LinkInfo> getValidteLinkInfoListByLinkLocId_V2(final String linkLocid,final int rownum,final boolean isQueryTestData){
        return getValidteLinkInfoListByLinkLocId_V2(linkLocid, rownum, isQueryTestData,1);
    }

    @Override
    public List<LinkInfo> getValidteLinkInfoListByLinkLocId_V2(final String linkLocid, final int rownum, boolean isQueryTestData, final int isvalid) {
        return getValidteLinkInfoListByLinkLocId_V2(linkLocid, rownum, isQueryTestData, isvalid, "displaysort");
    }

    @Override
    public List<LinkInfo> getValidteLinkInfoListByLinkLocId_V2(final String linkLocid, final int rownum, boolean isQueryTestData, final int isvalid, final String orderColumn) {
        if(linkLocid==null||"".equals(linkLocid)){
            return new ArrayList<LinkInfo>();
        }
        
        //推广连接自动更新
        for(int i = 0; i < linkids.length; i++){
        	if(linkids[i].equals(linkLocid)){

                String now =sdf.format(new Date());
                //查询条件
                LinkInfo info = new LinkInfo();
                info.setLinklocid(linkLocid);
                info.setTovaliddatetime(now);
                String invalidTime =sdf.format(new Date(System.currentTimeMillis() + 1000));//失效时间提前一秒钟，这样模板执行的时候才会失效
                info.setFrominvaliddatetime(invalidTime);
                if(!isQueryTestData){
                    //只查询正式数据
                	info.setIstest(false);
                }
                if(isvalid>0){
                	info.setIsvalid(true);
                }
                
        		return getValidLinkInfoListByLinkInfo(info, rownum, new String[]{orderColumn, "validdatetime"}, new OrderType[]{OrderType.DESC, OrderType.DESC});
        	}
        }
        
        //获取当前时间
        String now =sdf.format(new Date());
        //查询条件
        LinkInfo qli=new LinkInfo();
        qli.setLinklocid(linkLocid);
        qli.setTovaliddatetime(now);
        if(!isQueryTestData){
            //只查询正式数据
            qli.setIstest(false);
        }
        if(isvalid>0){
            qli.setIsvalid(true);
        }
        //分页设置
        Page page=new Page();
        page.setPageNo(1);//第一页
        page.setPageSize(rownum);//第一行
        page.addOrder(orderColumn, OrderType.DESC);//按照降序序排
        page.addOrder("validdatetime", OrderType.DESC);//生效时间
        return  baseDao.findByObject(LinkInfo.class, qli, page);
    }
    
    @Override
    public List<LinkInfo> getValidLinkInfoListByLinkInfo(LinkInfo linkinfo, final int rownum, final String[] orderColumn, final OrderType[] orderType) {
    	if(linkinfo == null){
            return new ArrayList<LinkInfo>();
        }
    	
        StringBuilder sb = new StringBuilder("select * from linkinfo where 1=1 ");
		List<Object> paramList = new ArrayList<Object>();
        if(linkinfo.getLinkid() != null){
        	sb.append(" and linkid = ? ");
        	paramList.add(linkinfo.getLinkid());
        }
        
        if(!StringUtils.isEmpty(linkinfo.getLinklocid())){
        	sb.append(" and linkLocid = ? ");
        	paramList.add(linkinfo.getLinklocid());
        }
        
        if(!StringUtils.isEmpty(linkinfo.getLinktitle())){
        	sb.append(" and linktitle = ? ");
        	paramList.add(linkinfo.getLinktitle());
        }
        
        if(!StringUtils.isEmpty(linkinfo.getLinkdesc())){
        	sb.append(" and linkdesc = ? ");
        	paramList.add(linkinfo.getLinkdesc());
        }
        
        if(!StringUtils.isEmpty(linkinfo.getLinkcontents())){
        	sb.append(" and linkcontents = ? ");
        	paramList.add(linkinfo.getLinkcontents());
        }
        
        if(linkinfo.getIsredtitle()!=null&&linkinfo.getIsredtitle()){
        	sb.append(" and isredtitle = ? ");
        	paramList.add(linkinfo.getIsredtitle());
        }
        
        if(linkinfo.getIsboldtitle()!=null&&linkinfo.getIsboldtitle()){
        	sb.append(" and isboldtitle = ? ");
        	paramList.add(linkinfo.getIsboldtitle());
        }
        
        if(linkinfo.getIsjump()!=null&&linkinfo.getIsjump()){
        	sb.append(" and isjump = ? ");
        	paramList.add(linkinfo.getIsjump());
        }
        
        if(!StringUtils.isEmpty(linkinfo.getLinkurl())){
        	sb.append(" and linkurl = ? ");
        	paramList.add(linkinfo.getLinkurl());
        }
        
        if(!StringUtils.isEmpty(linkinfo.getPicurl())){
        	sb.append(" and picurl = ? ");
        	paramList.add(linkinfo.getPicurl());
        }
        
        if(!StringUtils.isEmpty(linkinfo.getValiddatetime())){
        	sb.append(" and validdatetime = ? ");
        	paramList.add(linkinfo.getValiddatetime());
        }
        
        if(!StringUtils.isEmpty(linkinfo.getInvaliddatetime())){
        	sb.append(" and invaliddatetime = ? ");
        	paramList.add(linkinfo.getInvaliddatetime());
        }
        
        if(!StringUtils.isEmpty(linkinfo.getDisplayorder())){
        	sb.append(" and displayorder = ? ");
        	paramList.add(linkinfo.getDisplayorder());
        }
        
        if(!StringUtils.isEmpty(linkinfo.getExt1())){
        	sb.append(" and ext1 = ? ");
        	paramList.add(linkinfo.getExt1());
        }
        
        if(!StringUtils.isEmpty(linkinfo.getExt2())){
        	sb.append(" and ext2 = ? ");
        	paramList.add(linkinfo.getExt2());
        }
        
        if(!StringUtils.isEmpty(linkinfo.getExt3())){
        	sb.append(" and ext3 = ? ");
        	paramList.add(linkinfo.getExt3());
        }
        
        if(!StringUtils.isEmpty(linkinfo.getExt4())){
        	sb.append(" and ext4 = ? ");
        	paramList.add(linkinfo.getExt4());
        }
        
        if(!StringUtils.isEmpty(linkinfo.getExt5())){
        	sb.append(" and ext5 = ? ");
        	paramList.add(linkinfo.getExt5());
        }
        
        if(!StringUtils.isEmpty(linkinfo.getExt6())){
        	sb.append(" and ext6 = ? ");
        	paramList.add(linkinfo.getExt6());
        }
        
        if(!StringUtils.isEmpty(linkinfo.getExt7())){
        	sb.append(" and ext7 = ? ");
        	paramList.add(linkinfo.getExt7());
        }
        
        if(linkinfo.getExt8() != null){
        	sb.append(" and ext8 = ? ");
        	paramList.add(linkinfo.getExt8());
        }

        if(!StringUtils.isEmpty(linkinfo.getFromvaliddatetime())){
        	sb.append(" and validdatetime >= ? ");
        	paramList.add(linkinfo.getFromvaliddatetime());
        }

        if(!StringUtils.isEmpty(linkinfo.getTovaliddatetime())){
        	sb.append(" and validdatetime < ? ");
        	paramList.add(linkinfo.getTovaliddatetime());
        }

        if(!StringUtils.isEmpty(linkinfo.getFrominvaliddatetime())){
        	sb.append(" and (invaliddatetime >= ? or invaliddatetime = '' or invaliddatetime is null) ");
        	paramList.add(linkinfo.getFrominvaliddatetime());
        }

        if(!StringUtils.isEmpty(linkinfo.getToinvaliddatetime())){
        	sb.append(" and invaliddatetime < ? ");
        	paramList.add(linkinfo.getToinvaliddatetime());
        }
        
        if(!StringUtils.isEmpty(linkinfo.getInputby())){
        	sb.append(" and inputby = ? ");
        	paramList.add(linkinfo.getInputby());
        }
        
        if(!StringUtils.isEmpty(linkinfo.getInputtime())){
        	sb.append(" and inputtime = ? ");
        	paramList.add(linkinfo.getInputtime());
        }
        
        if(!StringUtils.isEmpty(linkinfo.getEditby())){
        	sb.append(" and editby = ? ");
        	paramList.add(linkinfo.getEditby());
        }
        
        if(!StringUtils.isEmpty(linkinfo.getEdittime())){
        	sb.append(" and edittime = ? ");
        	paramList.add(linkinfo.getEdittime());
        }
        
        if(!StringUtils.isEmpty(linkinfo.getGameid())){
        	sb.append(" and gameid = ? ");
        	paramList.add(linkinfo.getGameid());
        }
        
        if(linkinfo.getIstest()!=null&&linkinfo.getIstest()){
        	sb.append(" and istest = ? ");
        	paramList.add(linkinfo.getIstest());
        }

        if(!StringUtils.isEmpty(linkinfo.getGameidbytuijian())){
        	sb.append(" and gameidbytuijian = ? ");
        	paramList.add(linkinfo.getGameidbytuijian());
        }
        
        if(!StringUtils.isEmpty(linkinfo.getLinklocgroupid())){
        	sb.append(" and linklocgroupid = ? ");
        	paramList.add(linkinfo.getLinklocgroupid());
        }
        
        if(!StringUtils.isEmpty(linkinfo.getSmallpicurl())){
        	sb.append(" and smallpicurl = ? ");
        	paramList.add(linkinfo.getSmallpicurl());
        }
        
        if(!StringUtils.isEmpty(linkinfo.getLinklocgroupid())){
        	sb.append(" and linklocgroupid = ? ");
        	paramList.add(linkinfo.getLinklocgroupid());
        }
        
        if(linkinfo.getDisplaysort() != null){
        	sb.append(" and displaysort = ? ");
        	paramList.add(linkinfo.getDisplaysort());
        }
        
        //推广连接自动更新
        if(linkinfo.getIsvalid()!=null&&linkinfo.getIsvalid()){
        	sb.append(" and isvalid = ? ");
        	paramList.add(linkinfo.getIsvalid());
        	
            //根据生效时间段（包括生效时间和失效时间）判断
            String now = sdf.format(new Date());
        	sb.append(" and validdatetime < ? and (invaliddatetime > ? or invaliddatetime = '' or invaliddatetime is null) ");//未失效或未填失效时间
        	paramList.add(now);
        	paramList.add(now);
        }

        if(orderColumn != null && orderColumn.length > 0 
        		&& orderType != null && orderType.length == orderColumn.length){

        	sb.append(" order by ");
        	for(int i = 0; i < orderColumn.length; i++){
        		
        		String type  = "";
        		if(orderType[i] == null || orderType[i] == OrderType.DESC){
        			type = "desc";//默认排序方式
        		}

        		if(i != 0){
        			sb.append(",");
        		}
        		
        		sb.append(" ? " + type);
        		
        		paramList.add(orderColumn[i]);
        	}
        }
        
        if(rownum > 0){//条数
        	sb.append(" limit ? ");
        	paramList.add(rownum);
        }
		
		return baseDao.executeQuery(LinkInfo.class, sb.toString(), paramList);
	
    }

	public List<LinkInfo> getLinkListByOrderByLimit(final String linkLocid,final String orderColumn,final OrderType orderType,final boolean isQueryTestData){
          return getLinkListByOrderByLimit(linkLocid, 0, orderColumn, orderType, isQueryTestData);
	}

    @Override
    public List<LinkInfo> getAllLinkListByLinkLocId(final String linkLocId, final boolean isQueryTestData) {
        return getLinkListByOrderByLimit(linkLocId,0,"",OrderType.DESC,isQueryTestData);
    }

    @Override
    public List<LinkInfo> getLinkListByOrderByLimit(final String linkLocid, final int limit, final String orderColumn, final OrderType orderType, final boolean isQueryTestData) {
        return getLinkListByOrderByLimit(linkLocid, limit, orderColumn, orderType, false, isQueryTestData);
    }

    @Override
    public List<LinkInfo> getLinkListByOrderByLimit(final String linkLocid, final int limit, final String orderColumn, final OrderType orderType, final boolean isValid, boolean isQueryTestData) {
        

        //推广连接自动更新
        for(int i = 0; i < linkids.length; i++){
        	if(linkids[i].equals(linkLocid)){
        		LinkInfo info = new LinkInfo();
        		info.setLinklocid(linkLocid);
                if(!isQueryTestData){
                	info.setIstest(false);	        //只查询正式数据 
                }

                if(isValid){
                	info.setIsvalid(true);
                }

                String now =sdf.format(new Date());
                info.setTovaliddatetime(now);
                String invalidTime =sdf.format(new Date(System.currentTimeMillis() + 1000));//失效时间提前一秒钟，这样模板执行的时候才会失效
                info.setFrominvaliddatetime(invalidTime);
                
                String[] orderCol = null;
                OrderType[] orderT = null;
                if(StringUtils.isNotEmpty(orderColumn)){
                	orderCol = new String[]{orderColumn};//按照升序序排
                	orderT = new OrderType[]{orderType};
                }
        		
        		return getValidLinkInfoListByLinkInfo(info, limit, orderCol, orderT);
        	}
        }
        
    	
    	LinkInfo li=new LinkInfo();
        li.setLinklocid(linkLocid);
        if(!isQueryTestData){
            li.setIstest(false);	        //只查询正式数据 
        }

        if(isValid){
            li.setIsvalid(true);
        }

        Page page=new Page();
        if(limit > 0){
            page.setPageNo(1);
            page.setPageSize(limit);
        }

        if(StringUtils.isNotEmpty(orderColumn)){
            page.addOrder(orderColumn, orderType);//按照升序序排
        }
        return  baseDao.findByObject(LinkInfo.class, li, page);
    }



    @Override
    public List<LinkInfo> getHotShouyouGiftList(final int limit) {
        return getGiftListByClientTypeWithOrderByColumnDesc(GameClientTypeEnum.shouyou,"displaysort",limit);
    }

    @Override
    public List<LinkInfo> getGiftListByClientTypeWithOrderByColumnDesc(final GameClientTypeEnum clientTypeEnum, final String orderbyColumn,final int limit) {
        String sql = "     SELECT gifts.* FROM\n" +
                "     (SELECT * FROM linkinfo WHERE linklocid = '251')  AS gifts\n" +
                "     LEFT JOIN games ON gifts.gameid = games.gameId\n" +
                "     WHERE games.clientType = ?\n";

        List<Object> list = new ArrayList<Object>();
        list.add(clientTypeEnum.getValue());
        if(StringUtils.isNotEmpty(orderbyColumn)){
            if("displaysort".equals(orderbyColumn)){
                sql += " order by displaysort desc ";
            }else if("validdatetime".equals(orderbyColumn)){
                sql += " order by validdatetime desc ";
            }
        }

        if(limit > 0){
            sql += " limit ? ";
            list.add(limit);
        }

        List<LinkInfo> giftList = baseDao.findBySql(LinkInfo.class,sql,list);
        return giftList;
    }
    
    
	@Override
	public void updateNormalToWeihu(final String shemaId, final String shemaTime) {
		String sql = "UPDATE linkinfo li, gameservers gs SET gs.openstatus = '3' "
			+ " WHERE li.ext4 = ? AND li.ext2 = ? "
			+ " AND li.gameId = gs.gameId AND li.ext1 = gs.fenQuNum "
			+ " AND gs.openstatus = '1' ";
		
		List<Object> paramList = new ArrayList<Object>();
		paramList.add(shemaId);
		paramList.add(shemaTime);
		
		baseDao.execute(sql, paramList);
	}
	
	@Override
	public void updateWeihuToNormal(final String shemaId, final String shemaTime) {
		String sql = "UPDATE linkinfo li, gameservers gs SET gs.openstatus = '1' "
			+ " WHERE li.ext5 = ? AND li.ext3 = ? "
			+ " AND li.gameId = gs.gameId AND li.ext1 = gs.fenQuNum "
			+ " AND gs.openstatus = '3' ";
		
		List<Object> paramList = new ArrayList<Object>();
		paramList.add(shemaId);
		paramList.add(shemaTime);
		
		baseDao.execute(sql, paramList);
	}
    
    
    
}
