package com.xunlei.niux.data.vipgame.bo.account;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import javax.annotation.Resource;

import org.springframework.stereotype.Service;

import com.ferret.common.dao.BaseDao;
import com.xunlei.niux.data.vipgame.vo.account.PreRegisterAccount;
@Service
public class PreRegisterAccountBoImpl implements  PreRegisterAccountBo{
	private static SimpleDateFormat sdf_time=new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
	@Resource(name="BaseDao")
	private BaseDao baseDao;
	
	public BaseDao getBaseDao() {
		return baseDao;
	}
	public void setBaseDao(BaseDao baseDao) {
		this.baseDao = baseDao;
	}
	
	public PreRegisterAccount updateAndFindOneNotUseAccount(PreRegisterAccount p_account ){
		PreRegisterAccount account=findAndLockAccount();
		if(account==null){
			return null;
		}
		//更新状态
		account.setChannelId(p_account.getChannelId());
		account.setGameId(p_account.getGameId());
		account.setIsUsed(true);
		account.setPeerId(p_account.getPeerId());
		account.setUseTime(sdf_time.format(new Date()));
		baseDao.updateById(account);
		return account;
	}
	private PreRegisterAccount findAndLockAccount(){
		String sql="select * from preregisteraccount where isUsed=false limit 0,1 for update";
		List<PreRegisterAccount> list=baseDao.executeQuery(PreRegisterAccount.class, sql, new ArrayList<Object>());
		return (list==null||list.size()==0)?null:list.get(0);
	}
}
