/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.data.vipgame.bo.gift;

import com.ferret.common.dao.BaseDao;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.vipgame.bo.gift.UseGiftPackageBo;
import com.xunlei.niux.data.vipgame.vo.gift.Gift;
import com.xunlei.niux.data.vipgame.vo.gift.GiftPackage;
import com.xunlei.niux.data.vipgame.vo.gift.GiftPackageDetail;
import com.xunlei.niux.data.vipgame.vo.gift.GiftRecord;
import com.xunlei.niux.easyutils.commonutils.OrderNoUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class UseGiftPackageBoImpl
implements UseGiftPackageBo {
    private static SimpleDateFormat sdfDate = new SimpleDateFormat("yyyy-MM-dd");
    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    @Resource(name="BaseDao")
    private BaseDao baseDao;

    @Override
    public void userGiftPackage(GiftRecord p_giftRecord) {
        GiftRecord giftRecord = this.findAndLockGiftRecord(p_giftRecord.getRecordId());
        Gift gift = (Gift)this.baseDao.findById(Gift.class, (Number)giftRecord.getGiftId());
        if (!gift.getGiftType().equals("niuxgift")) {
            throw new RuntimeException("\u4e0d\u662f\u793c\u5305\u8bb0\u5f55[" + p_giftRecord.getRecordId() + "]");
        }
        if (!giftRecord.getGiftStatus().equals("WAIT")) {
            throw new RuntimeException("\u5df2\u7528\u793c\u5305\u8bb0\u5f55[" + p_giftRecord.getRecordId() + "]");
        }
        giftRecord.setGameId(p_giftRecord.getGameId() == null ? "" : p_giftRecord.getGameId());
        giftRecord.setServerId(p_giftRecord.getServerId() == null ? "" : p_giftRecord.getServerId());
        giftRecord.setServerName(p_giftRecord.getServerName());
        giftRecord.setRoleId(p_giftRecord.getRoleId() == null ? "" : p_giftRecord.getRoleId());
        giftRecord.setXunleiVipType(p_giftRecord.getXunleiVipType() == null ? "UNKOWN" : p_giftRecord.getXunleiVipType());
        giftRecord.setMobile(p_giftRecord.getMobile() == null ? "" : p_giftRecord.getMobile());
        giftRecord.setDealTime(sdf.format(new Date()));
        giftRecord.setGiftStatus("SUCCESS");
        this.baseDao.updateById((Object)giftRecord);
        GiftPackage giftPackage = (GiftPackage)this.baseDao.findById(GiftPackage.class, gift.getGiftLot());
        List<GiftPackageDetail> details = this.findGiftPackageDetails(giftPackage.getPackageId());
        int i = 0;
        while (i < details.size()) {
            GiftPackageDetail detail = details.get(i);
            GiftRecord detailGiftRecord = new GiftRecord();
            detailGiftRecord.setActNo(giftRecord.getActNo());
            detailGiftRecord.setGameId(giftRecord.getGameId());
            detailGiftRecord.setGiftId(detail.getProductId());
            detailGiftRecord.setGiftNum((double)detail.getProductNum());
            detailGiftRecord.setRoleId(giftRecord.getRoleId());
            detailGiftRecord.setServerId(giftRecord.getServerId());
            detailGiftRecord.setServerName(giftRecord.getServerName());
            detailGiftRecord.setThirdRecordId(OrderNoUtil.getOrderNo());
            detailGiftRecord.setUserId(giftRecord.getUserId());
            detailGiftRecord.setExpireDate("");
            detailGiftRecord.setParentRecordId(giftRecord.getRecordId());
            detailGiftRecord.setIsShow(false);
            this.addGiftPackageDetail(detailGiftRecord);
            ++i;
        }
        GiftPackage query = new GiftPackage();
        query.setParentPackageId(giftPackage.getPackageId());
        query.setIsValid(true);
        List childGPList = this.baseDao.findByObject(GiftPackage.class, (Object)query, new Page());
        int i2 = 0;
        while (i2 < childGPList.size()) {
            GiftPackage childgp = (GiftPackage)childGPList.get(i2);
            if (childgp.getXunleiVipUseType().equals("ALL") || childgp.getXunleiVipUseType().equals(giftRecord.getXunleiVipType())) {
                Gift childGift = this.findGiftByPackageId(childgp.getPackageId());
                GiftRecord detailGiftRecord = new GiftRecord();
                detailGiftRecord.setActNo(giftRecord.getActNo());
                detailGiftRecord.setGiftId(childGift.getGiftId());
                detailGiftRecord.setGiftNum(1.0);
                detailGiftRecord.setThirdRecordId(OrderNoUtil.getOrderNo());
                detailGiftRecord.setUserId(giftRecord.getUserId());
                detailGiftRecord.setExpireDate(UseGiftPackageBoImpl.calExpireDate(childgp.getExpireDays()));
                detailGiftRecord.setGameId("");
                detailGiftRecord.setRoleId("");
                detailGiftRecord.setServerId("");
                detailGiftRecord.setParentRecordId(giftRecord.getRecordId());
                if (childgp.getInheritParentGameServerType().equals("GAME")) {
                    detailGiftRecord.setGameId(giftRecord.getGameId());
                } else if (childgp.getInheritParentGameServerType().equals("SERVER")) {
                    detailGiftRecord.setGameId(giftRecord.getGameId());
                    detailGiftRecord.setRoleId(giftRecord.getRoleId());
                    detailGiftRecord.setServerId(giftRecord.getServerId());
                    detailGiftRecord.setServerName(giftRecord.getServerName());
                }
                detailGiftRecord.setIsShow(true);
                this.addGiftPackageDetail(detailGiftRecord);
            }
            ++i2;
        }
    }

    public Gift findGiftByPackageId(long packageId) {
        Gift gift = new Gift();
        gift.setGiftLot(String.valueOf(packageId));
        gift.setGiftType("niuxgift");
        Page page = new Page();
        page.setPageNo(1);
        page.setPageSize(1);
        List giftList = this.baseDao.findByObject(Gift.class, (Object)gift, page);
        return giftList == null || giftList.size() == 0 ? null : (Gift)giftList.get(0);
    }

    @Override
    public void addGiftPackageDetail(GiftRecord p_detailGiftRecord) {
        GiftRecord detailGiftRecord = new GiftRecord();
        detailGiftRecord.setActNo(p_detailGiftRecord.getActNo());
        detailGiftRecord.setDealTime("");
        detailGiftRecord.setExpireDate(p_detailGiftRecord.getExpireDate());
        detailGiftRecord.setFailCause("");
        detailGiftRecord.setGameId(p_detailGiftRecord.getGameId());
        detailGiftRecord.setGiftId(p_detailGiftRecord.getGiftId());
        detailGiftRecord.setGiftNum(p_detailGiftRecord.getGiftNum());
        detailGiftRecord.setGiftStatus("WAIT");
        detailGiftRecord.setMobile("");
        detailGiftRecord.setRecordTime(sdf.format(new Date()));
        detailGiftRecord.setRoleId(p_detailGiftRecord.getRoleId());
        detailGiftRecord.setServerId(p_detailGiftRecord.getServerId());
        detailGiftRecord.setServerName(p_detailGiftRecord.getServerName());
        detailGiftRecord.setThirdRecordId(p_detailGiftRecord.getThirdRecordId());
        detailGiftRecord.setUserId(p_detailGiftRecord.getUserId());
        detailGiftRecord.setXunleiVipType("UNKOWN");
        detailGiftRecord.setIsShow(p_detailGiftRecord.getIsShow());
        detailGiftRecord.setParentRecordId(p_detailGiftRecord.getParentRecordId() == null ? 0L : p_detailGiftRecord.getParentRecordId());
        detailGiftRecord.setSerialNumber("");
        detailGiftRecord.setShowLocNo(p_detailGiftRecord.getShowLocNo());
        this.baseDao.insert((Object)detailGiftRecord);
    }

    private List<GiftPackageDetail> findGiftPackageDetails(long packageId) {
        GiftPackageDetail query = new GiftPackageDetail();
        query.setPackageId(packageId);
        return this.baseDao.findByObject(GiftPackageDetail.class, (Object)query, new Page());
    }

    private GiftRecord findAndLockGiftRecord(long recordId) {
        String sql = "select * from giftrecord where recordId=?";
        ArrayList<Long> paramList = new ArrayList<Long>();
        paramList.add(recordId);
        List list = this.baseDao.executeQuery(GiftRecord.class, sql, paramList);
        return list.size() == 0 ? null : (GiftRecord)list.get(0);
    }

    private static String calExpireDate(int days) {
        long now = System.currentTimeMillis();
        long expiretime = now + 86400000L * (long)days;
        return sdfDate.format(new Date(expiretime));
    }

    public BaseDao getBaseDao() {
        return this.baseDao;
    }

    public void setBaseDao(BaseDao baseDao) {
        this.baseDao = baseDao;
    }
}

