package com.xunlei.niux.data.vipgame.bo.tasks;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.vipgame.dao.tasks.TaskGameConfigDao;
import com.xunlei.niux.data.vipgame.dto.tasks.TaskGameConfigDTO;
import com.xunlei.niux.data.vipgame.dto.tasks.TaskGameConfigWithUrlDTO;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.tasks.TaskDutyConfig;
import com.xunlei.niux.data.vipgame.vo.tasks.TaskGameConfig;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * Created by jamesjxin on 14-6-12.
 */
public class TaskGameConfigBoImpl implements TaskGameConfigBo{

    @Autowired
    private TaskGameConfigDao taskGameConfigDao;

    private static final String APPGAME_URL_CHANNELID = "201402207344555915";

    @Override
    public List<TaskGameConfigDTO> getAllTaskGameConfigDTOList() {
        List<TaskGameConfigDTO> taskGameConfigDTOList = new ArrayList<TaskGameConfigDTO>();

        Map<Integer,TaskDutyConfig> allTaskDutyConfigMap = FacadeFactory.INSTANCE.getTaskDutyConfigBo().getAllTaskDutyConfig();

//        Page page = new Page();
//        page.addOrder("showOrder", OrderType.DESC);
//        List<TaskGameConfig> allTaskGameConfigList = taskGameConfigDao.findByObject(TaskGameConfig.class,
//                new TaskGameConfig(),page);

        List<TaskGameConfigWithUrlDTO> allTaskGameConfigList = taskGameConfigDao.getAllTaskGameConfigWithUrlDTO(APPGAME_URL_CHANNELID);

        if(CollectionUtils.isEmpty(allTaskGameConfigList)){
            return taskGameConfigDTOList;
        }


        for(TaskGameConfigWithUrlDTO gameConfig : allTaskGameConfigList){
            List<TaskDutyConfig> taskDutyConfigList = new ArrayList<TaskDutyConfig>();
            TaskGameConfigDTO gameConfigDTO = new TaskGameConfigDTO();
            BeanUtils.copyProperties(gameConfig,gameConfigDTO);

            TaskDutyConfig taskDutyConfig1 = allTaskDutyConfigMap.get(gameConfig.getTask1ref());
            gameConfigDTO.setTask1(taskDutyConfig1);
            taskDutyConfigList.add(taskDutyConfig1);

            TaskDutyConfig taskDutyConfig2 = allTaskDutyConfigMap.get(gameConfig.getTask2ref());
            gameConfigDTO.setTask2(taskDutyConfig2);
            taskDutyConfigList.add(taskDutyConfig2);

            TaskDutyConfig taskDutyConfig3 = allTaskDutyConfigMap.get(gameConfig.getTask3ref());
            gameConfigDTO.setTask3(taskDutyConfig3);
            taskDutyConfigList.add(taskDutyConfig3);

            TaskDutyConfig taskDutyConfig4 = allTaskDutyConfigMap.get(gameConfig.getTask4ref());
            gameConfigDTO.setTask4(taskDutyConfig4);
            taskDutyConfigList.add(taskDutyConfig4);

            gameConfigDTO.setTaskConfigList(taskDutyConfigList);
            gameConfigDTO.setMuliPhotoUrl(gameConfig.getMuliPhotoUrl());
            taskGameConfigDTOList.add(gameConfigDTO);
        }

        return taskGameConfigDTOList;
    }
}
