package com.xunlei.niux.data.vipgame.bo;

import java.util.List;

import com.ferret.common.dao.BaseDao;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.vipgame.dao.TempLateSchemaDao;
import com.xunlei.niux.data.vipgame.vo.TemplateSchema;

public class TemplateSchemaBoImpl implements TemplateSchemaBo {

	private TempLateSchemaDao tempLateSchemaDao;
	private BaseDao baseDao;
	public BaseDao getBaseDao() {
		return baseDao;
	}
	public void setBaseDao(BaseDao baseDao) {
		this.baseDao = baseDao;
	}
	public void setTempLateSchemaDao(TempLateSchemaDao tempLateSchemaDao){
		this.tempLateSchemaDao = tempLateSchemaDao;
	}
	public TempLateSchemaDao getTempLateSchemaDao(){
		return tempLateSchemaDao;
	}

	public int count(TemplateSchema schema) {
		return baseDao.count(schema);
	}

	@Override
	public List<TemplateSchema> getTemplatesByIds(String sechemaIds) {
		return tempLateSchemaDao.geTemplateSchemasByIds(sechemaIds);
	}


	public void delete(Integer schemaid) {
		baseDao.deleteById(TemplateSchema.class, schemaid);

	}

	public TemplateSchema find(Integer schemaid) {
		return baseDao.findById(TemplateSchema.class, schemaid);
	}

	public List<TemplateSchema> find(TemplateSchema schema) {
		return baseDao.findByObject(TemplateSchema.class,schema,new Page());
	}

	public List<TemplateSchema> find(TemplateSchema schema, Page page) {
		return baseDao.findByObject(TemplateSchema.class,schema,page);
	}

	public void insert(TemplateSchema schema) {
		baseDao.insert(schema);
	}

	public void update(TemplateSchema schema) {
		baseDao.updateById(schema);
	}

}
