package com.xunlei.niux.data.vipgame.bo;

import com.ferret.common.dao.BaseDao;
import com.ferret.common.dao.BaseDaoImpl;
import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.vipgame.vo.GameServers;
import com.xunlei.niux.easyutils.commonutils.DateUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class GameServersBoImpl extends BaseDaoImpl implements GameServersBo {
	private BaseDao baseDao;
	public BaseDao getBaseDao() {
		return baseDao;
	}
	public void setBaseDao(BaseDao baseDao) {
		this.baseDao = baseDao;
	}
	
	public void execute(String sql, List<Object> list){
		baseDao.execute(sql, list);
	}

	public List<GameServers> findGameServers(GameServers gameServrs, int pageNo,
			int pageSize) {
		Page page=new Page();
		page.setPageNo(pageNo);
		page.setPageSize(pageSize);
		page.addOrder("fenQuNum", OrderType.DESC);
		return baseDao.findByObject(GameServers.class, gameServrs, page);
	}
	public int count(GameServers gameServrs){
		return baseDao.count(gameServrs);
	}
	public GameServers findGameServersById(long seqid){
		return baseDao.findById(GameServers.class, seqid);
	}
	public void update(GameServers gameServrs){
		 baseDao.updateById(gameServrs);
	}
	public void insert(GameServers gameServrs){
		baseDao.insert(gameServrs);
	}
	public List<GameServers> find(GameServers gs,Page page){
		return baseDao.findByObject(GameServers.class, gs, page);
	}
	/**
	 * 获取gameid对应游戏的最新开区，如果包含测试数据isQueryTestData true;
	 * @param gameId
	 * @param isQueryTestData
	 * @return
	 */
	public GameServers getLatestGameServerByGameId(String gameId,boolean isQueryTestData){
		if(gameId==null||"".equals(gameId)){
			return null;
		}
		Page page=new Page();
		page.setPageNo(1);
		page.setPageSize(1);
		page.addOrder("openTime", OrderType.DESC);
		page.addOrder("fenQuNum", OrderType.DESC);
		GameServers gameServrs=new GameServers();
		gameServrs.setGameId(gameId);
		gameServrs.setOpenStatus("1");
		List<GameServers> list=baseDao.findByObject(GameServers.class, gameServrs, page);
		return (list!=null&&list.size()>0)?list.get(0):null;
	}
	public void delete(long seqId){
		baseDao.deleteById(GameServers.class, seqId);
	}

    @Override
    public List<GameServers> getNewestOpenedGameServersByGameIdList(List<String> gameIdList) {
        if(CollectionUtils.isEmpty(gameIdList)){
            return new ArrayList<GameServers>();
        }
        String baseSql = "(select * from gameservers where gameId = ? and openstatus='1' order by openTime desc,fenQuNum desc limit 1 )";

        String querySql = "";
        int index = 0;
        List paramList = new ArrayList();
        for(String gameId : gameIdList){
            if(StringUtils.isEmpty(gameId)){
                continue;
            }
            if(index > 0){
                querySql += " union ";
            }
            querySql += baseSql;
            paramList.add(gameId);
            index++;
        }

        List<GameServers> gameServersList = baseDao.executeQuery(GameServers.class,querySql,paramList);

        if(CollectionUtils.isEmpty(gameServersList)){
            return new ArrayList<GameServers>();
        }
        return gameServersList;
    }

    @Override
    public String getNewestOpenedGameServerByGameId(String gameId) {
        GameServers query = new GameServers();
        query.setGameId(gameId);
        query.setOpenStatus("1");
        DateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        query.setToopentime(sdf.format(new Date()));
        Page page = new Page();
        page.addOrder("openTime",OrderType.DESC);
        page.addOrder("fenQuNum", OrderType.DESC);
        page.setPageNo(1);
        page.setPageSize(1);
        List<GameServers> serversList = baseDao.findByObject(GameServers.class, query, page);

        if(CollectionUtils.isEmpty(serversList)){
            throw new RuntimeException("没有有效的区服信息！");
        }

        GameServers gameServer = serversList.get(0);

        return gameServer.getServerId();
    }

    @Override
    public boolean isValidOpenedGameServer(String gameId, String serverId){

        GameServers query = new GameServers();
        query.setGameId(gameId);
        query.setServerId(serverId);
        query.setOpenStatus("1");
        DateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        query.setToopentime(sdf.format(new Date()));
        Page page = new Page();
        page.addOrder("openTime",OrderType.DESC);
        page.addOrder("fenQuNum", OrderType.DESC);
        page.setPageNo(1);
        page.setPageSize(1);

        List<GameServers> serversList = baseDao.findByObject(GameServers.class,query,page);
        if(CollectionUtils.isNotEmpty(serversList)){
            return true;
        }

        return false;
    }

    @Override
    public boolean isValidOpenedGameServerAndCanUserReceiveTask(String gameId, String serverId) throws Exception{

        GameServers query = new GameServers();
        query.setGameId(gameId);
        query.setServerId(serverId);
        query.setOpenStatus("1");
        DateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        query.setToopentime(sdf.format(new Date()));
        Page page = new Page();
        page.addOrder("openTime",OrderType.DESC);
        page.addOrder("fenQuNum", OrderType.DESC);
        page.setPageNo(1);
        page.setPageSize(1);

        List<GameServers> serversList = baseDao.findByObject(GameServers.class,query,page);
        if(CollectionUtils.isNotEmpty(serversList)){
            GameServers gameServer = serversList.get(0);
            String openTime = gameServer.getOpenTime();
            String newestServerId = getNewestOpenedGameServerByGameId(gameId);
            //如果是最新区服，则不限制领取任务的时间；否则限制在开服5天之内才能领取，超过5天，则不能领取
            if(newestServerId.equals(serverId) || DateUtil.isCurTimeInRange(openTime, DateUtil.getNDaysLater(openTime, 5))){
                return true;
            }
        }

        return false;
    }

    @Override
    public List<GameServers> getOpenServersByFromDateAndToDate(String fromDate, String toDate) {
        String sql = "select gameservers.* from \n" +
                "games join gameservers on gameservers.gameId = games.gameId\n" +
                "where (games.clientType =0 or games.clientType =1) and gameservers.openTime >= ? and gameservers.openTime <= ?\n" +
                "order by gameservers.openTime,gameservers.fenQuNum ";

        List<Object> list = new ArrayList<Object>();
        list.add(fromDate+" 00:00:00");
        list.add(toDate+" 23:59:59");


        List<GameServers> serversList = baseDao.executeQuery(GameServers.class, sql, list);

        return serversList;
    }
    
    
    public List<GameServers> getXmpOpenServersByFromDateAndToDate(String fromDate,boolean isSort,int limit) {
        String sql = "SELECT distinct s3.* FROM (SELECT gameidbytuijian FROM linkinfo WHERE linklocid='1260') s1 \n" +
                "INNER JOIN games s2 ON s1.gameidbytuijian=s2.gameid  INNER  JOIN gameservers s3 ON s3.gameId = s2.gameId\n" +
                "WHERE (s2.clientType =0 OR s2.clientType =1) AND  s3.openTime <= ?\n" +
                "ORDER BY s3.openTime  ";
    	if(!isSort){//如果是逆序
    		sql += " desc,s3.fenQuNum desc ";
    	}else{
    		sql += " asc,s3.fenQuNum asc ";
    	}
    	sql += "  limit "+limit;
        List<Object> list = new ArrayList<Object>();
        list.add(fromDate);
        List<GameServers> serversList = baseDao.executeQuery(GameServers.class, sql, list);
        return serversList;
    }
    
    public List<GameServers> getNewOpenServersByFromDateAndToDate(String fromDate, String toDate,boolean isSort) {
        String sql = "SELECT distinct s3.* FROM (SELECT gameidbytuijian FROM linkinfo WHERE linklocid='1260') s1 \n" +
                "INNER JOIN games s2 ON s1.gameidbytuijian=s2.gameid  INNER  JOIN gameservers s3 ON s3.gameId = s2.gameId\n" +
                "WHERE (s2.clientType =0 OR s2.clientType =1) AND s3.openTime >= ? AND s3.openTime <= ?\n" +
                "ORDER BY s3.openTime  ";
    	if(!isSort){//如果是逆序
    		sql += " desc,s3.fenQuNum desc";
    	}else{
    		sql += " asc,s3.fenQuNum asc";
    	}
        List<Object> list = new ArrayList<Object>();
        list.add(fromDate+" 00:00:00");
        list.add(toDate+" 23:59:59");

        List<GameServers> serversList = baseDao.executeQuery(GameServers.class, sql, list);

        return serversList;
    }
    
    @Override
    public List<GameServers> getTimeOpenFenQuGameServersList() {
    	
        String querySql = "select * from gameservers where openstatus <> '1' and fenQuOpenFlag = 1 and fenQuOpenTime < now()";

        return baseDao.executeQuery(GameServers.class,querySql, new ArrayList<Object>());

    }

    @Override
    public List<GameServers> getLatestAndComingOneGameServer() {
        String sql = "select gameservers.* from (select gameid, max(opentime) as opentime from gameservers where openstatus='1' group by gameid \n" +
                "union all select gameid, min(opentime) as opentime from gameservers where openstatus='0' group by gameid ) s \n" +
                "inner join gameservers on s.gameid = gameservers.gameid and s.opentime = gameservers.opentime\n" +
                "inner join games on games.gameid = gameservers.gameid\n" +
                "where (games.clientType =0 OR games.clientType =1) order by games.gameid;";
        List<Object> list = new ArrayList<Object>();

        List<GameServers> serversList = baseDao.executeQuery(GameServers.class, sql, list);

        return serversList;
    }
    
    
    /**
     * @return  最新开服的10个游戏按照，游戏的首服的开服日期逆序
     * 
     * 规则：先连接games和gameservers表找出每个游戏中最早开服的时间，然后按照逆序取前10个
     * 	         然后把得到的临时表和games做内连接获取游戏的具体信息
     */
    public List<GameServers> getNewGamesList(){
    	String sql = "SELECT gameservers.* FROM " +
                " ( SELECT seqId, opentime FROM " +
                "   ( SELECT MIN(gms.openTime) AS opentime, gms.gameid,gms.seqId FROM gameservers gms " +
                "     INNER JOIN games ON games.status = 1 AND (games.clientType = 0 or games.clientType = 1)  AND games.gameid = gms.gameid " +
                "     WHERE openstatus = 1 GROUP BY gameid\n" +
                "   ) gs " +
                "  ORDER BY opentime DESC LIMIT 0,10 " +
                " ) s1 " +
                "INNER JOIN gameservers ON gameservers.seqId = s1.seqId " +
                "ORDER BY s1.opentime DESC ";
    	List<Object> list = new ArrayList<Object>();
    	List<GameServers> gamesList = executeQuery(GameServers.class, sql,list);
    	return gamesList;
    }

    /**
     * 获得距离最近开服那天的所有开服信息
     * @param gameIdList
     * @return
     */
    @Override
    public List<GameServers> getLatestNewestOpenedGameServersByGameIdList(List<String> gameIdList){
        if(CollectionUtils.isEmpty(gameIdList)){
            return new ArrayList<GameServers>();
        }
        String baseSql = "(select * from gameservers WHERE gameId=? and openstatus=1 and STR_TO_DATE(openTime, \"%Y-%m-%d\") = (\n" +
                "\tselect STR_TO_DATE(max(openTime), \"%Y-%m-%d\") from gameservers where gameId=? and openstatus=1\n" +
                "))";

        String querySql = "";
        int index = 0;
        List paramList = new ArrayList();
        for(String gameId : gameIdList){
            if(StringUtils.isEmpty(gameId)){
                continue;
            }
            if(index > 0){
                querySql += " union ";
            }
            querySql += baseSql;
            paramList.add(gameId);
            paramList.add(gameId);
            index++;
        }

        List<GameServers> gameServersList = baseDao.executeQuery(GameServers.class,querySql,paramList);

        if(CollectionUtils.isEmpty(gameServersList)){
            return new ArrayList<GameServers>();
        }
        return gameServersList;
    }
}
