package com.xunlei.niux.data.vipgame.bo;

import java.util.ArrayList;
import java.util.List;

import com.ferret.common.dao.BaseDao;
import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.vipgame.enums.AdviceTypeEnum;
import com.xunlei.niux.data.vipgame.vo.Advice;
import com.xunlei.niux.data.vipgame.vo.LinkInfo;
import org.apache.commons.lang.StringUtils;

public class AdviceBoImpl implements AdviceBo {
    private BaseDao baseDao;

    public BaseDao getBaseDao() {
        return baseDao;
    }

    public void setBaseDao(BaseDao baseDao) {
        this.baseDao = baseDao;
    }

    public List<Advice> find(Advice advice, int pageNo, int pageSize) {
        Page page = new Page();
        page.setPageNo(pageNo);
        page.setPageSize(pageSize);
        page.addOrder("displayOrder", OrderType.ESC);
        page.addOrder("inputTime", OrderType.DESC);
        return baseDao.findByObject(Advice.class, advice, page);
    }

    public List<Advice> findAdvice(Advice advice, Page page) {
        return baseDao.findByObject(Advice.class, advice, page);
    }

    public Advice findAdviceById(long seqId) {
        return baseDao.findById(Advice.class, seqId);
    }

    public int count(Advice advice) {
        return baseDao.count(advice);
    }

    public void update(Advice advice) {
        baseDao.updateById(advice);
    }

    public void insert(Advice advice) {
        baseDao.insert(advice);
    }

    public void delete(Long seqId) {
        baseDao.deleteById(Advice.class, seqId);
    }

    public void execute(String sql, List<Object> list) {
        baseDao.execute(sql, list);

    }

    public List executeQuery(Class class1, String sql, List list) {
        return baseDao.executeQuery(class1, sql, list);
    }

    @Override
    public List<Advice> getAllAdviceByAdviceTypeOrderByPublishDateDesc(AdviceTypeEnum adviceTypeEnum) {
        return getAdviceListByAdviceTypeOrderByPublishDateDesc(adviceTypeEnum, "", 0);
    }

    @Override
    public List<Advice> getAdviceListByAdviceTypeOrderByPublishDateDesc(AdviceTypeEnum adviceTypeEnum, int limit) {
        return getAdviceListByAdviceTypeOrderByPublishDateDesc(adviceTypeEnum, "", limit);
    }

    @Override
    public List<Advice> getAdviceListByAdviceTypeOrderByPublishDateDesc(AdviceTypeEnum adviceTypeEnum, String platformno, int limit) {
        Advice query = new Advice();
        query.setAdviceType(adviceTypeEnum.getValue());
        if (StringUtils.isNotEmpty(platformno)) {
            query.setPlatformno(platformno);
        }

        Page page = new Page();
        if (limit > 0) {
            page.setPageNo(1);
            page.setPageSize(limit);
        }
        page.addOrder("publishDate", OrderType.DESC);
        return baseDao.findByObject(Advice.class, query, page);
    }

    @Override
    public void updateDisplayOrderForRemoveFlagTime(Advice advice) {
        String sql = "update advice set displayOrder=100 where removeFlagTime<=now() and gameId=? and adviceType=? and publishDate<=?";
        if(StringUtils.isEmpty(advice.getGameId())
                || StringUtils.isEmpty(advice.getAdviceType())
                || StringUtils.isEmpty(advice.getLePublishDate())){
            return;
        }
        List<Object> params = new ArrayList<Object>();
        params.add(advice.getGameId());
        params.add(advice.getAdviceType());
        params.add(advice.getLePublishDate());
        System.out.println(sql+" "+params);
        baseDao.execute(sql,params);
    }
}
