/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.data.vipgame.dao.gift;

import com.ferret.common.dao.BaseDaoImpl;
import com.xunlei.common.util.StringTools;
import com.xunlei.niux.data.vipgame.dao.gift.GiftRecordDao;
import com.xunlei.niux.data.vipgame.dto.ActivityNGiftNGiftRecordDTO;
import com.xunlei.niux.data.vipgame.dto.GiftRecordDTO;
import com.xunlei.niux.data.vipgame.dto.ProductDTO;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

public class GiftRecordDaoImpl
extends BaseDaoImpl
implements GiftRecordDao {
    @Override
    public List<GiftRecordDTO> getUnReleaseProductGiftRecord() {
        final ArrayList<GiftRecordDTO> giftRecordDTOList = new ArrayList<GiftRecordDTO>();
        String sql = "SELECT giftrecord.*,giftshopreleaserecord.*,gift.goodId FROM giftrecord\nLEFT JOIN giftshopreleaserecord ON giftrecord.recordId = giftshopreleaserecord.giftRecordId\nLEFT JOIN gift ON giftrecord.giftId = gift.giftId\nWHERE giftType = 'product' AND (giftshopreleaserecord.releaseStatus IS NULL OR giftshopreleaserecord.releaseStatus != 1)\nand gift.goodId is not null and gift.goodId > 0";
        this.getJdbcTemplate().query(sql, new RowCallbackHandler(){

            public void processRow(ResultSet resultSet) throws SQLException {
                GiftRecordDTO giftRecordDTO = new GiftRecordDTO();
                giftRecordDTO.setRecordId(resultSet.getLong("recordId"));
                giftRecordDTO.setGiftId(resultSet.getLong("giftId"));
                giftRecordDTO.setUserId(resultSet.getString("userId"));
                giftRecordDTO.setGameId(resultSet.getString("gameId"));
                giftRecordDTO.setServerId(resultSet.getString("serverId"));
                giftRecordDTO.setRoleId(resultSet.getString("roleId"));
                giftRecordDTO.setGiftNum(resultSet.getDouble("giftNum"));
                giftRecordDTO.setMobile(resultSet.getString("mobile"));
                giftRecordDTO.setGiftStatus(resultSet.getString("giftStatus"));
                giftRecordDTO.setActNo(resultSet.getString("actNo"));
                giftRecordDTO.setThirdRecordId(resultSet.getString("thirdRecordId"));
                giftRecordDTO.setFailCause(resultSet.getString("failCause"));
                giftRecordDTO.setRecordTime(resultSet.getString("recordTime"));
                giftRecordDTO.setDealTime(resultSet.getString("dealTime"));
                giftRecordDTO.setExpireDate(resultSet.getString("expireDate"));
                giftRecordDTO.setXunleiVipType(resultSet.getString("xunleiVipType"));
                giftRecordDTO.setParentRecordId(resultSet.getLong("parentRecordId"));
                giftRecordDTO.setIsShow(resultSet.getBoolean("isShow"));
                giftRecordDTO.setSerialNumber(resultSet.getString("serialNumber"));
                giftRecordDTO.setShowLocNo(resultSet.getString("showLocNo"));
                giftRecordDTO.setReleaseStatus(resultSet.getBoolean("releaseStatus"));
                giftRecordDTO.setReleaseTime(resultSet.getString("releaseTime"));
                giftRecordDTO.setGoodId(resultSet.getInt("goodId"));
                giftRecordDTOList.add(giftRecordDTO);
            }
        });
        return giftRecordDTOList;
    }

    @Override
    public List<ProductDTO> getBonusProductChargeList(int max) {
        final ArrayList<ProductDTO> giftRecordDTOList = new ArrayList<ProductDTO>();
        String sql = "SELECT * FROM bonusproductcharge s1 LEFT JOIN gift s2 ON  s1.productId=s2.giftId where s1.isValid=1 order by s1.orderNum desc";
        Object[] args = null;
        if (max > 0) {
            sql = sql + " limit ?";
            args = new Object[]{max};
        }
        this.getJdbcTemplate().query(sql, args, new RowCallbackHandler(){

            public void processRow(ResultSet resultSet) throws SQLException {
                ProductDTO giftRecordDTO = new ProductDTO();
                giftRecordDTO.setGiftid(resultSet.getString("productId"));
                giftRecordDTO.setGiftName(resultSet.getString("giftName"));
                giftRecordDTO.setTotalNum(resultSet.getLong("totalCount"));
                giftRecordDTO.setRemainNum(resultSet.getLong("leftCount"));
                giftRecordDTO.setGiftBonusNum(resultSet.getLong("bonus"));
                giftRecordDTO.setGiftImgUrl(resultSet.getString("giftPic"));
                giftRecordDTO.setSmallImgUrl(resultSet.getString("smallPicUrl"));
                giftRecordDTO.setFirstLetter(resultSet.getString("firstLetter"));
                giftRecordDTO.setIsTimeLimit(resultSet.getInt("isTimeLimit"));
                String giftType = resultSet.getString("giftType");
                int giftTypeNum = StringTools.isEmpty((String)giftType) ? 3 : ("product".equals(giftType) ? 1 : ("niuxgift".equals(giftType) ? 2 : 3));
                giftRecordDTO.setGiftType(giftTypeNum);
                String startTime = resultSet.getString("startTime");
                String valdateTime = resultSet.getString("valdateTime");
                giftRecordDTO.setStartTime(StringUtils.isEmpty((String)startTime) ? "" : GiftRecordDaoImpl.this.format(startTime));
                giftRecordDTO.setValdateTime(StringUtils.isEmpty((String)valdateTime) ? "" : GiftRecordDaoImpl.this.format(valdateTime));
                giftRecordDTOList.add(giftRecordDTO);
            }
        });
        return giftRecordDTOList;
    }

    @Override
    public List<ProductDTO> getBonusProductChargeList(int listNum, boolean isTimeLimit, boolean isEntityGift) {
        final ArrayList<ProductDTO> giftRecordDTOList = new ArrayList<ProductDTO>();
        String sql = "SELECT * FROM bonusproductcharge s1 LEFT JOIN gift s2 ON  s1.productId=s2.giftId where s1.isValid=1 ";
        Object[] args = null;
        if (isTimeLimit) {
            sql = sql + " and isTimeLimit=1";
        }
        if (isEntityGift) {
            sql = sql + " and giftType='product'";
        }
        sql = sql + " order by s1.orderNum desc";
        if (listNum > 0) {
            sql = sql + " limit 0, " + listNum;
        }
        this.getJdbcTemplate().query(sql, args, new RowCallbackHandler(){

            public void processRow(ResultSet resultSet) throws SQLException {
                ProductDTO giftRecordDTO = new ProductDTO();
                giftRecordDTO.setGiftid(resultSet.getString("productId"));
                giftRecordDTO.setGiftName(resultSet.getString("giftName"));
                String giftType = resultSet.getString("giftType");
                giftRecordDTO.setGiftType(StringTools.isEmpty((String)giftType) ? 2 : ("product".equals(giftType) ? 1 : 2));
                giftRecordDTO.setTotalNum(resultSet.getLong("totalCount"));
                giftRecordDTO.setRemainNum(resultSet.getLong("leftCount"));
                giftRecordDTO.setGiftBonusNum(resultSet.getLong("bonus"));
                giftRecordDTO.setGiftImgUrl(resultSet.getString("giftPic"));
                giftRecordDTO.setSmallImgUrl(resultSet.getString("smallPicUrl"));
                giftRecordDTO.setFirstLetter(resultSet.getString("firstLetter"));
                giftRecordDTO.setIsTimeLimit(resultSet.getInt("isTimeLimit"));
                String startTime = resultSet.getString("startTime");
                String valdateTime = resultSet.getString("valdateTime");
                giftRecordDTO.setStartTime(StringUtils.isEmpty((String)startTime) ? "" : GiftRecordDaoImpl.this.format(startTime));
                giftRecordDTO.setValdateTime(StringUtils.isEmpty((String)valdateTime) ? "" : GiftRecordDaoImpl.this.format(valdateTime));
                giftRecordDTOList.add(giftRecordDTO);
            }
        });
        return giftRecordDTOList;
    }

    @Override
    public List<ProductDTO> getTimeLimitBonusProductChargeList(int max) {
        final ArrayList<ProductDTO> giftRecordDTOList = new ArrayList<ProductDTO>();
        String sql = "SELECT * FROM bonusproductcharge s1 LEFT JOIN gift s2 ON  s1.productId=s2.giftId where s1.isValid=1 and s1.isTimeLimit=1 order by s1.orderNum desc";
        Object[] args = null;
        if (max > 0) {
            sql = sql + " limit ?";
            args = new Object[]{max};
        }
        this.getJdbcTemplate().query(sql, args, new RowCallbackHandler(){

            public void processRow(ResultSet resultSet) throws SQLException {
                ProductDTO giftRecordDTO = new ProductDTO();
                giftRecordDTO.setGiftid(resultSet.getString("productId"));
                giftRecordDTO.setGiftName(resultSet.getString("giftName"));
                String giftType = resultSet.getString("giftType");
                giftRecordDTO.setGiftType(StringTools.isEmpty((String)giftType) ? 2 : ("product".equals(giftType) ? 1 : 2));
                giftRecordDTO.setTotalNum(resultSet.getLong("totalCount"));
                giftRecordDTO.setRemainNum(resultSet.getLong("leftCount"));
                giftRecordDTO.setGiftBonusNum(resultSet.getLong("bonus"));
                giftRecordDTO.setGiftImgUrl(resultSet.getString("giftPic"));
                giftRecordDTO.setSmallImgUrl(resultSet.getString("smallPicUrl"));
                giftRecordDTO.setValdateTime(resultSet.getString("valdateTime"));
                giftRecordDTO.setFirstLetter(resultSet.getString("firstLetter"));
                giftRecordDTO.setStartTime(resultSet.getString("startTime"));
                giftRecordDTO.setIsTimeLimit(resultSet.getInt("isTimeLimit"));
                giftRecordDTOList.add(giftRecordDTO);
            }
        });
        return giftRecordDTOList;
    }

    @Override
    public List<?> getJiFenShopGiftRecord(Class<?> object, String userId, Set<String> giftTypeParamSet, int pageNo, int pageSize) {
        ArrayList list = new ArrayList();
        String sql = "SELECT giftrecord.*, giftshopreleaserecord.*, 0 AS goodId FROM giftrecord  LEFT JOIN giftshopreleaserecord ON giftrecord.recordId = giftshopreleaserecord.giftRecordId  LEFT JOIN gift ON giftrecord.giftId = gift.giftId  WHERE giftrecord.userid=:userid AND gift.giftType in (:giftTypeParamSet) AND giftrecord.isshow='1'   AND EXISTS (SELECT 1 FROM activity_category WHERE giftrecord.actNo = activity_category.actNo AND activity_category.is_bonusshop = 1)  ORDER BY giftrecord.recordTime DESC LIMIT :pageNo,:pageSize";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("userid", (Object)userId);
        parameters.addValue("giftTypeParamSet", giftTypeParamSet);
        parameters.addValue("pageNo", (Object)pageNo);
        parameters.addValue("pageSize", (Object)pageSize);
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.getDataSource());
        return namedParameterJdbcTemplate.query(sql, (SqlParameterSource)parameters, (RowMapper)new BeanPropertyRowMapper(object));
    }

    @Override
    public List<?> getUserGiftRecordByGiftType(Class<?> object, String userId, Set<String> giftTypeParamSet, int pageNo, int pageSize) {
        String sql = "SELECT activity.*, gift.* , giftrecord.*, giftshopreleaserecord.*, 0 AS goodId FROM giftrecord  LEFT JOIN giftshopreleaserecord ON giftrecord.recordId = giftshopreleaserecord.giftRecordId LEFT JOIN gift ON giftrecord.giftId = gift.giftId LEFT JOIN activity ON giftrecord.actno = activity.actno WHERE giftrecord.userid=:userid AND gift.giftType in (:giftTypeParamSet) AND giftrecord.isshow='1'  ORDER BY giftrecord.recordTime DESC LIMIT :pageNo,:pageSize";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("userid", (Object)userId);
        parameters.addValue("giftTypeParamSet", giftTypeParamSet);
        parameters.addValue("pageNo", (Object)pageNo);
        parameters.addValue("pageSize", (Object)pageSize);
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.getDataSource());
        return namedParameterJdbcTemplate.query(sql, (SqlParameterSource)parameters, (RowMapper)new BeanPropertyRowMapper(object));
    }

    @Override
    public int countUserGiftRecordByGiftType(String userId, Set<String> giftTypeParamSet) {
        String sql = "SELECT count(*) FROM giftrecord  LEFT JOIN gift ON giftrecord.giftId = gift.giftId  WHERE giftrecord.userid=:userid AND gift.giftType in (:giftTypeParamSet) AND giftrecord.isshow='1' ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("userid", (Object)userId);
        parameters.addValue("giftTypeParamSet", giftTypeParamSet);
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.getDataSource());
        return namedParameterJdbcTemplate.queryForInt(sql, (SqlParameterSource)parameters);
    }

    @Override
    public int countJiFenShopGiftRecord(String userId, Set<String> giftTypeParamSet) {
        String sql = "SELECT count(*) FROM giftrecord  LEFT JOIN gift ON giftrecord.giftId = gift.giftId  WHERE giftrecord.userid=:userid AND gift.giftType in (:giftTypeParamSet) AND giftrecord.isshow='1'  AND EXISTS (SELECT 1 FROM activity_category WHERE giftrecord.actNo = activity_category.actNo AND activity_category.is_bonusshop = 1) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("userid", (Object)userId);
        parameters.addValue("giftTypeParamSet", giftTypeParamSet);
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.getDataSource());
        return namedParameterJdbcTemplate.queryForInt(sql, (SqlParameterSource)parameters);
    }

    @Override
    public List<ActivityNGiftNGiftRecordDTO> getUserGiftRecordsByActNo(String userId, String actNo) {
        String sql = "select giftrecord.*,gift.* from \ngift join giftrecord on gift.giftId = giftrecord.giftId\nwhere giftrecord.isshow='1' and giftrecord.actNo=:actNo and giftrecord.userId=:userId";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("userId", (Object)userId);
        parameters.addValue("actNo", (Object)actNo);
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.getDataSource());
        return namedParameterJdbcTemplate.query(sql, (SqlParameterSource)parameters, (RowMapper)new BeanPropertyRowMapper(ActivityNGiftNGiftRecordDTO.class));
    }

    @Override
    public int countGiftRecordInOneDay(String userId, String date) {
        String sql = "select count(*) from bonusproductchargerecord where STR_TO_DATE(recordTime, '%Y-%m-%d')=:recordTime and userId=:userId and chargeFlag<>4";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("recordTime", (Object)date);
        parameters.addValue("userId", (Object)userId);
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.getDataSource());
        int a = namedParameterJdbcTemplate.queryForInt(sql, (SqlParameterSource)parameters);
        return a;
    }

    @Override
    public int countGiftRecord(String userId, String startTime, String endTime) {
        return this.countGiftRecord(userId, "niuxgift", startTime, endTime);
    }

    @Override
    public int countGiftRecord(String userId, String giftType, String startTime, String endTime) {
        String sql = "select count(*) from bonusproductchargerecord b left join gift g on b.productId = g.giftId\nwhere g.giftType=:giftType and  b.recordTime>:startTime and b.recordTime<:endTime and b.userId=:userId and b.chargeFlag<>4";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("startTime", (Object)startTime);
        parameters.addValue("endTime", (Object)endTime);
        parameters.addValue("userId", (Object)userId);
        parameters.addValue("giftType", (Object)giftType);
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.getDataSource());
        int a = namedParameterJdbcTemplate.queryForInt(sql, (SqlParameterSource)parameters);
        return a;
    }

    private String format(String time) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date date = sdf.parse(time);
            SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
            String resultStr = sdf1.format(date);
            return resultStr;
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public List<ProductDTO> getBoxBonusProductChargeList(int listNum, boolean isTimeLimit, boolean isEntityGift) {
        final ArrayList<ProductDTO> giftRecordDTOList = new ArrayList<ProductDTO>();
        String sql = "SELECT * FROM boxbonusproductcharge s1 LEFT JOIN gift s2 ON  s1.productId=s2.giftId where s1.isValid=1 ";
        Object[] args = null;
        if (isTimeLimit) {
            sql = sql + " and isTimeLimit=1";
        }
        if (isEntityGift) {
            sql = sql + " and giftType='product'";
        }
        sql = sql + " order by s1.orderNum desc";
        if (listNum > 0) {
            sql = sql + " limit 0, " + listNum;
        }
        this.getJdbcTemplate().query(sql, args, new RowCallbackHandler(){

            public void processRow(ResultSet resultSet) throws SQLException {
                ProductDTO giftRecordDTO = new ProductDTO();
                giftRecordDTO.setGiftid(resultSet.getString("productId"));
                giftRecordDTO.setGiftName(resultSet.getString("giftName"));
                String giftType = resultSet.getString("giftType");
                giftRecordDTO.setGiftType(StringTools.isEmpty((String)giftType) ? 2 : ("product".equals(giftType) ? 1 : 2));
                giftRecordDTO.setTotalNum(resultSet.getLong("totalCount"));
                giftRecordDTO.setRemainNum(resultSet.getLong("leftCount"));
                giftRecordDTO.setGiftBonusNum(resultSet.getLong("bonus"));
                giftRecordDTO.setGiftImgUrl(resultSet.getString("giftPic"));
                giftRecordDTO.setSmallImgUrl(resultSet.getString("smallPicUrl"));
                giftRecordDTO.setFirstLetter(resultSet.getString("firstLetter"));
                giftRecordDTO.setIsTimeLimit(resultSet.getInt("isTimeLimit"));
                String startTime = resultSet.getString("startTime");
                String valdateTime = resultSet.getString("valdateTime");
                giftRecordDTO.setStartTime(StringUtils.isEmpty((String)startTime) ? "" : GiftRecordDaoImpl.this.format(startTime));
                giftRecordDTO.setValdateTime(StringUtils.isEmpty((String)valdateTime) ? "" : GiftRecordDaoImpl.this.format(valdateTime));
                giftRecordDTOList.add(giftRecordDTO);
            }
        });
        return giftRecordDTOList;
    }

    @Override
    public List<ProductDTO> getDayBoxProduct(boolean isTimeLimit, boolean isEntityGift, int listNum, int giftId) {
        final ArrayList<ProductDTO> giftRecordDTOList = new ArrayList<ProductDTO>();
        String sql = "SELECT * FROM boxbonusproductcharge s1 LEFT JOIN gift s2 ON  s1.productId=s2.giftId where s1.isValid=1   and DATE_FORMAT(startTime,'%Y-%m-%d')>=CURDATE()  and DATE_FORMAT(valdateTime,'%Y-%m-%d')<=DATE_ADD(CURDATE(),INTERVAL 1 DAY) ";
        Object[] args = null;
        if (isTimeLimit) {
            sql = sql + " and isTimeLimit=1";
        }
        if (isEntityGift) {
            sql = sql + " and giftType='product'";
        }
        if (giftId > 0) {
            sql = sql + " and giftId=" + giftId + " ";
        }
        sql = sql + " order by startTime asc , s1.orderNum  desc ";
        if (listNum > 0) {
            sql = sql + " limit 0, " + listNum;
        }
        this.getJdbcTemplate().query(sql, args, new RowCallbackHandler(){

            public void processRow(ResultSet resultSet) throws SQLException {
                ProductDTO giftRecordDTO = new ProductDTO();
                giftRecordDTO.setGiftid(resultSet.getString("productId"));
                giftRecordDTO.setGiftName(resultSet.getString("giftName"));
                String giftType = resultSet.getString("giftType");
                giftRecordDTO.setGiftType(StringTools.isEmpty((String)giftType) ? 2 : ("product".equals(giftType) ? 1 : 2));
                giftRecordDTO.setTotalNum(resultSet.getLong("totalCount"));
                giftRecordDTO.setRemainNum(resultSet.getLong("leftCount"));
                giftRecordDTO.setGiftBonusNum(resultSet.getLong("bonus"));
                giftRecordDTO.setGiftImgUrl(resultSet.getString("giftPic"));
                giftRecordDTO.setSmallImgUrl(resultSet.getString("smallPicUrl"));
                giftRecordDTO.setFirstLetter(resultSet.getString("firstLetter"));
                giftRecordDTO.setIsTimeLimit(resultSet.getInt("isTimeLimit"));
                String startTime = resultSet.getString("startTime");
                String valdateTime = resultSet.getString("valdateTime");
                giftRecordDTO.setStartTime(StringUtils.isEmpty((String)startTime) ? "" : GiftRecordDaoImpl.this.format(startTime));
                giftRecordDTO.setValdateTime(StringUtils.isEmpty((String)valdateTime) ? "" : GiftRecordDaoImpl.this.format(valdateTime));
                giftRecordDTOList.add(giftRecordDTO);
            }
        });
        return giftRecordDTOList;
    }

    @Override
    public List<ProductDTO> getBonusProductChargeList(int listNum, boolean isTimeLimit, boolean isEntityGift, boolean isBox) {
        final ArrayList<ProductDTO> giftRecordDTOList = new ArrayList<ProductDTO>();
        String sql = "SELECT * FROM bonusproductcharge s1 LEFT JOIN gift s2 ON  s1.productId=s2.giftId where s1.isValid=1 ";
        Object[] args = null;
        if (isTimeLimit) {
            sql = sql + " and isTimeLimit=1";
        }
        if (isEntityGift) {
            sql = sql + " and giftType='product'";
        }
        if (isBox) {
            sql = sql + " and isBox = 1   and DATE_FORMAT(startTime,'%Y-%m-%d')>=CURDATE()  and DATE_FORMAT(valdateTime,'%Y-%m-%d')<=DATE_ADD(CURDATE(),INTERVAL 1 DAY) ";
        }
        sql = sql + " order by s1.orderNum desc";
        if (listNum > 0) {
            sql = sql + " limit 0, " + listNum;
        }
        this.getJdbcTemplate().query(sql, args, new RowCallbackHandler(){

            public void processRow(ResultSet resultSet) throws SQLException {
                ProductDTO giftRecordDTO = new ProductDTO();
                giftRecordDTO.setGiftid(resultSet.getString("productId"));
                giftRecordDTO.setGiftName(resultSet.getString("giftName"));
                String giftType = resultSet.getString("giftType");
                giftRecordDTO.setGiftType(StringTools.isEmpty((String)giftType) ? 2 : ("product".equals(giftType) ? 1 : 2));
                giftRecordDTO.setTotalNum(resultSet.getLong("totalCount"));
                giftRecordDTO.setRemainNum(resultSet.getLong("leftCount"));
                giftRecordDTO.setGiftBonusNum(resultSet.getLong("bonus"));
                giftRecordDTO.setGiftImgUrl(resultSet.getString("giftPic"));
                giftRecordDTO.setSmallImgUrl(resultSet.getString("smallPicUrl"));
                giftRecordDTO.setFirstLetter(resultSet.getString("firstLetter"));
                giftRecordDTO.setIsTimeLimit(resultSet.getInt("isTimeLimit"));
                String startTime = resultSet.getString("startTime");
                String valdateTime = resultSet.getString("valdateTime");
                giftRecordDTO.setStartTime(StringUtils.isEmpty((String)startTime) ? "" : GiftRecordDaoImpl.this.format(startTime));
                giftRecordDTO.setValdateTime(StringUtils.isEmpty((String)valdateTime) ? "" : GiftRecordDaoImpl.this.format(valdateTime));
                giftRecordDTOList.add(giftRecordDTO);
            }
        });
        return giftRecordDTOList;
    }
}

