package com.xunlei.niux.data.vipgame.bo.pay;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;


import com.ferret.common.dao.BaseDao;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.easyutils.commonutils.OrderNoUtil;
import com.xunlei.niux.data.vipgame.vo.pay.PayOrder;
import com.xunlei.niux.data.vipgame.vo.pay.RechargeRecord;

public class PayOrderBoImpl implements PayOrderBo {
	private BaseDao baseDao;
	
	public BaseDao getBaseDao() {
		return baseDao;
	}

	public void setBaseDao(BaseDao baseDao) {
		this.baseDao = baseDao;
	}
	/**
	 * 插入订单
	 */
	public void insert(PayOrder payOrder) {
		baseDao.insert(payOrder);
	}
	/**
	 * 更新订单
	 */
	public void update(PayOrder payOrder) {
		baseDao.updateById(payOrder);
	}
	public int count(PayOrder payOrder) {
		return baseDao.count(payOrder);
	}
	
	public List<PayOrder> find(PayOrder payOrder, Page page) {
		return baseDao.findByObject(PayOrder.class, payOrder, page);
	}

	public PayOrder find(Long seqId) {
		return baseDao.findById(PayOrder.class, seqId);
	}
	
	public PayOrder findByOrderNo(String orderNo) {
		PayOrder payOrder=new PayOrder();
		payOrder.setOrderNo(orderNo);
		List<PayOrder> list=baseDao.findByObject(PayOrder.class, payOrder, new Page());
		return (list==null||list.size()==0)?null:list.get(0);
	}
	public void updateSuccessOrder(PayOrder payOrder){
		//更新状态
		baseDao.updateById(payOrder);
		String payId="";
		if("E2".equals(payOrder.getPayType())){
			payId="16";
		}else if("A1".equals(payOrder.getPayType())){
			payId="1";
		}else{
			payId="4";
		}
		//插入充值订单
		RechargeRecord rr=new RechargeRecord();
		rr.setRechargeNo(OrderNoUtil.getOrderNo());
		rr.setRechargeTime(sdf.format(new Date()));
		rr.setNextCallRechargeTime(rr.getRechargeTime());
		rr.setRechargeStatus("0");//成功
		rr.setProductName("白金会员");
		rr.setFailNum(0);
		rr.setRechargeType("1");//
		rr.setOrderNo(payOrder.getOrderNo());
		rr.setRechargeNum(payOrder.getProductNum());
		rr.setGameId("");
		rr.setRoleName("");
		rr.setServerId("");
		rr.setPayId(payId);
		rr.setExt1("0");
		rr.setUserId(payOrder.getUserId());
		FacadeFactory.INSTANCE.getRechargeRecordBo().insert(rr);
//		//插入一个月充值订单
//		RechargeRecord rr1=new RechargeRecord();
//		rr1.setRechargeNo(OrderNoUtil.getOrderNo());
//		rr1.setRechargeTime(sdf.format(new Date()));
//		rr1.setNextCallRechargeTime(rr1.getRechargeTime());
//		rr1.setRechargeStatus("0");//
//		rr1.setProductName("白金会员");
//		rr1.setFailNum(0);
//		rr1.setRechargeType("2");//活动开发日充值送元宝
//		rr1.setOrderNo(payOrder.getOrderNo());
//		rr1.setRechargeNum(1);
//		rr1.setGameId("");
//		rr1.setRoleName("");
//		rr1.setPayId(payId);
//		rr1.setServerId("");
//		rr1.setExt1("0");
//		rr1.setExt2("赠送一个月白金会员");
//		rr1.setUserId(payOrder.getUserId());
//		FacadeFactory.INSTANCE.getRechargeRecordBo().insert(rr1);
	}
	private static SimpleDateFormat sdf=new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
}