package com.xunlei.niux.data.vipgame.bo;

import java.util.List;

import com.ferret.common.dao.BaseDao;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.vipgame.vo.HtmlTemplate;

public class HtmlTemplateBoImpl implements HtmlTemplateBo {
    private BaseDao baseDao;

    public BaseDao getBaseDao() {
        return baseDao;
    }

    public void setBaseDao(BaseDao baseDao) {
        this.baseDao = baseDao;
    }

    public HtmlTemplate find(String templateid) {
        return baseDao.findById(HtmlTemplate.class, templateid);
    }

    public List<HtmlTemplate> find(HtmlTemplate htmlTemplate) {
        return baseDao.findByObject(HtmlTemplate.class, htmlTemplate, new Page());
    }

    public void insert(HtmlTemplate htmlTemplate) {
        baseDao.insert(htmlTemplate);
    }

    @Override
    public void delete(String templateid) {
        baseDao.deleteById(HtmlTemplate.class, templateid);
    }

    @Override
    public List<HtmlTemplate> find(HtmlTemplate htmlTemplate, int pageNo, int pageSize) {
        Page page = new Page(pageNo, pageSize);

        return baseDao.findByObject(HtmlTemplate.class, htmlTemplate, page);

    }

    @Override
    public int count(HtmlTemplate htmlTemplate) {
        return baseDao.count(htmlTemplate);
    }

    public void update(HtmlTemplate htmlTemplate) {
        baseDao.updateById(htmlTemplate);
    }
}
