package com.xunlei.niux.data.vipgame.bo;

import java.util.List;

import com.ferret.common.dao.BaseDao;
import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.vipgame.vo.GameContent;

public class GameContentBoImpl implements GameContentBo {
	private BaseDao baseDao;
	public BaseDao getBaseDao() {
		return baseDao;
	}
	public void setBaseDao(BaseDao baseDao) {
		this.baseDao = baseDao;
	}
	/**
	 * 查询游戏内容
	 * @param content
	 * @param start
	 * @param limit
	 * @return
	 */
	public List<GameContent> findGameContent(GameContent content,int pageNo,int pageSize){
		Page page=new Page();
		page.setPageNo(pageNo);
		page.setPageSize(pageSize);
		page.addOrder("displayOrder", OrderType.DESC);
		return baseDao.findByObject(GameContent.class, content, page);
	}
	public List<GameContent> findGameContent(GameContent content,Page page){
		return baseDao.findByObject(GameContent.class, content, page);
	}
	public GameContent findGameContentById(long seqId){
		return baseDao.findById(GameContent.class, seqId);
	}
	public int count(GameContent content){
		return baseDao.count(content);
	}
	public void update(GameContent content){
		 baseDao.updateById(content);
	}
	public void insert(GameContent content) {
		baseDao.insert(content);
	}
	public void delete(Long seqId) {
		baseDao.deleteById(GameContent.class, seqId);
	}
}
