package com.xunlei.niux.data.vipgame.dao.vic;


import com.ferret.common.dao.BaseDaoImpl;
import org.apache.commons.lang.StringUtils;
import org.springframework.jdbc.support.rowset.SqlRowSet;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CustomerDaoImpl extends BaseDaoImpl implements CustomerDao{

    private final static String SQL_1 = " AND c.lastPayTime>=(CURDATE() - INTERVAL 2 DAY) ";
    private final static String SQL_2 = " AND c.lastPayTime=(CURDATE() - INTERVAL 3 DAY) ";
    private final static String SQL_3 = " AND  c.lastLoginTime>=(CURDATE() - INTERVAL 4 DAY) \n"+
            " and (c.lastPayTime>=(CURDATE() - INTERVAL 7 DAY) AND c.lastPayTime<=(CURDATE() - INTERVAL 4 DAY))";
    private final static String SQL_4 = " AND  (c.lastLoginTime>=(CURDATE() - INTERVAL 7 DAY) AND c.lastLoginTime<=(CURDATE() - INTERVAL 5 DAY)) \n" +
            " AND (c.lastPayTime>=(CURDATE() - INTERVAL 7 DAY) AND c.lastPayTime<=(CURDATE() - INTERVAL 4 DAY)) ";
    private final static String SQL_5 = " AND c.lastPayTime>=(CURDATE() - INTERVAL 14 DAY) AND c.lastPayTime<=(CURDATE() - INTERVAL 8 DAY) ";
    private final static String SQL_6 = " AND c.lastPayTime<=(CURDATE() - INTERVAL 15 DAY) ";

    @Override
    public Map<Integer, Integer> getVipGradeGroupByLost(Integer loginPay, String lastPayGame, String lastPayTimeFrom, String lastPayTimeTo, String customerService) {
        Map<Integer, Integer> vipGradeMap = new HashMap<Integer, Integer>();
        StringBuilder sql = new StringBuilder();
        List<Object> params = new ArrayList<Object>();
        sql.append(" SELECT vipGrade, COUNT(vipGrade) AS cnt \n" +
                " FROM customerdetailquery c \n" +
                " WHERE 1=1 ");
        if(StringUtils.isNotEmpty(lastPayGame)){
            sql.append(" AND c.payGameId=? ");
            params.add(lastPayGame);
        }
        if(StringUtils.isNotEmpty(lastPayTimeFrom)){
            sql.append(" AND c.lastPayTime>=? ");
            params.add(lastPayTimeFrom);
        }
        if(StringUtils.isNotEmpty(lastPayTimeTo)){
            sql.append(" AND c.lastPayTime<=? ");
            params.add(lastPayTimeTo);
        }
        if(StringUtils.isNotEmpty(customerService)){
            sql.append(" AND c.customerService=? ");
            params.add(customerService);
        }
        switch (loginPay){
            case 1:
                sql.append(SQL_1);
                break;
            case 2:
                sql.append(SQL_2);
                break;
            case 3:
                sql.append(SQL_3);
                break;
            case 4:
                sql.append(SQL_4);
                break;
            case 5:
                sql.append(SQL_5);
                break;
            case 6:
                sql.append(SQL_6);
                break;
        }
        sql.append(" GROUP BY vipGrade");

        SqlRowSet rowSet =  getJdbcTemplate().queryForRowSet(sql.toString(),params.toArray());
        while(rowSet.next()){
            vipGradeMap.put(rowSet.getInt(1),rowSet.getInt(2));
        }
        return vipGradeMap;
    }


    @Override
    public SqlRowSet getLostPayGroupByLost(Integer loginPay, String lastPayGame, String lastPayTimeFrom, String lastPayTimeTo, String customerService) {
        StringBuilder sql = new StringBuilder();
        List<Object> params = new ArrayList<Object>();
        sql.append(" SELECT lostPay, COUNT(lostPay) AS cnt \n" +
                " FROM customerdetailquery c \n" +
                " LEFT JOIN customerinfo i ON c.uid=i.uid \n" +
                " WHERE 1=1 ");
        if(StringUtils.isNotEmpty(lastPayGame)){
            sql.append(" AND c.payGameId=? ");
            params.add(lastPayGame);
        }
        if(StringUtils.isNotEmpty(lastPayTimeFrom)){
            sql.append(" AND c.lastPayTime>=? ");
            params.add(lastPayTimeFrom);
        }
        if(StringUtils.isNotEmpty(lastPayTimeTo)){
            sql.append(" AND c.lastPayTime<=? ");
            params.add(lastPayTimeTo);
        }
        if(StringUtils.isNotEmpty(customerService)){
            sql.append(" AND c.customerService=? ");
            params.add(customerService);
        }
        switch (loginPay){
            case 1:
                sql.append(SQL_1);
                break;
            case 2:
                sql.append(SQL_2);
                break;
            case 3:
                sql.append(SQL_3);
                break;
            case 4:
                sql.append(SQL_4);
                break;
            case 5:
                sql.append(SQL_5);
                break;
            case 6:
                sql.append(SQL_6);
                break;
        }
        sql.append(" GROUP BY lostPay");

        return getJdbcTemplate().queryForRowSet(sql.toString(),params.toArray());
    }

    @Override
    public int countHightVipGradeWithin15Days(String lastPayGame, String lastPayTimeFrom, String lastPayTimeTo, String customerService) {
        List<Object> params = new ArrayList<Object>();
        StringBuilder sql = new StringBuilder();
        sql.append( " SELECT COUNT(*) FROM customerdetailquery WHERE (vipGrade<=10 AND vipGrade>=7 ) AND lastCallTime>=(CURDATE() - INTERVAL 15 DAY) ");
        if(StringUtils.isNotEmpty(lastPayGame)){
            sql.append(" AND payGameId=? ");
            params.add(lastPayGame);
        }
        if(StringUtils.isNotEmpty(lastPayTimeFrom)){
            sql.append(" AND lastPayTime>=? ");
            params.add(lastPayTimeFrom);
        }
        if(StringUtils.isNotEmpty(lastPayTimeTo)){
            sql.append(" AND lastPayTime<=? ");
            params.add(lastPayTimeTo);
        }
        if(StringUtils.isNotEmpty(customerService)){
            sql.append(" AND customerService=? ");
            params.add(customerService);
        }

        return getJdbcTemplate().queryForInt(sql.toString(), params.toArray());
    }
}
