package com.xunlei.niux.data.vipgame.bo;

import java.text.SimpleDateFormat;
import java.util.List;

import javax.annotation.Resource;

import com.ferret.common.dao.BaseDao;
import com.ferret.common.dao.vo.Page;

public class CommonSo {
	protected static SimpleDateFormat sdfDate=new SimpleDateFormat("yyyy-MM-dd");
	protected static SimpleDateFormat sdfTime=new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
	@Resource(name="BaseDao")
	protected BaseDao baseDao;
	
	public BaseDao getBaseDao() {
		return baseDao;
	}

	public void setBaseDao(BaseDao baseDao) {
		this.baseDao = baseDao;
	}
	public <T> T findById(Class<T> clazz,Number id){
		return baseDao.findById(clazz,id);
	}
	public <T> T findById(Class<T> clazz,String id){
		return baseDao.findById(clazz, id);
	}
	public <T> T findObject(T queryObject){
		Page page=new Page();
		List<T> list= findObjects(queryObject,page);
		return (list==null||list.size()==0)?null:list.get(0);
	}
	@SuppressWarnings("unchecked")
	public <T> List<T> findObjects(T queryObject,Page page){
		return (List<T>) baseDao.findByObject(queryObject.getClass(),queryObject,page);
	}
	public <T> void addObject(T object){
		baseDao.insert(object);
	}
	public <T> void deleteById(Class<T> clazz,Number id){
		baseDao.deleteById(clazz, id);
	}
	public <T> void deleteById(Class<T> clazz,String id){
		baseDao.deleteById(clazz, id);
	}
	public <T> void updateObjectById(T object){
		baseDao.updateById(object);
	}
	public <T> int countObject(T object){
		return baseDao.count(object);
	}
}
