package com.xunlei.niux.data.vipgame.bo.vic;


import com.ferret.common.dao.BaseDao;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.vipgame.dto.vic.CustomerWarningLostLoginDTO;
import com.xunlei.niux.data.vipgame.dto.vic.CustomerWarningLostPayDTO;
import org.apache.commons.lang.StringUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CustomerBoImpl implements CustomerBo{

    private BaseDao baseDao;

    public BaseDao getBaseDao() {
        return baseDao;
    }

    public void setBaseDao(BaseDao baseDao) {
        this.baseDao = baseDao;
    }

    @Override
    public int countQueryData(String lastPayGame, String lastPayTimeFrom, String lastPayTimeTo,
                              Integer vipGradeFrom, Integer vipGradeTo, String customerService,
                              Integer loginPay) {
        List<Object> params = new ArrayList<Object>();
        StringBuilder sql = new StringBuilder();
        sql.append( "SELECT count(*) as cnt FROM (SELECT DATEDIFF(NOW(),c.lastLoginTime) AS lostLoginDays,DATEDIFF(NOW(),c.lastPayTime) AS lostPayDays\n" +
                "FROM customerdetailquery c LEFT JOIN customerinfo p ON c.uid=p.uid\n" +
                "WHERE 1=1 ");
        if(StringUtils.isNotEmpty(lastPayGame)){
            sql.append(" AND c.payGameId=? ");
            params.add(lastPayGame);
        }
        if(StringUtils.isNotEmpty(lastPayTimeFrom)){
            sql.append(" AND c.lastPayTime>=? ");
            params.add(lastPayTimeFrom);
        }
        if(StringUtils.isNotEmpty(lastPayTimeTo)){
            sql.append(" AND c.lastPayTime<=? ");
            params.add(lastPayTimeTo);
        }
        if(vipGradeFrom!=null&&vipGradeFrom!=0){
            sql.append(" AND c.vipGrade>=? ");
            params.add(vipGradeFrom);
        }
        if(vipGradeTo!=null&&vipGradeTo!=0){
            sql.append(" AND c.vipGrade<=? ");
            params.add(vipGradeTo);
        }
        if(StringUtils.isNotEmpty(customerService)){
            sql.append(" AND c.customerService=? ");
            params.add(customerService);
        }

        sql.append(" ) a where 1=1");

        if(loginPay!=null&&loginPay!=0){
            switch (loginPay){
                case 1:
                    sql.append(" AND lostLoginDays<=1 AND lostPayDays<=1 ");
                    break;
                case 2:
                    sql.append(" AND ( lostLoginDays=2 OR lostPayDays=2 )");
                    break;
                case 3:
                    break;
                case 4:
                    sql.append(" AND lostLoginDays>=3 AND lostLoginDays>=3  AND lostPayDays<=6 AND lostPayDays<=6 ");
                    break;
                case 5:
                    sql.append(" AND ((lostLoginDays>=7 AND lostLoginDays<=13) OR (lostPayDays>=7 AND lostPayDays<=13)) ");
                    break;
                case 6:
                    sql.append(" AND ( lostLoginDays>=14 OR lostPayDays>=14 ) ");
                    break;
            }
        }
        Map<String, Object> map = baseDao.findForMap(sql.toString(),params);
        if(map==null || map.get("cnt")==null)return 0;
        Number number = (Number)map.get("cnt");
        return (number != null ? number.intValue() : 0);
    }

    @Override
    public List<CustomerWarningLostPayDTO> queryData(String lastPayGame, String lastPayTimeFrom, String lastPayTimeTo,
                                                     Integer vipGradeFrom, Integer vipGradeTo, String customerService,
                                                     Integer loginPay,Page page) {
        List<Object> params = new ArrayList<Object>();
        StringBuilder sql = new StringBuilder();
        sql.append( "SELECT * FROM (SELECT c.uid,c.vipGrade,c.lastLoginTime,c.lastPayTime,c.lastModifyAmt,c.payGameId,c.lastCaller,c.lastCallTime,c.customerService,\n" +
                "p.lostPay,p.firstTreat,p.firstTreatResult,p.secondTreat,p.secondTreatResult,\n" +
                "DATEDIFF(NOW(),c.lastLoginTime) AS lostLoginDays,DATEDIFF(NOW(),c.lastPayTime) AS lostPayDays\n" +
                "FROM customerdetailquery c LEFT JOIN customerinfo p ON c.uid=p.uid\n" +
                "WHERE 1=1 ");
        if(StringUtils.isNotEmpty(lastPayGame)){
            sql.append(" AND c.payGameId=? ");
            params.add(lastPayGame);
        }
        if(StringUtils.isNotEmpty(lastPayTimeFrom)){
            sql.append(" AND c.lastPayTime>=? ");
            params.add(lastPayTimeFrom);
        }
        if(StringUtils.isNotEmpty(lastPayTimeTo)){
            sql.append(" AND c.lastPayTime<=? ");
            params.add(lastPayTimeTo);
        }
        if(vipGradeFrom!=null&&vipGradeFrom!=0){
            sql.append(" AND c.vipGrade>=? ");
            params.add(vipGradeFrom);
        }
        if(vipGradeTo!=null&&vipGradeTo!=0){
            sql.append(" AND c.vipGrade<=? ");
            params.add(vipGradeTo);
        }
        if(StringUtils.isNotEmpty(customerService)){
            sql.append(" AND c.customerService=? ");
            params.add(customerService);
        }

        sql.append(" ) a where 1=1");

        if(loginPay!=null&&loginPay!=0){
            switch (loginPay){
                case 1:
                    sql.append(" AND lostLoginDays<=1 AND lostPayDays<=1 ");
                    break;
                case 2:
                    sql.append(" AND ( lostLoginDays=2 OR lostPayDays=2 )");
                    break;
                case 3:
                    break;
                case 4:
                    sql.append(" AND lostLoginDays>=3 AND lostLoginDays>=3  AND lostPayDays<=6 AND lostPayDays<=6 ");
                    break;
                case 5:
                    sql.append(" AND ((lostLoginDays>=7 AND lostLoginDays<=13) OR (lostPayDays>=7 AND lostPayDays<=13)) ");
                    break;
                case 6:
                    sql.append(" AND ( lostLoginDays>=14 OR lostPayDays>=14 ) ");
                    break;
            }
        }
        int pageNo = page.getPageNo();
        int pageSize = page.getPageSize();
        sql.append(" LIMIT "+(pageNo-1)*pageSize+", "+pageSize);

        return baseDao.findBySql(CustomerWarningLostPayDTO.class,sql.toString(),params);
    }

    @Override
    public int countQueryDataLogin(String lastLoginGame,String lastLoginTimeFrom,String lastLoginTimeTo,
                              Integer vipGradeFrom, Integer vipGradeTo, String customerService,
                              Integer loginPay) {
        List<Object> params = new ArrayList<Object>();
        StringBuilder sql = new StringBuilder();
        sql.append( "SELECT count(*) as cnt FROM (SELECT DATEDIFF(NOW(),c.lastLoginTime) AS lostLoginDays,DATEDIFF(NOW(),c.lastPayTime) AS lostPayDays\n" +
                "FROM customerdetailquery c LEFT JOIN customerinfo p ON c.uid=p.uid\n" +
                "WHERE 1=1 ");
        if(StringUtils.isNotEmpty(lastLoginGame)){
            sql.append(" AND c.loginGameId=? ");
            params.add(lastLoginGame);
        }
        if(StringUtils.isNotEmpty(lastLoginTimeFrom)){
            sql.append(" AND c.lastLoginTime>=? ");
            params.add(lastLoginTimeFrom);
        }
        if(StringUtils.isNotEmpty(lastLoginTimeTo)){
            sql.append(" AND c.lastLoginTime<=? ");
            params.add(lastLoginTimeTo);
        }
        if(vipGradeFrom!=null&&vipGradeFrom!=0){
            sql.append(" AND c.vipGrade>=? ");
            params.add(vipGradeFrom);
        }
        if(vipGradeTo!=null&&vipGradeTo!=0){
            sql.append(" AND c.vipGrade<=? ");
            params.add(vipGradeTo);
        }
        if(StringUtils.isNotEmpty(customerService)){
            sql.append(" AND c.customerService=? ");
            params.add(customerService);
        }

        sql.append(" ) a where 1=1");

        if(loginPay!=null&&loginPay!=0){
            switch (loginPay){
                case 1:
                    sql.append(" AND lostLoginDays<=1 AND lostPayDays<=1 ");
                    break;
                case 2:
                    sql.append(" AND ( lostLoginDays=2 OR lostPayDays=2 )");
                    break;
                case 3:
                    break;
                case 4:
                    sql.append(" AND lostLoginDays>=3 AND lostLoginDays>=3  AND lostPayDays<=6 AND lostPayDays<=6 ");
                    break;
                case 5:
                    sql.append(" AND ((lostLoginDays>=7 AND lostLoginDays<=13) OR (lostPayDays>=7 AND lostPayDays<=13)) ");
                    break;
                case 6:
                    sql.append(" AND ( lostLoginDays>=14 OR lostPayDays>=14 ) ");
                    break;
            }
        }
        Map<String, Object> map = baseDao.findForMap(sql.toString(),params);
        if(map==null || map.get("cnt")==null)return 0;
        Number number = (Number)map.get("cnt");
        return (number != null ? number.intValue() : 0);
    }

    @Override
    public List<CustomerWarningLostLoginDTO> queryDataLogin(String lastLoginGame,String lastLoginTimeFrom,String lastLoginTimeTo,
                                                     Integer vipGradeFrom, Integer vipGradeTo, String customerService,
                                                     Integer loginPay,Page page) {
        List<Object> params = new ArrayList<Object>();
        StringBuilder sql = new StringBuilder();
        sql.append( "SELECT * FROM (SELECT c.uid,c.vipGrade,c.lastLoginTime,c.lastPayTime,c.lastModifyAmt,c.payGameId,c.loginGameId,c.lastCaller,c.lastCallTime,c.customerService,\n" +
                "p.lostLogin,p.firstTreatLogin,p.firstTreatResultLogin,p.secondTreatLogin,p.secondTreatResultLogin,\n" +
                "DATEDIFF(NOW(),c.lastLoginTime) AS lostLoginDays,DATEDIFF(NOW(),c.lastPayTime) AS lostPayDays\n" +
                "FROM customerdetailquery c LEFT JOIN customerinfo p ON c.uid=p.uid\n" +
                "WHERE 1=1 ");
        if(StringUtils.isNotEmpty(lastLoginGame)){
            sql.append(" AND c.loginGameId=? ");
            params.add(lastLoginGame);
        }
        if(StringUtils.isNotEmpty(lastLoginTimeFrom)){
            sql.append(" AND c.lastLoginTime>=? ");
            params.add(lastLoginTimeFrom);
        }
        if(StringUtils.isNotEmpty(lastLoginTimeTo)){
            sql.append(" AND c.lastLoginTime<=? ");
            params.add(lastLoginTimeTo);
        }
        if(vipGradeFrom!=null&&vipGradeFrom!=0){
            sql.append(" AND c.vipGrade>=? ");
            params.add(vipGradeFrom);
        }
        if(vipGradeTo!=null&&vipGradeTo!=0){
            sql.append(" AND c.vipGrade<=? ");
            params.add(vipGradeTo);
        }
        if(StringUtils.isNotEmpty(customerService)){
            sql.append(" AND c.customerService=? ");
            params.add(customerService);
        }

        sql.append(" ) a where 1=1");

        if(loginPay!=null&&loginPay!=0){
            switch (loginPay){
                case 1:
                    sql.append(" AND lostLoginDays<=1 AND lostPayDays<=1 ");
                    break;
                case 2:
                    sql.append(" AND ( lostLoginDays=2 OR lostPayDays=2 )");
                    break;
                case 3:
                    break;
                case 4:
                    sql.append(" AND lostLoginDays>=3 AND lostLoginDays>=3  AND lostPayDays<=6 AND lostPayDays<=6 ");
                    break;
                case 5:
                    sql.append(" AND ((lostLoginDays>=7 AND lostLoginDays<=13) OR (lostPayDays>=7 AND lostPayDays<=13)) ");
                    break;
                case 6:
                    sql.append(" AND ( lostLoginDays>=14 OR lostPayDays>=14 ) ");
                    break;
            }
        }
        int pageNo = page.getPageNo();
        int pageSize = page.getPageSize();
        sql.append(" LIMIT "+(pageNo-1)*pageSize+", "+pageSize);

        return baseDao.findBySql(CustomerWarningLostLoginDTO.class,sql.toString(),params);
    }
}
