package com.xunlei.niux.data.vipgame.facade;

import java.util.ResourceBundle;

import org.springframework.context.support.ClassPathXmlApplicationContext;

public class FacadeFactory {
	public static final IFacade INSTANCE;
	static{
		String jndi=getJndiType();
		if("tomcat".equals(jndi)){
			INSTANCE=(IFacade)new ClassPathXmlApplicationContext(new String[]{"com/xunlei/niux/data/vipgame/xml/tomcatjndi.xml","com/xunlei/niux/data/vipgame/xml/applicationContext.xml"}).getBean("VipGameFacade");
		}else if("jdbc".equals(jndi)){
			INSTANCE=(IFacade)new ClassPathXmlApplicationContext(new String[]{"com/xunlei/niux/data/vipgame/xml/jdbc.xml","com/xunlei/niux/data/vipgame/xml/applicationContext.xml"}).getBean("VipGameFacade");
		}else{
			INSTANCE=(IFacade)new ClassPathXmlApplicationContext(new String[]{"com/xunlei/niux/data/vipgame/xml/springjndi.xml","com/xunlei/niux/data/vipgame/xml/applicationContext.xml"}).getBean("VipGameFacade");
		}
	}
	private static String getJndiType(){
		try{
			String type=ResourceBundle.getBundle("jnditype").getString("xlniuxdata_vipgame_jndi_type");
			if(type==null){
				return "";
			}
			return type.trim().toLowerCase();
		}catch(Exception e){
			return "";
		}
	}
}
