package com.xunlei.niux.data.vipgame.bo.vic;


import com.ferret.common.dao.BaseDao;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.vipgame.dto.vic.CustomerWarningLostLoginDTO;
import com.xunlei.niux.data.vipgame.dto.vic.CustomerWarningLostPayDTO;
import org.apache.commons.lang.StringUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CustomerBoImpl implements CustomerBo{

    private BaseDao baseDao;

    public BaseDao getBaseDao() {
        return baseDao;
    }

    public void setBaseDao(BaseDao baseDao) {
        this.baseDao = baseDao;
    }

    private final static String SQL_1 = "SELECT c.uid,c.vipGrade,c.lastLoginTime,c.lastPayTime,c.lastModifyAmt,c.payGameId,c.loginGameId,c.lastCaller,c.lastCallTime,c.customerService, 1 AS loginPayType\n" +
            " FROM customerdetailquery c\n" +
            " WHERE c.lastLoginTime>=(CURDATE() - INTERVAL 1 DAY) AND c.lastPayTime>=(CURDATE() - INTERVAL 1 DAY)";

    private final static String SQL_2 ="SELECT c.uid,c.vipGrade,c.lastLoginTime,c.lastPayTime,c.lastModifyAmt,c.payGameId,c.loginGameId,c.lastCaller,c.lastCallTime,c.customerService,  2 AS loginPayType\n" +
            " FROM customerdetailquery c\n" +
            " WHERE c.lastPayTime=(CURDATE() - INTERVAL 2 DAY)";

    private final static String SQL_3 ="  SELECT c.uid,c.vipGrade,c.lastLoginTime,c.lastPayTime,c.lastModifyAmt,c.payGameId,c.loginGameId,c.lastCaller,c.lastCallTime,c.customerService, 3 AS loginPayType\n" +
            " FROM customerdetailquery c\n" +
            " WHERE c.lastLoginTime>=(CURDATE() - INTERVAL 3 DAY) \n" +
            " and (c.lastPayTime>=(CURDATE() - INTERVAL 6 DAY) AND c.lastPayTime<=(CURDATE() - INTERVAL 3 DAY)) ";

    private final static String SQL_4 ="SELECT c.uid,c.vipGrade,c.lastLoginTime,c.lastPayTime,c.lastModifyAmt,c.payGameId,c.loginGameId,c.lastCaller,c.lastCallTime,c.customerService, 4 AS loginPayType\n" +
            " FROM customerdetailquery c\n" +
            " WHERE (c.lastLoginTime>=(CURDATE() - INTERVAL 6 DAY) and c.lastLoginTime<=(CURDATE() - INTERVAL 4 DAY)) \n" +
            " and (c.lastPayTime>=(CURDATE() - INTERVAL 6 DAY) AND c.lastPayTime<=(CURDATE() - INTERVAL 3 DAY)) ";

    private final static String SQL_5 ="SELECT c.uid,c.vipGrade,c.lastLoginTime,c.lastPayTime,c.lastModifyAmt,c.payGameId,c.loginGameId,c.lastCaller,c.lastCallTime,c.customerService,  5 AS loginPayType\n" +
            " FROM customerdetailquery c\n" +
            " WHERE c.lastPayTime>=(CURDATE() - INTERVAL 13 DAY) AND c.lastPayTime<=(CURDATE() - INTERVAL 7 DAY)";

    private final static String SQL_6 ="SELECT c.uid,c.vipGrade,c.lastLoginTime,c.lastPayTime,c.lastModifyAmt,c.payGameId,c.loginGameId,c.lastCaller,c.lastCallTime,c.customerService,  6 AS loginPayType\n" +
            " FROM customerdetailquery c\n" +
            " WHERE c.lastPayTime<=(CURDATE() - INTERVAL 14 DAY)";



    @Override
    public int countQueryData(String lastPayGame, String lastPayTimeFrom, String lastPayTimeTo,
                              Integer vipGradeFrom, Integer vipGradeTo, String customerService,
                              Integer loginPay) {
        List<Object> params = new ArrayList<Object>();
        StringBuilder sql = new StringBuilder();
        sql.append( "SELECT count(*) as cnt FROM (%s) c " +
                "WHERE 1=1 ");
        if(StringUtils.isNotEmpty(lastPayGame)){
            sql.append(" AND c.payGameId=? ");
            params.add(lastPayGame);
        }
        if(StringUtils.isNotEmpty(lastPayTimeFrom)){
            sql.append(" AND c.lastPayTime>=? ");
            params.add(lastPayTimeFrom);
        }
        if(StringUtils.isNotEmpty(lastPayTimeTo)){
            sql.append(" AND c.lastPayTime<=? ");
            params.add(lastPayTimeTo);
        }
        if(vipGradeFrom!=null&&vipGradeFrom!=0){
            sql.append(" AND c.vipGrade>=? ");
            params.add(vipGradeFrom);
        }
        if(vipGradeTo!=null&&vipGradeTo!=0){
            sql.append(" AND c.vipGrade<=? ");
            params.add(vipGradeTo);
        }
        if(StringUtils.isNotEmpty(customerService)){
            sql.append(" AND c.customerService=? ");
            params.add(customerService);
        }

        String unionSql = "";
        switch (loginPay){
            case 1:
                unionSql = SQL_1;
                break;
            case 2:
                unionSql = SQL_2;
                break;
            case 3:
                unionSql = SQL_3;
                break;
            case 4:
                unionSql = SQL_4;
                break;
            case 5:
                unionSql = SQL_5;
                break;
            case 6:
                unionSql = SQL_6;
                break;
            default:
                unionSql = SQL_1+" union "+SQL_2+" union "+SQL_3+" union "+SQL_4+" union "+SQL_5+" union "+SQL_6;
        }
        String exeSql = String.format(sql.toString(),unionSql);
        Map<String, Object> map = baseDao.findForMap(exeSql,params);
        if(map==null || map.get("cnt")==null)return 0;
        Number number = (Number)map.get("cnt");
        return (number != null ? number.intValue() : 0);
    }

    @Override
    public List<CustomerWarningLostPayDTO> queryData(String lastPayGame, String lastPayTimeFrom, String lastPayTimeTo,
                                                     Integer vipGradeFrom, Integer vipGradeTo, String customerService,
                                                     Integer loginPay,Page page) {
        List<Object> params = new ArrayList<Object>();
        StringBuilder sql = new StringBuilder();
        sql.append( "SELECT c.*,i.lostPay,i.firstTreat,i.firstTreatResult,i.secondTreat,i.secondTreatResult FROM (%s) c left join customerinfo i on c.uid=i.uid " +
                " WHERE 1=1 ");
        if(StringUtils.isNotEmpty(lastPayGame)){
            sql.append(" AND c.payGameId=? ");
            params.add(lastPayGame);
        }
        if(StringUtils.isNotEmpty(lastPayTimeFrom)){
            sql.append(" AND c.lastPayTime>=? ");
            params.add(lastPayTimeFrom);
        }
        if(StringUtils.isNotEmpty(lastPayTimeTo)){
            sql.append(" AND c.lastPayTime<=? ");
            params.add(lastPayTimeTo);
        }
        if(vipGradeFrom!=null&&vipGradeFrom!=0){
            sql.append(" AND c.vipGrade>=? ");
            params.add(vipGradeFrom);
        }
        if(vipGradeTo!=null&&vipGradeTo!=0){
            sql.append(" AND c.vipGrade<=? ");
            params.add(vipGradeTo);
        }
        if(StringUtils.isNotEmpty(customerService)){
            sql.append(" AND c.customerService=? ");
            params.add(customerService);
        }
        int pageNo = page.getPageNo();
        int pageSize = page.getPageSize();
        sql.append(" LIMIT "+(pageNo-1)*pageSize+", "+pageSize);

        String unionSql = "";
        switch (loginPay){
            case 1:
                unionSql = SQL_1;
                break;
            case 2:
                unionSql = SQL_2;
                break;
            case 3:
                unionSql = SQL_3;
                break;
            case 4:
                unionSql = SQL_4;
                break;
            case 5:
                unionSql = SQL_5;
                break;
            case 6:
                unionSql = SQL_6;
                break;
            default:
                unionSql = SQL_1+" union "+SQL_2+" union "+SQL_3+" union "+SQL_4+" union "+SQL_5+" union "+SQL_6;
        }


        String exeSql = String.format(sql.toString(),unionSql);
        return baseDao.findBySql(CustomerWarningLostPayDTO.class,exeSql,params);
    }

    @Override
    public int countQueryDataLogin(String lastLoginGame,String lastLoginTimeFrom,String lastLoginTimeTo,
                              Integer vipGradeFrom, Integer vipGradeTo, String customerService,
                              Integer loginPay) {
        List<Object> params = new ArrayList<Object>();
        StringBuilder sql = new StringBuilder();
        sql.append( "SELECT count(*) as cnt FROM (%s) c " +
                "WHERE 1=1 ");
        if(StringUtils.isNotEmpty(lastLoginGame)){
            sql.append(" AND c.loginGameId=? ");
            params.add(lastLoginGame);
        }
        if(StringUtils.isNotEmpty(lastLoginTimeFrom)){
            sql.append(" AND c.lastLoginTime>=? ");
            params.add(lastLoginTimeFrom);
        }
        if(StringUtils.isNotEmpty(lastLoginTimeTo)){
            sql.append(" AND c.lastLoginTime<=? ");
            params.add(lastLoginTimeTo);
        }
        if(vipGradeFrom!=null&&vipGradeFrom!=0){
            sql.append(" AND c.vipGrade>=? ");
            params.add(vipGradeFrom);
        }
        if(vipGradeTo!=null&&vipGradeTo!=0){
            sql.append(" AND c.vipGrade<=? ");
            params.add(vipGradeTo);
        }
        if(StringUtils.isNotEmpty(customerService)){
            sql.append(" AND c.customerService=? ");
            params.add(customerService);
        }

        String unionSql = "";
        switch (loginPay){
            case 1:
                unionSql = SQL_1;
                break;
            case 2:
                unionSql = SQL_2;
                break;
            case 3:
                unionSql = SQL_3;
                break;
            case 4:
                unionSql = SQL_4;
                break;
            case 5:
                unionSql = SQL_5;
                break;
            case 6:
                unionSql = SQL_6;
                break;
            default:
                unionSql = SQL_1+" union "+SQL_2+" union "+SQL_3+" union "+SQL_4+" union "+SQL_5+" union "+SQL_6;
        }
        String exeSql = String.format(sql.toString(),unionSql);
        Map<String, Object> map = baseDao.findForMap(exeSql,params);
        if(map==null || map.get("cnt")==null)return 0;
        Number number = (Number)map.get("cnt");
        return (number != null ? number.intValue() : 0);

    }

    @Override
    public List<CustomerWarningLostLoginDTO> queryDataLogin(String lastLoginGame,String lastLoginTimeFrom,String lastLoginTimeTo,
                                                     Integer vipGradeFrom, Integer vipGradeTo, String customerService,
                                                     Integer loginPay,Page page) {

        List<Object> params = new ArrayList<Object>();
        StringBuilder sql = new StringBuilder();
        sql.append( "SELECT c.*,i.lostLogin,i.firstTreatLogin,i.firstTreatResultLogin,i.secondTreatLogin,i.secondTreatResultLogin FROM (%s) c left join customerinfo i on c.uid=i.uid " +
                " WHERE 1=1 ");
        if(StringUtils.isNotEmpty(lastLoginGame)){
            sql.append(" AND c.loginGameId=? ");
            params.add(lastLoginGame);
        }
        if(StringUtils.isNotEmpty(lastLoginTimeFrom)){
            sql.append(" AND c.lastLoginTime>=? ");
            params.add(lastLoginTimeFrom);
        }
        if(StringUtils.isNotEmpty(lastLoginTimeTo)){
            sql.append(" AND c.lastLoginTime<=? ");
            params.add(lastLoginTimeTo);
        }
        if(vipGradeFrom!=null&&vipGradeFrom!=0){
            sql.append(" AND c.vipGrade>=? ");
            params.add(vipGradeFrom);
        }
        if(vipGradeTo!=null&&vipGradeTo!=0){
            sql.append(" AND c.vipGrade<=? ");
            params.add(vipGradeTo);
        }
        if(StringUtils.isNotEmpty(customerService)){
            sql.append(" AND c.customerService=? ");
            params.add(customerService);
        }
        int pageNo = page.getPageNo();
        int pageSize = page.getPageSize();
        sql.append(" LIMIT "+(pageNo-1)*pageSize+", "+pageSize);

        String unionSql = "";
        switch (loginPay){
            case 1:
                unionSql = SQL_1;
                break;
            case 2:
                unionSql = SQL_2;
                break;
            case 3:
                unionSql = SQL_3;
                break;
            case 4:
                unionSql = SQL_4;
                break;
            case 5:
                unionSql = SQL_5;
                break;
            case 6:
                unionSql = SQL_6;
                break;
            default:
                unionSql = SQL_1+" union "+SQL_2+" union "+SQL_3+" union "+SQL_4+" union "+SQL_5+" union "+SQL_6;
        }


        String exeSql = String.format(sql.toString(),unionSql);
        return baseDao.findBySql(CustomerWarningLostLoginDTO.class,exeSql,params);
    }
}
