package com.xunlei.niux.data.vipgame.bo.moyu;

import com.ferret.common.dao.BaseDao;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.vipgame.vo.moyu.MoyuJiFen;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

/**
 * @author hezhong
 */
public class MoyuJiFenBoImpl implements MoyuJiFenBo {

    public static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    private BaseDao baseDao;

    public BaseDao getBaseDao() {
        return baseDao;
    }

    public void setBaseDao(BaseDao baseDao) {
        this.baseDao = baseDao;
    }

    @Override
    public void execute(String sql, List<Object> list) {
        baseDao.execute(sql, list);
    }


    @Override
    public List<MoyuJiFen> find(MoyuJiFen moyuJiFen) {
        return baseDao.findByObject(MoyuJiFen.class, moyuJiFen, new Page());
    }

    @Override
    public void insert(MoyuJiFen moyuJiFen) {
        baseDao.insert(moyuJiFen);
    }

    @Override
    public void update(MoyuJiFen moyuJiFen) {
        baseDao.updateById(moyuJiFen);
    }

    @Override
    public MoyuJiFen addJiFen(String actno, String userid, String serverid, Integer jifenNum, String userAccount) {
        MoyuJiFen result  = null;

        MoyuJiFen jiFen  = new MoyuJiFen();
        jiFen.setActno(actno);
        jiFen.setUserid(userid);
        jiFen.setServerid(serverid);

        List<MoyuJiFen> list = find(jiFen);
        String now = DATE_FORMAT.format(new Date());
        if(list.size() == 0) {
            //创建
            jiFen.setJifennum(jifenNum);
            jiFen.setRechargeMoney(jifenNum.longValue());
            jiFen.setInputtime(now);
            jiFen.setUsername(userAccount);

            insert(jiFen);

            list = find(jiFen);
            result = list.get(0);
        } else {
            jiFen = list.get(0);

            //更新
            if(jifenNum !=null && jifenNum > 0) {
                jiFen.setJifennum(jiFen.getJifennum() + jifenNum);
                jiFen.setRechargeMoney(jiFen.getRechargeMoney() + jifenNum.longValue());
                jiFen.setEdittime(now);

                update(jiFen);

            }

            result = jiFen;
        }

        return result;
    }
}
