package com.xunlei.niux.data.vipgame.bo.vic;


import com.ferret.common.dao.BaseDao;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.vipgame.dto.vic.CustomerWarningLostLoginDTO;
import com.xunlei.niux.data.vipgame.dto.vic.CustomerWarningLostPayDTO;
import org.apache.commons.lang.StringUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CustomerBoImpl implements CustomerBo{

    private BaseDao baseDao;

    public BaseDao getBaseDao() {
        return baseDao;
    }

    public void setBaseDao(BaseDao baseDao) {
        this.baseDao = baseDao;
    }

    private final static String SQL_1 = "SELECT c.uid,c.vipGrade,c.lastLoginTime,c.lastPayTime,c.lastModifyAmt,c.payGameId,c.lastCaller,c.lastCallTime,c.customerService,\n" +
            "i.lostPay,i.firstTreat,i.firstTreatResult,i.secondTreat,i.secondTreatResult, 1 AS loginPayType\n" +
            " FROM customerdetailquery c\n" +
            "LEFT JOIN customerinfo i ON c.uid=i.uid\n" +
            " WHERE c.lastLoginTime>=(CURDATE() - INTERVAL 1 DAY) AND c.lastPayTime>=(CURDATE() - INTERVAL 1 DAY)";

    private final static String SQL_2 ="SELECT c.uid,c.vipGrade,c.lastLoginTime,c.lastPayTime,c.lastModifyAmt,c.payGameId,c.lastCaller,c.lastCallTime,c.customerService,\n" +
            "i.lostPay,i.firstTreat,i.firstTreatResult,i.secondTreat,i.secondTreatResult, 2 AS loginPayType\n" +
            " FROM customerdetailquery c\n" +
            "LEFT JOIN customerinfo i ON c.uid=i.uid\n" +
            " WHERE c.lastPayTime=(CURDATE() - INTERVAL 2 DAY)";

    private final static String SQL_3 ="  SELECT c.uid,c.vipGrade,c.lastLoginTime,c.lastPayTime,c.lastModifyAmt,c.payGameId,c.lastCaller,c.lastCallTime,c.customerService,\n" +
            "i.lostPay,i.firstTreat,i.firstTreatResult,i.secondTreat,i.secondTreatResult, 3 AS loginPayType\n" +
            " FROM customerdetailquery c\n" +
            "LEFT JOIN customerinfo i ON c.uid=i.uid\n" +
            " WHERE (c.lastLoginTime>=(CURDATE() - INTERVAL 3 DAY) \n" +
            " and (c.lastPayTime>=(CURDATE() - INTERVAL 6 DAY) AND c.lastPayTime<=(CURDATE() - INTERVAL 3 DAY)) ";

    private final static String SQL_4 ="SELECT c.uid,c.vipGrade,c.lastLoginTime,c.lastPayTime,c.lastModifyAmt,c.payGameId,c.lastCaller,c.lastCallTime,c.customerService,\n" +
            "i.lostPay,i.firstTreat,i.firstTreatResult,i.secondTreat,i.secondTreatResult, 4 AS loginPayType\n" +
            " FROM customerdetailquery c\n" +
            "LEFT JOIN customerinfo i ON c.uid=i.uid\n" +
            " WHERE (c.lastLoginTime>=(CURDATE() - INTERVAL 6 DAY) and c.lastLoginTime<=(CURDATE() - INTERVAL 4 DAY)) \n" +
            " and (c.lastPayTime>=(CURDATE() - INTERVAL 6 DAY) AND c.lastPayTime<=(CURDATE() - INTERVAL 3 DAY)) ";

    private final static String SQL_5 ="SELECT c.uid,c.vipGrade,c.lastLoginTime,c.lastPayTime,c.lastModifyAmt,c.payGameId,c.lastCaller,c.lastCallTime,c.customerService,\n" +
            "i.lostPay,i.firstTreat,i.firstTreatResult,i.secondTreat,i.secondTreatResult, 5 AS loginPayType\n" +
            " FROM customerdetailquery c\n" +
            "LEFT JOIN customerinfo i ON c.uid=i.uid\n" +
            " WHERE c.lastPayTime>=(CURDATE() - INTERVAL 13 DAY) AND c.lastPayTime<=(CURDATE() - INTERVAL 7 DAY)";

    private final static String SQL_6 ="SELECT c.uid,c.vipGrade,c.lastLoginTime,c.lastPayTime,c.lastModifyAmt,c.payGameId,c.lastCaller,c.lastCallTime,c.customerService,\n" +
            "i.lostPay,i.firstTreat,i.firstTreatResult,i.secondTreat,i.secondTreatResult, 6 AS loginPayType\n" +
            " FROM customerdetailquery c\n" +
            "LEFT JOIN customerinfo i ON c.uid=i.uid\n" +
            " WHERE c.lastPayTime<=(CURDATE() - INTERVAL 14 DAY)";



    @Override
    public int countQueryData(String lastPayGame, String lastPayTimeFrom, String lastPayTimeTo,
                              Integer vipGradeFrom, Integer vipGradeTo, String customerService,
                              Integer loginPay) {
        List<Object> params = new ArrayList<Object>();
        StringBuilder sql = new StringBuilder();
        sql.append( "SELECT count(*) as cnt FROM (%s) c" +
                "WHERE 1=1 ");
        if(StringUtils.isNotEmpty(lastPayGame)){
            sql.append(" AND c.payGameId=? ");
            params.add(lastPayGame);
        }
        if(StringUtils.isNotEmpty(lastPayTimeFrom)){
            sql.append(" AND c.lastPayTime>=? ");
            params.add(lastPayTimeFrom);
        }
        if(StringUtils.isNotEmpty(lastPayTimeTo)){
            sql.append(" AND c.lastPayTime<=? ");
            params.add(lastPayTimeTo);
        }
        if(vipGradeFrom!=null&&vipGradeFrom!=0){
            sql.append(" AND c.vipGrade>=? ");
            params.add(vipGradeFrom);
        }
        if(vipGradeTo!=null&&vipGradeTo!=0){
            sql.append(" AND c.vipGrade<=? ");
            params.add(vipGradeTo);
        }
        if(StringUtils.isNotEmpty(customerService)){
            sql.append(" AND c.customerService=? ");
            params.add(customerService);
        }

        String unionSql = "";
        if(loginPay!=null&&loginPay!=0){
            switch (loginPay){
                case 1:
                    unionSql = SQL_1;
                    break;
                case 2:
                    unionSql = SQL_2;
                    break;
                case 3:
                    unionSql = SQL_3;
                    break;
                case 4:
                    unionSql = SQL_4;
                    break;
                case 5:
                    unionSql = SQL_5;
                    break;
                case 6:
                    unionSql = SQL_6;
                    break;
                default:
                    unionSql = SQL_1+" union "+SQL_2+" union "+SQL_3+" union "+SQL_4+" union "+SQL_5+" union "+SQL_6;
            }
        }
        String exeSql = String.format(sql.toString(),unionSql);
        Map<String, Object> map = baseDao.findForMap(exeSql,params);
        if(map==null || map.get("cnt")==null)return 0;
        Number number = (Number)map.get("cnt");
        return (number != null ? number.intValue() : 0);
    }

    @Override
    public List<CustomerWarningLostPayDTO> queryData(String lastPayGame, String lastPayTimeFrom, String lastPayTimeTo,
                                                     Integer vipGradeFrom, Integer vipGradeTo, String customerService,
                                                     Integer loginPay,Page page) {
        List<Object> params = new ArrayList<Object>();
        StringBuilder sql = new StringBuilder();
        sql.append( "SELECT * FROM (%s) c" +
                "WHERE 1=1 ");
        if(StringUtils.isNotEmpty(lastPayGame)){
            sql.append(" AND c.payGameId=? ");
            params.add(lastPayGame);
        }
        if(StringUtils.isNotEmpty(lastPayTimeFrom)){
            sql.append(" AND c.lastPayTime>=? ");
            params.add(lastPayTimeFrom);
        }
        if(StringUtils.isNotEmpty(lastPayTimeTo)){
            sql.append(" AND c.lastPayTime<=? ");
            params.add(lastPayTimeTo);
        }
        if(vipGradeFrom!=null&&vipGradeFrom!=0){
            sql.append(" AND c.vipGrade>=? ");
            params.add(vipGradeFrom);
        }
        if(vipGradeTo!=null&&vipGradeTo!=0){
            sql.append(" AND c.vipGrade<=? ");
            params.add(vipGradeTo);
        }
        if(StringUtils.isNotEmpty(customerService)){
            sql.append(" AND c.customerService=? ");
            params.add(customerService);
        }
        int pageNo = page.getPageNo();
        int pageSize = page.getPageSize();
        sql.append(" LIMIT "+(pageNo-1)*pageSize+", "+pageSize);

        String unionSql = "";
        if(loginPay!=null&&loginPay!=0){
            switch (loginPay){
                case 1:
                    unionSql = SQL_1;
                    break;
                case 2:
                    unionSql = SQL_2;
                    break;
                case 3:
                    unionSql = SQL_3;
                    break;
                case 4:
                    unionSql = SQL_4;
                    break;
                case 5:
                    unionSql = SQL_5;
                    break;
                case 6:
                    unionSql = SQL_6;
                    break;
                default:
                    unionSql = SQL_1+" union "+SQL_2+" union "+SQL_3+" union "+SQL_4+" union "+SQL_5+" union "+SQL_6;
            }
        }


        String exeSql = String.format(sql.toString(),unionSql);
        return baseDao.findBySql(CustomerWarningLostPayDTO.class,exeSql,params);
    }

    @Override
    public int countQueryDataLogin(String lastLoginGame,String lastLoginTimeFrom,String lastLoginTimeTo,
                              Integer vipGradeFrom, Integer vipGradeTo, String customerService,
                              Integer loginPay) {
        List<Object> params = new ArrayList<Object>();
        StringBuilder sql = new StringBuilder();
        sql.append( "SELECT count(*) as cnt FROM (SELECT DATEDIFF(NOW(),c.lastLoginTime) AS lostLoginDays,DATEDIFF(NOW(),c.lastPayTime) AS lostPayDays\n" +
                "FROM customerdetailquery c LEFT JOIN customerinfo p ON c.uid=p.uid\n" +
                "WHERE 1=1 ");
        if(StringUtils.isNotEmpty(lastLoginGame)){
            sql.append(" AND c.loginGameId=? ");
            params.add(lastLoginGame);
        }
        if(StringUtils.isNotEmpty(lastLoginTimeFrom)){
            sql.append(" AND c.lastLoginTime>=? ");
            params.add(lastLoginTimeFrom);
        }
        if(StringUtils.isNotEmpty(lastLoginTimeTo)){
            sql.append(" AND c.lastLoginTime<=? ");
            params.add(lastLoginTimeTo);
        }
        if(vipGradeFrom!=null&&vipGradeFrom!=0){
            sql.append(" AND c.vipGrade>=? ");
            params.add(vipGradeFrom);
        }
        if(vipGradeTo!=null&&vipGradeTo!=0){
            sql.append(" AND c.vipGrade<=? ");
            params.add(vipGradeTo);
        }
        if(StringUtils.isNotEmpty(customerService)){
            sql.append(" AND c.customerService=? ");
            params.add(customerService);
        }

        sql.append(" ) a where 1=1");

        if(loginPay!=null&&loginPay!=0){
            switch (loginPay){
                case 1:
                    sql.append(" AND lostLoginDays<=1 AND lostPayDays<=1 ");
                    break;
                case 2:
                    sql.append(" AND ( lostLoginDays=2 OR lostPayDays=2 ) and lostLoginDays<7 and lostPayDays<7 ");
                    break;
                case 3:
                    sql.append(" AND lostLoginDays<=3 AND lostPayDays>3  AND lostLoginDays<=6 AND lostPayDays<=6 ");
                    break;
                case 4:
                    sql.append(" AND lostLoginDays>=3 AND lostPayDays>=3  AND lostLoginDays<=6 AND lostPayDays<=6 ");
                    break;
                case 5:
                    sql.append(" AND ((lostLoginDays>=7 AND lostLoginDays<=13) OR (lostPayDays>=7 AND lostPayDays<=13))  and lostLoginDays<14 and lostPayDays<14");
                    break;
                case 6:
                    sql.append(" AND ( lostLoginDays>=14 OR lostPayDays>=14 ) ");
                    break;
            }
        }
        Map<String, Object> map = baseDao.findForMap(sql.toString(),params);
        if(map==null || map.get("cnt")==null)return 0;
        Number number = (Number)map.get("cnt");
        return (number != null ? number.intValue() : 0);
    }

    @Override
    public List<CustomerWarningLostLoginDTO> queryDataLogin(String lastLoginGame,String lastLoginTimeFrom,String lastLoginTimeTo,
                                                     Integer vipGradeFrom, Integer vipGradeTo, String customerService,
                                                     Integer loginPay,Page page) {
        List<Object> params = new ArrayList<Object>();
        StringBuilder sql = new StringBuilder();
        sql.append( "SELECT * FROM (SELECT c.uid,c.vipGrade,c.lastLoginTime,c.lastPayTime,c.lastModifyAmt,c.payGameId,c.loginGameId,c.lastCaller,c.lastCallTime,c.customerService,\n" +
                "p.lostLogin,p.firstTreatLogin,p.firstTreatResultLogin,p.secondTreatLogin,p.secondTreatResultLogin,\n" +
                "DATEDIFF(NOW(),c.lastLoginTime) AS lostLoginDays,DATEDIFF(NOW(),c.lastPayTime) AS lostPayDays\n" +
                "FROM customerdetailquery c LEFT JOIN customerinfo p ON c.uid=p.uid\n" +
                "WHERE 1=1 ");
        if(StringUtils.isNotEmpty(lastLoginGame)){
            sql.append(" AND c.loginGameId=? ");
            params.add(lastLoginGame);
        }
        if(StringUtils.isNotEmpty(lastLoginTimeFrom)){
            sql.append(" AND c.lastLoginTime>=? ");
            params.add(lastLoginTimeFrom);
        }
        if(StringUtils.isNotEmpty(lastLoginTimeTo)){
            sql.append(" AND c.lastLoginTime<=? ");
            params.add(lastLoginTimeTo);
        }
        if(vipGradeFrom!=null&&vipGradeFrom!=0){
            sql.append(" AND c.vipGrade>=? ");
            params.add(vipGradeFrom);
        }
        if(vipGradeTo!=null&&vipGradeTo!=0){
            sql.append(" AND c.vipGrade<=? ");
            params.add(vipGradeTo);
        }
        if(StringUtils.isNotEmpty(customerService)){
            sql.append(" AND c.customerService=? ");
            params.add(customerService);
        }

        sql.append(" ) a where 1=1");

        if(loginPay!=null&&loginPay!=0){
            switch (loginPay){
                case 1:
                    sql.append(" AND lostLoginDays<=1 AND lostPayDays<=1 ");
                    break;
                case 2:
                    sql.append(" AND ( lostLoginDays=2 OR lostPayDays=2 ) and lostLoginDays<7 and lostPayDays<7 ");
                    break;
                case 3:
                    sql.append(" AND lostLoginDays<=3 AND lostPayDays>3  AND lostLoginDays<=6 AND lostPayDays<=6 ");
                    break;
                case 4:
                    sql.append(" AND lostLoginDays>=3 AND lostPayDays>=3  AND lostLoginDays<=6 AND lostPayDays<=6 ");
                    break;
                case 5:
                    sql.append(" AND ((lostLoginDays>=7 AND lostLoginDays<=13) OR (lostPayDays>=7 AND lostPayDays<=13))  and lostLoginDays<14 and lostPayDays<14");
                    break;
                case 6:
                    sql.append(" AND ( lostLoginDays>=14 OR lostPayDays>=14 ) ");
                    break;
            }
        }
        int pageNo = page.getPageNo();
        int pageSize = page.getPageSize();
        sql.append(" LIMIT "+(pageNo-1)*pageSize+", "+pageSize);

        return baseDao.findBySql(CustomerWarningLostLoginDTO.class,sql.toString(),params);
    }
}
