package com.xunlei.niux.data.vipgame.bo;

import java.util.List;
import com.ferret.common.dao.BaseDao;
import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.vipgame.vo.Advice;
import com.xunlei.niux.data.vipgame.vo.WhiteList;

public class WhiteListBoImpl implements WhiteListBo {
	private BaseDao baseDao;
	public BaseDao getBaseDao() {
		return baseDao;
	}
	public void setBaseDao(BaseDao baseDao) {
		this.baseDao = baseDao;
	}
	/**
	 * 查询白名单
	 * @param content
	 * @param start
	 * @param limit
	 * @return
	 */
	public List<WhiteList> find(WhiteList wl,int pageNo,int pageSize){
		Page page=new Page();
		page.setPageNo(pageNo);
		page.setPageSize(pageSize);
		page.addOrder("displayOrder", OrderType.ESC);
		page.addOrder("inputTime", OrderType.DESC);
		return baseDao.findByObject(WhiteList.class, wl, page);
	}
	public List<WhiteList> findWhiteList(WhiteList wl,Page page){
		return baseDao.findByObject(WhiteList.class, wl, page);
	}
	public WhiteList findWhiteListById(long seqId){
		return baseDao.findById(WhiteList.class, seqId);
	}
	public int count(WhiteList wl){
		return baseDao.count(wl);
	}
	public void update(WhiteList wl){
		 baseDao.updateById(wl);
	}
	public void insert(WhiteList wl) {
		baseDao.insert(wl);
	}
	public void delete(Long seqId) {
		baseDao.deleteById(WhiteList.class, seqId);
	}
	
	public void execute(String sql, List<Object> list) {
		baseDao.execute(sql, list);
		
	}

	public List executeQuery(Class class1, String sql, List list) {       
		return baseDao.executeQuery(class1, sql, list);
	}
}
