package com.xunlei.niux.data.vipgame.bo;


import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import com.ferret.common.dao.BaseDao;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.vipgame.vo.BigCustomerDetail;


public class BigCustomerDetailBoImpl extends ChargeAmountProfileSettingsBoImpl implements BigCustomerDetailBo{
	private static final Logger logger = Logger.getLogger(BigCustomerDetailBoImpl.class.getName());
	private BaseDao baseDao;	
	private BigCustomerQueryBo bigCustomerQueryBo;
	
	@Override
	public int count(BigCustomerDetail detail) {
		return baseDao.count(detail);
	}

	@Override
	public List<BigCustomerDetail> find(BigCustomerDetail detail,
			Page page) {
		return baseDao.findByObject(BigCustomerDetail.class, detail, page);
	}

	public BaseDao getBaseDao() {
		return baseDao;
	}

	public void setBaseDao(BaseDao baseDao) {
		this.baseDao = baseDao;
	}


	public void update(BigCustomerDetail detail){
		baseDao.updateById(detail);
	}
	/**
	 * 清空以前的记录
	 * @param time
	 */
	public void delete(String time ){
		logger.info("手动执行定时任务，开始清空："+time+"日，的相关记录......");
		String sql = "delete from bigcustomerdetail where daytime=? ";
		int count = queryForInt("select count(*) from bigcustomerdetail where daytime=? ", new Object[]{time});
		if(count >0 ){
            List list = new ArrayList();
            list.add(time);
			execute(sql, list);
		}
		logger.info("记录清空完毕!");
	}
	
	public void execute(String presql, final List paramList){
		baseDao.execute(presql, paramList);
	}

	@Override
	public void insert(BigCustomerDetail detail) {
		baseDao.insert(detail);
	}
	
	/**
	 * 根据迅雷UID查询外呼记录
	 * @param uid
	 * @return
	 */
	public int getCallRecordCount(String uid,String nowtime){
		String sql = "select count(1) from callrecord where uid=? ";
		return queryForInt(sql, new Object[]{uid});
	}

	public BigCustomerQueryBo getBigCustomerQueryBo() {
		return bigCustomerQueryBo;
	}

	public void setBigCustomerQueryBo(BigCustomerQueryBo bigCustomerQueryBo) {
		this.bigCustomerQueryBo = bigCustomerQueryBo;
	}
	
	public List findBySql(Class clazz, String preSql, List paramList){
		 return baseDao.findBySql(clazz, preSql, paramList);
	}
	
	public boolean isNew(String uid,String beforeTime,String [] object){
		String sql = "select count(1) from bigcustomerdetail where uid=? and daytime=?";
        Object[] args = new Object[]{uid,beforeTime};
		int count = queryForInt(sql, args);
		return count<=0?true:false;
	}
}
