/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.data.vipgame.bo.vic;

import com.ferret.common.dao.BaseDao;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.vipgame.bo.vic.CustomerBo;
import com.xunlei.niux.data.vipgame.dto.vic.CustomerWarningLostPayDTO;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class CustomerBoImpl
implements CustomerBo {
    private BaseDao baseDao;

    public BaseDao getBaseDao() {
        return this.baseDao;
    }

    public void setBaseDao(BaseDao baseDao) {
        this.baseDao = baseDao;
    }

    @Override
    public int countQueryData(String lastPayGame, String lastPayTimeFrom, String lastPayTimeTo, Integer vipGradeFrom, Integer vipGradeTo, String customerService, Integer lostLoginDays, Integer lostPayDays) {
        Map map;
        ArrayList<Object> params = new ArrayList<Object>();
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT count(*) as cnt FROM customerdetailquery c WHERE 1=1 ");
        if (StringUtils.isNotEmpty((String)lastPayGame)) {
            sql.append(" AND c.lastPayGame=? ");
            params.add(lastPayGame);
        }
        if (StringUtils.isNotEmpty((String)lastPayTimeFrom)) {
            sql.append(" AND c.lastPayTime>=? ");
            params.add(lastPayTimeFrom);
        }
        if (StringUtils.isNotEmpty((String)lastPayTimeTo)) {
            sql.append(" AND c.lastPayTime<=? ");
            params.add(lastPayTimeTo);
        }
        if (vipGradeFrom != null && vipGradeFrom != 0) {
            sql.append(" AND c.vipGrade>=? ");
            params.add(vipGradeFrom);
        }
        if (vipGradeTo != null && vipGradeTo != 0) {
            sql.append(" AND c.vipGrade<=? ");
            params.add(vipGradeTo);
        }
        if (StringUtils.isNotEmpty((String)customerService)) {
            sql.append(" AND c.customerService=? ");
            params.add(customerService);
        }
        if (lostLoginDays != null && lostLoginDays != 0) {
            sql.append(" AND DATEDIFF(NOW(),c.lastLoginTime)<=? ");
            params.add(lostLoginDays);
        }
        if (lostPayDays != null && lostPayDays != 0) {
            sql.append(" AND DATEDIFF(NOW(),c.lastPayTime)<=? ");
            params.add(lostPayDays);
        }
        if ((map = this.baseDao.findForMap(sql.toString(), params)) == null || map.get("cnt") == null) {
            return 0;
        }
        Number number = (Number)map.get("cnt");
        return number != null ? number.intValue() : 0;
    }

    @Override
    public List<CustomerWarningLostPayDTO> queryData(String lastPayGame, String lastPayTimeFrom, String lastPayTimeTo, Integer vipGradeFrom, Integer vipGradeTo, String customerService, Integer lostLoginDays, Integer lostPayDays, Page page) {
        ArrayList<Object> params = new ArrayList<Object>();
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT c.uid,c.vipGrade,c.lastLoginTime,c.lastPayTime,c.lastModifyAmt,c.payGameId,c.lastCaller,c.lastCallTime,c.customerService,\np.lostPay,p.firstTreat,p.firstTreatResult,p.secondTreat,p.secondTreatResult,\nDATEDIFF(NOW(),c.lastLoginTime) AS lostLoginDays,DATEDIFF(NOW(),c.lastPayTime) AS lostPayDays\nFROM customerdetailquery c LEFT JOIN vic_person_info p ON c.uid=p.uid\nWHERE 1=1 ");
        if (StringUtils.isNotEmpty((String)lastPayGame)) {
            sql.append(" AND c.lastPayGame=? ");
            params.add(lastPayGame);
        }
        if (StringUtils.isNotEmpty((String)lastPayTimeFrom)) {
            sql.append(" AND c.lastPayTime>=? ");
            params.add(lastPayTimeFrom);
        }
        if (StringUtils.isNotEmpty((String)lastPayTimeTo)) {
            sql.append(" AND c.lastPayTime<=? ");
            params.add(lastPayTimeTo);
        }
        if (vipGradeFrom != null && vipGradeFrom != 0) {
            sql.append(" AND c.vipGrade>=? ");
            params.add(vipGradeFrom);
        }
        if (vipGradeTo != null && vipGradeTo != 0) {
            sql.append(" AND c.vipGrade<=? ");
            params.add(vipGradeTo);
        }
        if (StringUtils.isNotEmpty((String)customerService)) {
            sql.append(" AND c.customerService=? ");
            params.add(customerService);
        }
        if (lostLoginDays != null && lostLoginDays != 0) {
            sql.append(" AND DATEDIFF(NOW(),c.lastLoginTime)<=? ");
            params.add(lostLoginDays);
        }
        if (lostPayDays != null && lostPayDays != 0) {
            sql.append(" AND DATEDIFF(NOW(),c.lastPayTime)<=? ");
            params.add(lostPayDays);
        }
        int pageNo = page.getPageNo();
        int pageSize = page.getPageSize();
        sql.append(" LIMIT " + (pageNo - 1) * pageSize + ", " + pageSize);
        return this.baseDao.findBySql(CustomerWarningLostPayDTO.class, sql.toString(), params);
    }
}

