package com.xunlei.niux.data.vipgame.bo.vic;


import com.ferret.common.dao.BaseDao;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.vipgame.dto.vic.CustomerWarningLostPayDTO;
import org.apache.commons.lang.StringUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CustomerBoImpl implements CustomerBo{

    private BaseDao baseDao;

    public BaseDao getBaseDao() {
        return baseDao;
    }

    public void setBaseDao(BaseDao baseDao) {
        this.baseDao = baseDao;
    }

    @Override
    public int countQueryData(String lastPayGame, String lastPayTimeFrom, String lastPayTimeTo,
                              Integer vipGradeFrom, Integer vipGradeTo, String customerService,
                              Integer lostLoginDays, Integer lostPayDays) {
        List<Object> params = new ArrayList<Object>();
        StringBuilder sql = new StringBuilder();
        sql.append( "SELECT count(*) FROM customerdetailquery c WHERE 1=1 ");
        if(StringUtils.isNotEmpty(lastPayGame)){
            sql.append(" AND c.lastPayGame=? ");
            params.add(lastPayGame);
        }
        if(StringUtils.isNotEmpty(lastPayTimeFrom)){
            sql.append(" AND c.lastPayTime>=? ");
            params.add(lastPayTimeFrom);
        }
        if(StringUtils.isNotEmpty(lastPayTimeTo)){
            sql.append(" AND c.lastPayTime<=? ");
            params.add(lastPayTimeTo);
        }
        if(vipGradeFrom!=null&&vipGradeFrom!=0){
            sql.append(" AND c.vipGrade>=? ");
            params.add(vipGradeFrom);
        }
        if(vipGradeTo!=null&&vipGradeTo!=0){
            sql.append(" AND c.vipGrade<=? ");
            params.add(vipGradeTo);
        }
        if(StringUtils.isNotEmpty(customerService)){
            sql.append(" AND c.customerService=? ");
            params.add(customerService);
        }
        if(lostLoginDays!=null&&lostLoginDays!=0){
            sql.append(" AND DATEDIFF(NOW(),c.lastLoginTime)<=? ");
            params.add(lostLoginDays);
        }
        if(lostPayDays!=null&&lostPayDays!=0){
            sql.append(" AND DATEDIFF(NOW(),c.lastPayTime)<=? ");
            params.add(lostPayDays);
        }

        Map<String, Object> map = baseDao.findForMap(sql.toString(),params);
        if(map==null || map.get("count")==null)return 0;
        Number number = (Number)map.get("count");
        return (number != null ? number.intValue() : 0);
    }

    @Override
    public List<CustomerWarningLostPayDTO> queryData(String lastPayGame, String lastPayTimeFrom, String lastPayTimeTo,
                                                     Integer vipGradeFrom, Integer vipGradeTo, String customerService,
                                                     Integer lostLoginDays, Integer lostPayDays,Page page) {
        List<Object> params = new ArrayList<Object>();
        StringBuilder sql = new StringBuilder();
        sql.append( "SELECT c.uid,c.vipGrade,c.lastLoginTime,c.lastPayTime,c.lastModifyAmt,c.payGameId,c.lastCaller,c.lastCallTime,c.customerService,\n" +
                "p.lostPay,p.firstTreat,p.firstTreatResult,p.secondTreat,p.secondTreatResult,\n" +
                "DATEDIFF(NOW(),c.lastLoginTime) AS lostLoginDays,DATEDIFF(NOW(),c.lastPayTime) AS lostPayDays\n" +
                "FROM customerdetailquery c LEFT JOIN vic_person_info p ON c.uid=p.uid\n" +
                "WHERE 1=1 ");
        if(StringUtils.isNotEmpty(lastPayGame)){
            sql.append(" AND c.lastPayGame=? ");
            params.add(lastPayGame);
        }
        if(StringUtils.isNotEmpty(lastPayTimeFrom)){
            sql.append(" AND c.lastPayTime>=? ");
            params.add(lastPayTimeFrom);
        }
        if(StringUtils.isNotEmpty(lastPayTimeTo)){
            sql.append(" AND c.lastPayTime<=? ");
            params.add(lastPayTimeTo);
        }
        if(vipGradeFrom!=null&&vipGradeFrom!=0){
            sql.append(" AND c.vipGrade>=? ");
            params.add(vipGradeFrom);
        }
        if(vipGradeTo!=null&&vipGradeTo!=0){
            sql.append(" AND c.vipGrade<=? ");
            params.add(vipGradeTo);
        }
        if(StringUtils.isNotEmpty(customerService)){
            sql.append(" AND c.customerService=? ");
            params.add(customerService);
        }
        if(lostLoginDays!=null&&lostLoginDays!=0){
            sql.append(" AND DATEDIFF(NOW(),c.lastLoginTime)<=? ");
            params.add(lostLoginDays);
        }
        if(lostPayDays!=null&&lostPayDays!=0){
            sql.append(" AND DATEDIFF(NOW(),c.lastPayTime)<=? ");
            params.add(lostPayDays);
        }
        int pageNo = page.getPageNo();
        int pageSize = page.getPageSize();
        sql.append(" LIMIT "+(pageNo-1)*pageSize+", "+pageSize);

        return baseDao.findBySql(CustomerWarningLostPayDTO.class,sql.toString(),params);
    }
}
