package com.xunlei.niux.data.vipgame.bo.businesss;

import com.ferret.common.dao.BaseDao;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.vipgame.vo.business.CorporationInfo;

import java.util.List;

/**
 * @author hezhong
 */
public class CorporationInfoBoImpl implements CorporationInfoBo {
    private BaseDao baseDao;

    public BaseDao getBaseDao() {
        return baseDao;
    }

    public void setBaseDao(BaseDao baseDao) {
        this.baseDao = baseDao;
    }

    @Override
    public List<CorporationInfo> find(CorporationInfo corporationInfo, int pageNo, int pageSize) {
        Page page = new Page();
        page.setPageNo(pageNo);
        page.setPageSize(pageSize);

        return baseDao.findByObject(CorporationInfo.class, corporationInfo, page);
    }

    @Override
    public int count(CorporationInfo corporationInfo) {
        return baseDao.count(corporationInfo);
    }

    @Override
    public CorporationInfo findById(String productno) {
        return baseDao.findById(CorporationInfo.class, productno);
    }

    @Override
    public void insert(CorporationInfo corporationInfo) {
        baseDao.insert(corporationInfo);
    }

    @Override
    public void update(CorporationInfo corporationInfo) {
        baseDao.updateById(corporationInfo);
    }
}
