package com.xunlei.niux.data.vipgame.bo.bonus;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

import javax.annotation.Resource;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ferret.common.dao.BaseDao;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.common.exception.NiuRuntimeException;
import com.xunlei.niux.data.vipgame.bo.BonusProductBo;
import com.xunlei.niux.data.vipgame.bt.bonus.BonusProductBT;
import com.xunlei.niux.data.vipgame.vo.BonusProduct;
import com.xunlei.niux.data.vipgame.vo.bonus.BonusExchange;
import com.xunlei.niux.data.vipgame.vo.bonus.BonusProductCharge;
import com.xunlei.niux.data.vipgame.vo.bonus.BonusProductChargeRecord;
import com.xunlei.niux.easyutils.commonutils.OrderNoUtil;

@Service
public class BonusExchangeBoImpl implements BonusExchangeBo {
	private static SimpleDateFormat sdfShort=new SimpleDateFormat("yyyy-MM-dd");
	private static SimpleDateFormat sdf=new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
	@Resource(name="BaseDao")
	private BaseDao baseDao;
	@Autowired
	private BonusProductBo bonusProductBo;
	@Autowired
	private BonusProductGiveOutDayStatisticsBo bonusProductGiveOutDayStatisticsBo;
	public BaseDao getBaseDao() {
		return baseDao;
	}
	public void setBaseDao(BaseDao baseDao) {
		this.baseDao = baseDao;
	}
	public BonusProductBo getBonusProductBo() {
		return bonusProductBo;
	}
	public void setBonusProductBo(BonusProductBo bonusProductBo) {
		this.bonusProductBo = bonusProductBo;
	}
	public BonusProductGiveOutDayStatisticsBo getBonusProductGiveOutDayStatisticsBo() {
		return bonusProductGiveOutDayStatisticsBo;
	}
	public void setBonusProductGiveOutDayStatisticsBo(
			BonusProductGiveOutDayStatisticsBo bonusProductGiveOutDayStatisticsBo) {
		this.bonusProductGiveOutDayStatisticsBo = bonusProductGiveOutDayStatisticsBo;
	}
	
	/**
	 * 插入兑换交易记录，并返回最近的交易。
	 * @param exchange
	 * @return
	 */
	public BonusExchange insert(final BonusExchange exchange){
		Date now=new Date();
		//判断产品是否够兑换,并锁定。如果不能兑换时抛出异常
		BonusProduct bonusProduct=bonusProductBo.update_consume(exchange.getProductNo());
		//判断用户是否已经兑换该产品。如果已兑换就返回已经兑换的交易数据
		checkUserCanExchange(exchange.getUserId(),now,bonusProduct);
		//判断是否达到每日兑换总上线,如果不够兑换时，抛出异常
		BonusProductBT.checkProductDayEnough(bonusProduct.getProductNo(), sdfShort.format(now), bonusProduct.getEverydayMaxNum());
		//增加到每日统计中
		bonusProductGiveOutDayStatisticsBo.update_addOne(bonusProduct.getProductNo(), sdfShort.format(now));
		//插入本次交易
		BonusExchange bonusExchange=new BonusExchange();
		bonusExchange.setBalanceDate(sdfShort.format(now));
		bonusExchange.setBonusNum(exchange.getBonusNum());
		bonusExchange.setExchangeDirect(exchange.getExchangeDirect());//交易方向
		bonusExchange.setExchangeStatus("0");//扣除积分中
		bonusExchange.setExchangeTime(sdf.format(now));
		bonusExchange.setGameId(bonusProduct.getGameId());
		bonusExchange.setProductLot(bonusProduct.getProductLot());
		bonusExchange.setProductName(bonusProduct.getProductName());
		bonusExchange.setProductNo(bonusProduct.getProductNo());
		bonusExchange.setProductType(bonusProduct.getProductType());
		bonusExchange.setProductUnit(bonusProduct.getProductUnit());
		bonusExchange.setProductNum(exchange.getProductNum());
		bonusExchange.setRemark(exchange.getRemark());
		bonusExchange.setSerialNumber("");
		bonusExchange.setServerId(exchange.getServerId());
		bonusExchange.setUserId(exchange.getUserId());
		bonusExchange.setUserName(exchange.getUserName());
		bonusExchange.setExchangeNo(OrderNoUtil.getOrderNo());
		bonusExchange.setExchangeStatusUpdateTime(sdf.format(now));
		bonusExchange.setFailCause("");
		bonusExchange.setExchangePlatform(exchange.getExchangePlatform());
		bonusExchange.setExchangeIp(exchange.getExchangeIp());
		bonusExchange.setRoleId(exchange.getRoleId());
		baseDao.insert(bonusExchange);
		return findOne(bonusExchange.getExchangeNo());
	}
	/**
	 * 更新扣除产品的结果
	 * @param exchange
	 * @param isSuccess 是否扣除成功
	 * @return 更新的数据
	 */
	public BonusExchange updateKouChuProductResult(BonusExchange exchange,boolean isSuccess){
		BonusExchange bonusExchange=baseDao.findById(BonusExchange.class, exchange.getSeqId());
		if(!"0".equals(bonusExchange.getExchangeStatus())){
			throw new NiuRuntimeException("99","兑换订单["+bonusExchange.getExchangeNo()+"]不存于积分扣除阶段");
		}
		if(!isSuccess){
			//发放失败，退还产品
			bonusProductBo.update_rechargefailconsum(bonusExchange.getProductNo());//返还扣除的产品
			//较少统计中的统计数据
			bonusProductGiveOutDayStatisticsBo.update_removeOne(bonusExchange.getProductNo(), bonusExchange.getBalanceDate());
		}
		Date now = new Date();
		bonusExchange.setRemark(exchange.getRemark());
		bonusExchange.setFailCause(exchange.getFailCause());
		bonusExchange.setExchangeStatusUpdateTime(sdf.format(now));
		//如果积分扣除成功，更新状态到下一个
		String nextExchangeStatus=isSuccess?"1":"3";
		bonusExchange.setExchangeStatus(nextExchangeStatus);
		baseDao.updateById(bonusExchange);
		return bonusExchange;
	}
	/**
	 * 更新兑换产品的结果
	 * @param exchange
	 * @param isSuccess
	 * @return
	 */
	public BonusExchange updateExchangeProductResult(BonusExchange exchange,boolean isSuccess){
		BonusExchange bonusExchange=baseDao.findById(BonusExchange.class, exchange.getSeqId());
		if(!"1".equals(bonusExchange.getExchangeStatus())){
			throw new NiuRuntimeException("99","兑换订单["+bonusExchange.getExchangeNo()+"]不存于发放兑换品阶段");
		}
		if(isSuccess==false&&"11".equals(bonusExchange.getExchangeDirect())){
			//产品兑换积分，积分兑换失败时，重新再兑
			return bonusExchange;
		}
		if(!isSuccess){
			//发放失败，退还产品
			bonusProductBo.update_rechargefailconsum(bonusExchange.getProductNo());//返还扣除的产品
			//较少统计中的统计数据
			bonusProductGiveOutDayStatisticsBo.update_removeOne(bonusExchange.getProductNo(), bonusExchange.getBalanceDate());
		}
		Date now = new Date();
		bonusExchange.setRemark(exchange.getRemark());
		bonusExchange.setFailCause(exchange.getFailCause());
		bonusExchange.setExchangeStatusUpdateTime(sdf.format(now));
		bonusExchange.setSerialNumber(exchange.getSerialNumber());
		//如果积分扣除成功，更新状态到下一个
		String nextExchangeStatus=isSuccess?"2":"4";
		bonusExchange.setExchangeStatus(nextExchangeStatus);
		baseDao.updateById(bonusExchange);
		return bonusExchange;
	}
	public BonusExchange updateReturnProductResult(BonusExchange exchange,boolean isSuccess){
		BonusExchange bonusExchange=baseDao.findById(BonusExchange.class, exchange.getSeqId());
		if(isSuccess==false){
			return bonusExchange;
		}
		if(!"4".equals(bonusExchange.getExchangeStatus())){
			throw new NiuRuntimeException("99","兑换订单["+bonusExchange.getExchangeNo()+"]不存于退还产品阶段");
		}
		bonusExchange.setExchangeStatus("3");
		baseDao.updateById(bonusExchange);
		return bonusExchange;
	}
	/**
	 * 判断用户是否还能兑换，如果不能抛出异常
	 * @param userId
	 * @param bonusProduct
	 */
	public void checkUserCanExchange(String userId,Date date,final BonusProduct bonusProduct){
		//判断用户是否达到每日最大兑换数目。如果达到最大兑换数目，抛出异常
		checkUserTodayCanExchange(userId,date,bonusProduct);
		//超过周期
		checkUserExceedRestrictCanExchange(userId,date,bonusProduct);
	}
	private void checkUserTodayCanExchange(String userId,Date date,final BonusProduct bonusProduct){
		if(bonusProduct.getUserEverydayMaxNum()==null||bonusProduct.getUserEverydayMaxNum()<=0){
			return;
		}
		//获取今天兑换数目,包括0:扣积分中；1：发放产品；2：已成功的交易记录
		BonusExchange query=new BonusExchange();
		query.setUserId(userId);
		query.setProductNo(bonusProduct.getProductNo());
		query.setToExchangeStatus("3");//0:扣积分中；1：发放产品；2：已成功的交易记录
		query.setBalanceDate(sdfShort.format(date));
		int  count=baseDao.count(query);
		//判断是否达到了今天的最大限制。如果没有达到直接返回空，否则查询出最后提交的兑换记录
		if(count<bonusProduct.getUserEverydayMaxNum()){
			return;
		}
		throw new NiuRuntimeException("1040","达到单个用户领取最大限额");
	}
	private void checkUserExceedRestrictCanExchange(String userId,Date date,final BonusProduct bonusProduct){
		//判断约束周期是否有最大交易数量限制。如果没有，直接返回null。
		if(bonusProduct.getUserRestrictMaxNum()==null||bonusProduct.getUserRestrictMaxNum()<=0){
			return;
		}
		//计算约束天数
		Date restrictDate=null;
		if(bonusProduct.getRestrictDays()!=null&&bonusProduct.getRestrictDays()>0){
			restrictDate=new Date(date.getTime()-24L*60*60*1000*(bonusProduct.getRestrictDays()-1));
		}
		//查询用户约束周期内兑换总数，包括0:扣积分中；1：发放产品；2：已成功的交易记录
		BonusExchange query=new BonusExchange();
		query.setUserId(userId);
		query.setProductNo(bonusProduct.getProductNo());
		query.setToExchangeStatus("3");//0:扣积分中；1：发放产品；2：已成功的交易记录
		if(restrictDate!=null){
			query.setFromBalanceDate(sdfShort.format(restrictDate));
		}
		int  count=baseDao.count(query);
		//判断是否达到了约束周期的最大限制。。如果没有达到直接返回空，否则查询出最后提交的兑换记录
		if(count<bonusProduct.getUserRestrictMaxNum()){
			return;
		}
		throw new NiuRuntimeException("1041","达到单个用户周期（"+bonusProduct.getUserRestrictMaxNum()+"天）领取最大限额");
	}
	public int count(BonusExchange exchange){
		return baseDao.count(exchange);
	}
	public BonusExchange findOne(String orderNo){
		BonusExchange query=new BonusExchange();
		query.setExchangeNo(orderNo);
		Page page=new Page();
		page.setPageNo(1);
		page.setPageSize(1);
		List<BonusExchange> list=baseDao.findByObject(BonusExchange.class, query, page);
		return (list==null||list.size()==0)?null:list.get(0);
	}
	public List<BonusExchange> finds(BonusExchange bonusExchange,Page page){
		return baseDao.findByObject(BonusExchange.class, bonusExchange, page);
	}
	@Override
	public BonusProductChargeRecord insert(BonusProductCharge exchange,long userId,String ip) {
		BonusProductCharge bpc = bonusProductBo.updateProductLeftCount(exchange.getProductId(),true);
		return addProductChargeRecord(bpc,userId,ip);
	}
	
	public void update(BonusProductCharge exchange,boolean flag) {
		 bonusProductBo.updateProductLeftCount(exchange.getProductId(),flag);
	}
	
	private BonusProductChargeRecord addProductChargeRecord(BonusProductCharge bpc,long userId,String ip){
		BonusProductChargeRecord record = new BonusProductChargeRecord();
		record.setBonus(bpc.getBonus());
		record.setChargeFlag(1);
		record.setProductId(bpc.getProductId());
		record.setRecordTime(sdf.format(new Date()));
		record.setUserId(userId);
		record.setIp(ip);
		baseDao.insert(record);
		return record;
	}
}
