/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.data.vipgame.bo.vic;

import com.ferret.common.dao.BaseDao;
import com.xunlei.niux.data.vipgame.bo.vic.RebateReportBo;
import com.xunlei.niux.data.vipgame.dto.vic.RebateReportGameDTO;
import com.xunlei.niux.data.vipgame.dto.vic.RebateReportOldGameDTO;
import com.xunlei.niux.data.vipgame.dto.vic.RebateReportPersonDTO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Service;

@Service
public class RebateReportBoImpl
implements RebateReportBo {
    private BaseDao baseDao;

    public BaseDao getBaseDao() {
        return this.baseDao;
    }

    public void setBaseDao(BaseDao baseDao) {
        this.baseDao = baseDao;
    }

    @Override
    public Map<String, Double> queryRebateReportPersonByDate(String startDate, String endDate) {
        HashMap<String, Double> map = new HashMap<String, Double>();
        String sql = " SELECT SUM(r.money) AS finished, r.inputBy As person, 0 AS kpi, 0.0 AS kpirate  FROM \n(SELECT DISTINCT aporderid FROM rebateorder WHERE orderTime>=? AND orderTime<=?) o \nINNER JOIN rebateapply r ON o.aporderid=r.aporderid \nWHERE (r.checkstatus=-1 OR r.checkstatus=0 OR r.checkstatus=1) GROUP BY r.inputBy ";
        ArrayList<String> params = new ArrayList<String>();
        params.add(startDate);
        params.add(endDate);
        List list = this.baseDao.findBySql(RebateReportPersonDTO.class, sql, params);
        for (RebateReportPersonDTO dto : list) {
            map.put(dto.getPerson(), dto.getFinished());
        }
        return map;
    }

    @Override
    public Map<String, Object> queryRebateReportByDate(String startDate, String endDate) {
        String sql = " SELECT SUM(r.money) AS finished FROM \n(SELECT DISTINCT aporderid FROM rebateorder WHERE orderTime>=? AND orderTime<=?) o \nINNER JOIN rebateapply r ON o.aporderid=r.aporderid \nWHERE (r.checkstatus=-1 OR r.checkstatus=0 OR r.checkstatus=1) ";
        ArrayList<String> params = new ArrayList<String>();
        params.add(startDate);
        params.add(endDate);
        return this.baseDao.findForMap(sql, params);
    }

    @Override
    public Map<String, Double> queryRebateReportGameByDate(String startDate, String endDate) {
        HashMap<String, Double> map = new HashMap<String, Double>();
        String sql = " SELECT SUM(r.money) AS finished, r.gameid, 0 AS kpisale, 0.0 AS salerate,0 AS kpiincome, 0.0 AS income,0.0 AS incomerate,0.0 AS saleincomerate  FROM \n(SELECT DISTINCT aporderid FROM rebateorder WHERE orderTime>=? AND orderTime<=?) o \nINNER JOIN rebateapply r ON o.aporderid=r.aporderid \nWHERE (r.checkstatus=-1 OR r.checkstatus=0 OR r.checkstatus=1) GROUP BY r.gameid ";
        ArrayList<String> params = new ArrayList<String>();
        params.add(startDate);
        params.add(endDate);
        List list = this.baseDao.findBySql(RebateReportGameDTO.class, sql, params);
        for (RebateReportGameDTO dto : list) {
            map.put(dto.getGameid(), dto.getFinished());
        }
        return map;
    }

    @Override
    public List<RebateReportOldGameDTO> queryOldGameKpiSumForPerson(String kpiDate) {
        String sql = " SELECT person, SUM(kpi) AS kpitotal, 0.0 AS finished, 0.0 AS kpirate FROM vic_rebate_report_old_game_config WHERE kpiDate=? GROUP BY person ";
        ArrayList<String> params = new ArrayList<String>();
        params.add(kpiDate);
        return this.baseDao.findBySql(RebateReportOldGameDTO.class, sql, params);
    }
}

