package com.xunlei.niux.data.vipgame.dao.openserver;

import com.ferret.common.dao.BaseDaoImpl;
import com.xunlei.niux.data.vipgame.dto.OpenServerBean;
import org.apache.commons.lang.StringUtils;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.stereotype.Service;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

/**
 * Created by jamesjxin on 14-1-17.
 */

public class OpenServerDaoImpl extends BaseDaoImpl implements OpenServerDao {

    @Override
    public List<OpenServerBean> getAllOpenServerList(String todayEnd) {
        final List<OpenServerBean> openServerBeanList = new ArrayList<OpenServerBean>();

        StringBuilder sb = new StringBuilder();
        Object[] args;
        sb.append("select distinct games.gameid,games.gameName,games.gameType,newserver.serverid,gameservers.serverName,gameservers.openTime,seogame.enterGameUrl from \n" +
                "(select gameidbytuijian as gameid,ext1 as serverid from linkinfo where linklocid = '1260') as newserver\n" +
                "left join gameservers on newserver.gameid = gameservers.gameid\n" +
                "left join games on newserver.gameid = games.gameid\n" +
                "left join seogame on games.gameid = seogame.gameid\n" +
                "where seogame.enterGameUrl is not null and seogame.enterGameUrl !='' \n" +
                "and servername is not null and servername != ''\n" +
                "and openTime is not null and openTime != '' \n");

        if(StringUtils.isNotEmpty(todayEnd)){
            sb.append("and openTime <= ? ");
            args = new Object[]{todayEnd};
        }else {
            args = new Object[]{};
        }

        sb.append(" order by openTime DESC limit 1000;");

        getJdbcTemplate().query(sb.toString(), args, new RowCallbackHandler() {
            @Override
            public void processRow(ResultSet resultSet) throws SQLException {
                OpenServerBean serverBean = new OpenServerBean();
                serverBean.setGameId(resultSet.getString("gameid"));
                serverBean.setGameName(resultSet.getString("gameName"));
                serverBean.setGameType(resultSet.getString("gameType"));
                serverBean.setServerId(resultSet.getString("serverid"));
                serverBean.setServerName(resultSet.getString("serverName"));
                serverBean.setOpenTime(resultSet.getString("openTime"));
                serverBean.setEnterGameUrl(resultSet.getString("enterGameUrl"));
                openServerBeanList.add(serverBean);
            }
        });

        return openServerBeanList;
    }
}
