package com.xunlei.niux.data.vipgame.bo;

import java.util.ArrayList;
import java.util.List;

import javax.annotation.Resource;

import org.springframework.stereotype.Service;

import com.ferret.common.dao.BaseDao;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.vipgame.vo.YyQuestion;
@Service
public class YyQuestionBoImpl implements YyQuestionBo {
	@Resource(name="BaseDao")
	private BaseDao baseDao;
	public BaseDao getBaseDao() {
		return baseDao;
	}
	public void setBaseDao(BaseDao baseDao) {
		this.baseDao = baseDao;
	}
	@Override
	public List<YyQuestion> find(YyQuestion question, Page page) {
		if(question==null){
			return new ArrayList<YyQuestion>();
		}
		return baseDao.findByObject(YyQuestion.class, question, page);
	}

	@Override
	public YyQuestion find(long seqId) {
		return baseDao.findById(YyQuestion.class, seqId);
	}

	@Override
	public void update(YyQuestion question) {
		baseDao.updateById(question);
	}

	@Override
	public void insert(YyQuestion question) {
		baseDao.insert(question);
	}

	@Override
	public void delete(long seqId) {
		baseDao.deleteById(YyQuestion.class, seqId);
	}
	public int count(YyQuestion question){
		if(question==null){
			return 0;
		}
		return baseDao.count(question);
	}
}
