/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.data.vipgame.bo.vic;

import com.ferret.common.dao.BaseDao;
import com.xunlei.niux.data.vipgame.bo.vic.RebateReportBo;
import com.xunlei.niux.data.vipgame.dto.vic.RebateReportGameDTO;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Service;

@Service
public class RebateReportBoImpl
implements RebateReportBo {
    private BaseDao baseDao;

    public BaseDao getBaseDao() {
        return this.baseDao;
    }

    public void setBaseDao(BaseDao baseDao) {
        this.baseDao = baseDao;
    }

    @Override
    public Map<String, Object> queryRebateReportPersonByDate(String startDate, String endDate, String person) {
        String sql = " SELECT SUM(r.money) AS finished FROM rebateapply r \n WHERE r.applyTime>=? AND r.applyTime<=? and r.inputBy=?";
        ArrayList<String> params = new ArrayList<String>();
        params.add(startDate);
        params.add(endDate);
        params.add(person);
        return this.baseDao.findForMap(sql, params);
    }

    @Override
    public Map<String, Object> queryRebateReportByDate(String startDate, String endDate) {
        String sql = " SELECT SUM(r.money) as money FROM rebateapply r \n WHERE r.applyTime>=? AND r.applyTime<=? ";
        ArrayList<String> params = new ArrayList<String>();
        params.add(startDate);
        params.add(endDate);
        return this.baseDao.findForMap(sql, params);
    }

    @Override
    public List<RebateReportGameDTO> queryRebateReportGameByDate(String startDate, String endDate, String kpiDate) {
        String sql = "SELECT k.gameid, a.finished, k.kpi, 0.0 AS kpirate, 0.0 AS payrate, 0.0 payMoney FROM \n (SELECT r.gameid AS gameid, SUM(r.money) AS finished FROM rebateapply r \n WHERE r.applyTime>=? AND r.applyTime<=? GROUP BY r.gameid) AS a \n right JOIN vic_kpi_game k ON a.gameid=k.gameid WHERE k.kpidate=? ";
        ArrayList<String> params = new ArrayList<String>();
        params.add(startDate);
        params.add(endDate);
        params.add(kpiDate);
        return this.baseDao.findBySql(RebateReportGameDTO.class, sql, params);
    }
}

